----------------------------------------------------------------------------------------------------------
-- 
----------------------------------------------------------------------------------------------------------
ActionPlayer=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:constructor()
		self.name = "ActionPlayer";

		-- s֐o^ ꕔAt[i߂͎̂gB
		self.playingMethods = {};
		self.playingMethods[1] = self.phase_keyReset;
		self.playingMethods[2] = self.phase_waitAfterMotion;
		self.playingMethods[3] = self.phase_inputCommand;
		self.playingMethods[4] = self.phase_waitChangeNewAction;
		self.playingMethods[5] = self.phase_afterChangeNewAction;
		self.playingMethods[6] = self.phase_frameWait;
		--self.playingMethods[7] = self.phase_terminate;

		self:reset();
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:reset()
		self.playing = false;
		self.playingCaptureInfo = nil;
		self.playingMotion = nil;
		self.waitFrame = 0;
		self.waitChangeActionFrame = 0;
		self.phase = 1;
		self.elapsFrame = 0;
		key_reset();
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:initialize(captureInfo)
		if (captureInfo == nil)
		then
			logger:trace(self.name, "IsȂ");
			yield(); -- Iɐi߂B
			return;
		end

		if (self.playingCaptureInfo ~= nil)
		then
			logger:warn(self.name, "Ȃ͂Ă");
			yield(); -- Iɐi߂B
			return;
		end

		self.playing = true;
		self.playingCaptureInfo = captureInfo;
	
		-- łɓsƂĘAłĂԂ
		-- ႦΉAłĂŒɁA܂AgpƂP[XB
		if (captureInfo.act == getTargetCurrentAction(TARGET_MY))
		then
			logger:debug(self.name, "sAł悤ƂĂ̂ŉȂB my_act : " .. getTargetCurrentAction(TARGET_MY));
			self:reset();
			yield(); -- Iɐi߂B
			return;
		end
		--[[
		]]--

		-- slɑ΂MotionCX^X擾
		self.playingMotion = motionMapping:get(captureInfo.act);

		-- ΉMotionCX^XȂΉȂB
		if (self.playingMotion == nil)
		then
			logger:warn(self.name, "Ή郂[VMappingȂ : " .. self.playingCaptureInfo.act);
			self:reset();
			yield(); -- Iɐi߂B
			return;
		end

		logger:info(self.name, "play() sJn : " .. self.playingMotion.name);

		-- J[hs̏ꍇƏoĂ邩mFB ]֐łĂ邯ǈꉞB
		if (isCardUseMotion(self.playingCaptureInfo.act) and 
			(not ((my_card == self.playingCaptureInfo:getParameter(CaptureInfo_my_card)) and is_card_use)))
		then
			logger:warn(self.name, "J[hpłĂȂB : " .. self.playingCaptureInfo.act .. 
									" captureInfo.my_card:" .. self.playingCaptureInfo:getParameter(CaptureInfo_my_card) ..
									" my_card:" .. my_card ..
									" is_card_use:" .. tostring(is_card_use));
			self:reset();
			yield(); -- Iɐi߂B
			return;
		end
	end

PHASE_STATUS_COMPLETED=0;
PHASE_STATUS_COMPLETED_YIELD=1;
PHASE_STATUS_RUNNING=2;
PHASE_STATUS_BREAK=3;

KEY_EVENT_WAIT=2;
	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:forward()
		local playMethod = self.playingMethods[self.phase];
		if (playMethod == nil)
		then
			logger:warn(self.name, "Đ郁\\bh܂Bphase:" .. self.phase);
			return
		end

		local status = playMethod(self);
		-- s
		if (status == PHASE_STATUS_RUNNING)
		then
			logger:trace(self.name, "Players:" .. self.playingCaptureInfo.act ..
									" phase:" .. self.phase ..
									" status:" .. status ..  
									" playing:" .. tostring(self.playing) .. 
									" L[:" .. getKetStatString());
			self.elapsFrame = self.elapsFrame + 1;
			yield();
			return;
		-- PhaseIꍇ yield()Ȃ
		elseif (status == PHASE_STATUS_COMPLETED)
		then
			logger:debug(self.name, "PlayerPhase:" .. self.playingCaptureInfo.act ..
									" phase:" .. self.phase ..
									" status:" .. status ..  
									" playing:" .. tostring(self.playing) .. 
									" L[:" .. getKetStatString());

			if (#self.playingMethods == self.phase)
			then
				self:reset();
				return;
			end

			self.elapsFrame = self.elapsFrame + 1;
			self.phase = self.phase + 1;
			return;
		-- PhaseIꍇ yield()
		elseif (status == PHASE_STATUS_COMPLETED_YIELD)
		then
			logger:debug(self.name, "PlayerPhaseYield:" .. self.playingCaptureInfo.act ..
									" phase:" .. self.phase .. 
									" status:" .. status ..  
									" playing:" .. tostring(self.playing) .. 
									" L[:" .. getKetStatString());

			if (#self.playingMethods == self.phase)
			then
				self:reset();
				return;
			end

			self.elapsFrame = self.elapsFrame + 1;
			self.phase = self.phase + 1;
			yield();
			return;
		-- 炩̌Œf
		else
			-- PHASE_STATUS_BREAK
			logger:debug(self.name, "Playerf:" .. self.playingCaptureInfo.act ..
									" phase:" .. self.phase .. 
									" status:" .. tostring(status) ..  
									" playing:" .. tostring(self.playing) .. 
									" L[:" .. getKetStatString());
			self:reset();
			return;
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_keyReset()
		-- sĐOɃL[ZbgˁB
		--key_reset();
		return PHASE_STATUS_COMPLETED;
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_waitAfterMotion()
		-- from 161_common_functions.lua isAfterMotion()
		if (isAfterMotion(getTargetCurrentAction(TARGET_MY)))
		then
			logger:debug(self.name, "o߃[V҂ : " .. getTargetCurrentAction(TARGET_MY) ..
									" captureInfo.act:" .. self.playingCaptureInfo.act);
			--wait(1);
			return PHASE_STATUS_RUNNING;
		else
			return PHASE_STATUS_COMPLETED;
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_inputCommand()
		-- motion_mapping Œ`ꂽ{^
		self.playingMotion:action();
		logger:debug(self.name, "{^:" .. getKetStatString() ..
								" :" .. battle_time);
		wait(KEY_EVENT_WAIT); -- ̂߁B
		return PHASE_STATUS_COMPLETED;
		--return PHASE_STATUS_COMPLETED_YIELD; -- yield()Ȃƈ肵ȂB
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_waitChangeNewAction()
		-- {^ʂfꂽ炱̃tF[Y͊
		if (tracer[TARGET_MY]:current().act == self.playingCaptureInfo.act)
		then
			logger:debug(self.name, "sωB" ..
						" phase_waitChangeNewAction() s:" .. self.playingMotion.name  .. 
						" waitChangeActionFrame:" .. self.waitChangeActionFrame .. 
						" my_frame: " .. my_frame .. 
						" cap.frame:" .. self.playingCaptureInfo.frame .. 
						" ҂frame:" .. self.waitChangeActionFrame .. 
						" my_act:" .. my_act .. 
						" ςƔf:" .. battle_time ..
						" cap.motion:" .. self.playingCaptureInfo.act );
			return PHASE_STATUS_COMPLETED;
		end

		-- {^f܂ő҂B
		if (self.waitChangeActionFrame <= WAIT_CHANGE_ACTION_LIMIT)
		then
			self.waitChangeActionFrame = self.waitChangeActionFrame + 1;
			return PHASE_STATUS_RUNNING;
		else
			logger:warn(self.name, "E܂ő҂ĂsωȂB" ..
						" phase_waitChangeNewAction() s:" .. self.playingMotion.name  .. 
						" waitChangeActionFrame:" .. self.waitChangeActionFrame .. 
						" my_frame: " .. my_frame .. 
						" cap.frame:" .. self.playingCaptureInfo.frame .. 
						" ҂frame:" .. self.waitChangeActionFrame .. 
						" my_act:" .. my_act .. 
						" ςȂƔf:" .. battle_time ..
						" cap.motion:" .. self.playingCaptureInfo.act );
			return PHASE_STATUS_BREAK;
		end
		error("phase_waitChangeNewAction");
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_afterChangeNewAction()
		-- Ӗ𐬂Ȃ̂Ŗv
		--self.waitFrame = self.waitFrame - KEY_EVENT_WAIT; -- KeyEventő҂B
		--[[
		if (self.playingMotion:isWaitCutMyFrame())
		then 
			self.waitFrame = self.waitFrame - my_frame; 
			logger:debug(self.name, "waitCutMyFrame s : " .. self.playingMotion.name .. " waitFrame : " .. self.waitFrame .. " my_frame : " .. my_frame);
		end
		]]--

		-- L[Zbg
		if (not self.playingMotion:isDisableKeyReset())
		then
			logger:debug(self.name, "key_reset() after action() s : " .. self.playingMotion.name .. " waitFrame : " .. self.waitFrame .. " my_frame : " .. my_frame);
			key_reset();
		end
		return PHASE_STATUS_COMPLETED;
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_frameWait()
		-- s̏ꍇAst[҂
		if (not self.playingMotion:isDisableWait()) 
		then
			-- AAAAR{s͑Ή
			local waitFrame = self.playingCaptureInfo.frame;
			if (isAComboMotion(tracer[TARGET_MY]:current().act))
			then
				waitFrame = waitFrame - 15; -- s
			end
			--[[
			]]--

			-- tracerƕtĂ̂ŃJbgsvB
			if (tracer[TARGET_MY]:current().frame < waitFrame) 
			then
				return PHASE_STATUS_RUNNING;
			elseif (isIncrementAirMotion(tracer[TARGET_MY]:current().act) and (y > 0) and (my_xspeed < 0) and (y < 20)) -- TODO ӓIȒnd
			then
				logger:debug(self.name, " ӓIframe wait() s : " .. self.playingMotion.name .. 
										" current.frame : " .. tracer[TARGET_MY]:current().frame .. 
										" cap.frame:" .. self.playingCaptureInfo.frame .. 
										" ҂Ɣf:" .. battle_time ..
										" my_frame : " .. my_frame);
				return PHASE_STATUS_COMPLETED;
			else
				logger:debug(self.name, "frame wait() s : " .. self.playingMotion.name .. 
										" current.frame : " .. tracer[TARGET_MY]:current().frame .. 
										" cap.frame:" .. self.playingCaptureInfo.frame .. 
										" ҂Ɣf:" .. battle_time ..
										" my_frame : " .. my_frame);
				return PHASE_STATUS_COMPLETED;
			end
		else
			logger:debug(self.name, " s҂Ȃ frame wait() s : " .. self.playingMotion.name .. 
									" current.frame : " .. tracer[TARGET_MY]:current().frame .. 
									" cap.frame:" .. self.playingCaptureInfo.frame .. 
									" ҂Ɣf:" .. battle_time ..
									" my_frame : " .. my_frame);
			return PHASE_STATUS_COMPLETED;
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionPlayer:phase_terminate()
		self:reset();
		return PHASE_STATUS_COMPLETED;
	end
