require("debug.lua");
if(DEBUG_FUNCTION)
then
	require("101_common_oop.lua");
	require("111_logger.lua");
	require("113_common_collections.lua");
	require("151_common_environment.lua");
	require("152_global_instance.lua");
	require("161_common_functions.lua");
	require("162_round_utils.lua");
	require("201_capture_info.lua");
end
----------------------------------------------------------------------------------------------------------
-- 
--  or G̍sg[XNX
-- 
----------------------------------------------------------------------------------------------------------
MotionTracer=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- RXgN^
	--	
	--		name			: CX^X̖O
	--		target			: g[X^[Qbgw
	--		historicalList	: ۑList HistoricalListNXg܂傤B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:constructor(name, target, historicalList)
		-- Tracer̖O
		self.name = name;
		-- g[XΏ
		self.target = target;
		-- pListCX^X
		self.historicalList = historicalList;
		-- g[X̗L/
		self.enableTrace = true;
	end

	----------------------------------------------------------------------------------------------------------
	-- AΏۂ̍sg[X܂B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:trace()
		while (not battleFinished())
		do
			self:traceMotion();
			yield();
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- Ώۂ̍sg[X܂B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:traceMotion()
		if (not self.enableTrace)
		then
			return;
		end
		-- Lv`Jn
		self:traceMotionFrame();
	end

	----------------------------------------------------------------------------------------------------------
	-- wKΏۂ̍sFrameg[X܂B
	-- ʏAO炱̃\bhĂԕKv͂܂B
	--	see 105_common_functions.lua
	--	߂l
	--		captureInfo	:Lv`ϐQ
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:traceMotionFrame()
		
		local captureInfo = CaptureInfo.new(self.target);
		captureInfo:capture();

		-- čd͂낢Ɩ肪ôŃg[XȂB
		if (captureInfo.act == 2140)
		then
			return;
		end

		-- JnƂƂɗɒǉ
		self.historicalList:add(captureInfo);

		-- 
		local currentFrame = 0;
		local currentAct = captureInfo.act;
		local orgAct = captureInfo.act;

		-- fobOp
		local tempFrame = getTargetFrame(self.target);

		-- st[
		while (currentAct == orgAct)
		do
			if (isIncrementAirMotion(currentAct))
			then
			logger:trace(self.name, "Frame蒆 target:" .. self.target ..
									" orgAct:" .. orgAct ..
									" currentAct:" .. currentAct ..
									" captureInfo.my_air:" .. captureInfo:getParameter(CaptureInfo_my_air) ..
									" my_air:" .. getTargetAir(self.target) ..
									" currentFrame:" .. currentFrame ..
									" targetframe:" .. getTargetFrame(self.target));
			end
			--[[
			]]--
			tempFrame = getTargetFrame(self.target);
			captureInfo:setFrame(currentFrame);

			yield();

			currentFrame = currentFrame + 1;
			currentAct = getTargetCurrentAction(self.target);
		end
		logger:trace(self.name, " g[XΏ : " .. self.target .. 
								" Frame茋 orgAct:" .. orgAct .. 
								" 蓮frame:" .. captureInfo.frame .. 
								" L:" .. captureInfo:getParameter(CaptureInfo_my_char) .. 
								" GL:" .. captureInfo:getParameter(CaptureInfo_enemy_char) .. 
								" frame:" .. tempFrame);
		return;
	end

	----------------------------------------------------------------------------------------------------------
	-- ݃g[X̍sԂ܂B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:current()
		return self.historicalList:current();
	end

	----------------------------------------------------------------------------------------------------------
	-- Õg[Xʂ̍sԂ܂B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:before()
		return self.historicalList:before();
	end

	----------------------------------------------------------------------------------------------------------
	-- g[Xς݂̍ŐVsԂ܂B beforeƂ
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:tracedCurrent()
		return self.historicalList:before();
	end

	----------------------------------------------------------------------------------------------------------
	-- g[XςݍŐVs̈Õg[Xʂ̍sԂ܂B
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:tracedBefore()
		return self.historicalList:get(self.historicalList:size() - 2);
	end

	----------------------------------------------------------------------------------------------------------
	-- wIndex̂ڂg[Xʂ̍sԂ܂B1ȂO = before()ƈꏏB
	----------------------------------------------------------------------------------------------------------
	function MotionTracer:history(index)
		return self.historicalList:get(self.historicalList:size() - index);
	end

tracer={};
function traceThread()
	tracer[TARGET_MY] 	 = MotionTracer.new("Tracer", TARGET_MY, HistoricalList.new(10));
	tracer[TARGET_ENEMY] = MotionTracer.new("GTracer", TARGET_ENEMY, HistoricalList.new(10));

	create_thread(traceMyMotionThread);
	create_thread(traceEnemyMotionThread);
end

function traceMyMotionThread()
	tracer[TARGET_MY]:trace();
end

function traceEnemyMotionThread()
	tracer[TARGET_ENEMY]:trace();
end


function main()

	create_thread(traceThread);
	yield();

	local myMotion = nil;
	local old_myMotion = nil;
	local enemyMotion = nil;
	local old_enemyMotion = nil;
	while (true)
	do
		myMotion = tracer[TARGET_MY]:current();
		enemyMotion = tracer[TARGET_ENEMY]:current();

		if (not myMotion:equals(old_myMotion))
		then
			print("current:", myMotion:serialize());
			if (tracer[TARGET_MY]:before() ~= nil)
			then
				print("before:", tracer[TARGET_MY]:before():serialize());
			end
			old_myMotion = myMotion;
		end
		if (not enemyMotion:equals(old_enemyMotion))
		then
			print("G:", enemyMotion:serialize());
			old_enemyMotion = enemyMotion;
		end
		yield();
	end
end
