----------------------------------------------------------------------------------------------------------
--
--	wKʊi[e[u֘A
--
--		LearnTableCaptureInfõ[VlʂLearnedListB
--
----------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------
--
--	\[gTCYListBwKςListB
--	ےlŃ\[gAےlႢ͓̂BȌpȁB
--
----------------------------------------------------------------------------------------------------------
LearnedList=extends(HistoricalList);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	--		
	--			name		:wKe[u
	--			maxSize		:ێTCY
	--			compareter	:\[g֐ @see 5.5 e[u#table.sort()
	----------------------------------------------------------------------------------------------------------
	function LearnedList:constructor(name, maxSize, compareter)
		self.name = name;
		self.maxSize = maxSize;
		self.compareter = compareter;
	end

	----------------------------------------------------------------------------------------------------------
	--	@Override
	--	TCYӂĂꍇA\[gňԌÂvf폜܂B
	--	insertIndex␳ĂO񥥥ƂĂꂽB
	----------------------------------------------------------------------------------------------------------
	function LearnedList:removeOldestElement()
		self:sort();
		self.super.removeOldestElement(self);
	end

	----------------------------------------------------------------------------------------------------------
	--	w肳ꂽ compareter ɂă\[g܂B
	----------------------------------------------------------------------------------------------------------
	function LearnedList:sort()
		table.sort(self.arrayList, self.compareter);
	end

----------------------------------------------------------------------------------------------------------
--
--	LearnedListFactoryNX
--
----------------------------------------------------------------------------------------------------------
LearnedListFactory=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	--		
	--			name		:ftHgwKe[u
	--			maxSize		:ftHgێTCY
	--			compareter	:ftHg\[g֐ @see 5.5 e[u#table.sort()
	----------------------------------------------------------------------------------------------------------
	function LearnedListFactory:constructor(name, maxSize, compareter)
		self.name = name;
		self.maxSize = maxSize;
		self.compareter = compareter;
	end

	----------------------------------------------------------------------------------------------------------
	-- RXgN^̐ݒɂLearnedListCX^X𐶐܂B
	----------------------------------------------------------------------------------------------------------
	function LearnedListFactory:create(listName)
		local learnedListName = listName;
		if (learnedListName == nil)
		then
			learnedListName = self.name;
		end

		if (self.compareter ~= nil)
		then
			return LearnedList.new(learnedListName, self.maxSize, self.compareter);
		else
			return LearnedList.new(learnedListName, self.maxSize, self:getDefaultCompareter());
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- ftHg̃\[gr֐擾܂B
	----------------------------------------------------------------------------------------------------------
	function LearnedListFactory:getDefaultCompareter()
		return	function(newCaptureInfo, lastCaptureInfo)
					return newCaptureInfo.evaluate < lastCaptureInfo.evaluate;
				end;
	end

----------------------------------------------------------------------------------------------------------
--
--	IndexwKe[uB
--	ĂĂPȂe[uANZXbp[ɉ߂ȂB
--
----------------------------------------------------------------------------------------------------------
LearnTable=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	--		
	--			name				:ftHgwKe[u
	--			learnedListFactory	:LearnedListFactoryCX^X
	----------------------------------------------------------------------------------------------------------
	function LearnTable:constructor(name, learnedListFactory)
		self.name = name;
		self.learnedListFactory = learnedListFactory;
		self.learnedLists = {};
	end

	----------------------------------------------------------------------------------------------------------
	--	wKʂi[܂B
	----------------------------------------------------------------------------------------------------------
	function LearnTable:add(captureInfo)
		if (not self:existsInnerList(captureInfo.act))
		then
			self.learnedLists[captureInfo.act] = self.learnedListFactory:create("[" .. self.name .. ", index:" .. captureInfo.act .. "]");
		end
		self.learnedLists[captureInfo.act]:add(captureInfo);
	end

	----------------------------------------------------------------------------------------------------------
	--	LearnedList݂邩
	----------------------------------------------------------------------------------------------------------
	function LearnTable:existsInnerList(index)
		return self.learnedLists[index] ~= nil;
	end

	function LearnTable:get(index, listIndex)
		return self:getInnerList(index):get(listIndex);
	end

	function LearnTable:getInnerList(index)
		return self.learnedLists[index];
	end

----------------------------------------------------------------------------------------------------------
--
-- K[hAOCYwKptbge[u IndexȂ
--
----------------------------------------------------------------------------------------------------------
FlatLearnTable=extends(LearnTable);
	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	--		
	--			name				:ftHgwKe[u
	--			learnedListFactory	:LearnedListFactoryCX^X
	----------------------------------------------------------------------------------------------------------
	function FlatLearnTable:constructor(name, learnedListFactory)
		self.name = name;
		self.learnedListFactory = learnedListFactory;
		self.learnedLists = {};
	end

	-- @Override
	function FlatLearnTable:add(captureInfo)
		if (#self.learnedLists < 1)
		then
			self.learnedLists[1] = self.learnedListFactory:create("[" .. self.name .. "]");
		end
		self.learnedLists[1]:add(captureInfo);
	end

	-- @Override
	function FlatLearnTable:existsInnerList()
		return self.learnedLists[1] ~= nil;
	end

	-- @Override
	function FlatLearnTable:getInnerList()
		return self.learnedLists[1];
	end

----------------------------------------------------------------------------------------------------------
--
--	wKe[uǗNX
--
----------------------------------------------------------------------------------------------------------
LearnTableManager=extends(Object);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	----------------------------------------------------------------------------------------------------------
	function LearnTableManager:constructor()
		self.learnTables = {};
		self.relationTables = {};
	end

	----------------------------------------------------------------------------------------------------------
	--	wKe[uǉ܂
	--		
	--			name			: wKe[u
	--			maxSize			: wKe[uŎList̃ftHgTCY
	----------------------------------------------------------------------------------------------------------
	function LearnTableManager:addLearnTable(name, maxSize)
		self.learnTables[name] = LearnTable.new(name, self:getDefaultLearnedListFactory(name, maxSize));
		self.relationTables[name] = MotionRelation.new(0);
	end

	----------------------------------------------------------------------------------------------------------
	--	FlatwKe[uǉ܂BK[hAOCYpBsA͂ȂB
	--		
	--			name			: wKe[u
	--			maxSize			: wKe[uŎList̃ftHgTCY
	----------------------------------------------------------------------------------------------------------
	function LearnTableManager:addFlatLearnTable(name, maxSize)
		self.learnTables[name] = FlatLearnTable.new(name, self:getDefaultLearnedListFactory(name, maxSize));
	end

	----------------------------------------------------------------------------------------------------------
	--	wKe[u擾܂B
	--		
	--			name			: wKe[u
	----------------------------------------------------------------------------------------------------------
	function LearnTableManager:getLearnTable(name)
		return self.learnTables[name];
	end

	----------------------------------------------------------------------------------------------------------
	--	sAe[u擾܂B
	--		
	--			name			: wKe[u
	----------------------------------------------------------------------------------------------------------
	function LearnTableManager:getRelationTable(name)
		return self.relationTables[name];
	end

	function LearnTableManager:setRelationTable(name, relation)
		self.relationTables[name] = relation;
	end

	function LearnTableManager:getDefaultLearnedListFactory(name, maxSize)
		return LearnedListFactory.new("", maxSize);
	end
