require("debug.lua");
if(DEBUG_FUNCTION)
then
	require("101_common_oop.lua");
	require("111_logger.lua");
	require("113_common_collections.lua");
	require("151_common_environment.lua");
	require("152_global_instance.lua");
	require("161_common_functions.lua");
	require("162_round_utils.lua");
	require("201_capture_info.lua");
end

----------------------------------------------------------------------------------------------------------
--
-- wK֌W풓
--
----------------------------------------------------------------------------------------------------------
AbstractLearnDaemon=extends(NamedObject);

	function AbstractLearnDaemon:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
	end

	function AbstractLearnDaemon:learn()
		while (not battleFinished())
		do
			self.target = learningTarget;
			self.enable = runningLearning;
			if ((self.enable) and (self.learnSituation(self.target)))
			then
				self:process();
			end
			yield();
		end
	end

	function AbstractLearnDaemon:process()
		error("processĂ");
	end

----------------------------------------------------------------------------------------------------------
--
-- swKNX
--
----------------------------------------------------------------------------------------------------------
LearnMotion=extends(AbstractLearnDaemon);

	function LearnMotion:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
		self.learnTable = learnTableManager:getLearnTable(self.name);	-- wKe[u(LearnTableCX^X 301_learn_table.lua)
		self.beforeLearnedCaptureInfo = nil;
	end

	function LearnMotion:process()

		-- tracedCurrent͂OŁEEEB
		-- from 201_motion_tracer.lua
		local captureInfo = tracer[self.target]:tracedCurrent();
		if (captureInfo == nil)
		then
			return;
		end
		--print(self.name, self.target, tracer[self.target]:tracedCurrent():serialize());

		if (captureInfo.frame < LEARNING_FRAME_BORDER)
		then
			return;
		end

		if (captureInfo:equals(self.beforeLearnedCaptureInfo))
		then
			return;
		end

		if (not self.learnCondition(self.target))
		then
			return;
		end

		self.learnTable:add(captureInfo);
		self.beforeLearnedCaptureInfo = captureInfo;
		logger:debug(self.name, "wKs:" .. captureInfo.act);
	end


----------------------------------------------------------------------------------------------------------
--
-- sAwKNX
--
----------------------------------------------------------------------------------------------------------
LearnRelation=extends(AbstractLearnDaemon);

	function LearnRelation:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
		self.relationTable = learnTableManager:getRelationTable(self.name);
		self.beforeLearnedCaptureInfo = nil;
	end

	function LearnRelation:process()

		-- from 201_motion_tracer.lua
		local captureInfo = tracer[self.target]:tracedCurrent();
		local beforeCaptureInfo = nil;
		if (captureInfo == nil)
		then
			return;
		end

		if (captureInfo.frame < LEARNING_FRAME_BORDER)
		then
			return;
		end

		if (captureInfo:equals(self.beforeLearnedCaptureInfo))
		then
			return;
		end
		
		if (not self.learnCondition(self.target))
		then
			return;
		end

		-- ǂpȂ̂łB˂悭Ȃ
		if (not isRelativeMotion(captureInfo.act))
		then
			return;
		end

		-- tracer̗đOsɑ̂
		-- tracedBeforeȂ̂ŊJnIndex2
		for i = 2, 5
		do
			beforeCaptureInfo = tracer[self.target]:history(i);
			if (beforeCaptureInfo == nil)
			then
				break;
			end

			if (isRelativeMotion(beforeCaptureInfo.act))
			then
				-- AI؂ւ̃XL}Ή act == 0 ͂肦ȂB
				if (not self.relationTable:hasNextMotion(beforeCaptureInfo.act))
				then
					self.relationTable:addNextMotion(MotionRelation.new(beforeCaptureInfo.act));
					self.relationTable.frequency[beforeCaptureInfo.act] = 0;
				end
				break;
			end
		end

		if (beforeCaptureInfo == nil)
		then
			-- AwKs\
			return;
		end

		if (beforeCaptureInfo.act == 0)
		then
			-- _Ƃ݂Ȃ
			self:registMotionRelation(self.relationTable, MotionRelation.new(captureInfo.act));
		else
			-- self.relationTableɂȂƂB
			self:registMotionRelation(self.relationTable:getNextMotion(beforeCaptureInfo.act), MotionRelation.new(captureInfo.act));
		end
		self.beforeLearnedCaptureInfo = captureInfo;
	end

	function LearnRelation:registMotionRelation(targetMotionRelation, addMotionRelation)
		targetMotionRelation:addNextMotion(addMotionRelation);

		-- ŏ̈񂾂 root ɕۑBقƂfrequency = 0 ǂˁB܂B˃_
		if (not self.relationTable:hasNextMotion(addMotionRelation.act))
		then
			self.relationTable:addNextMotion(addMotionRelation);
			if (not isRootMotion(addMotionRelation.act))
			then
				self.relationTable.frequency[addMotionRelation.act] = 0;
			end
		end
	end
