require("debug.lua");
if(DEBUG_FUNCTION)
then
	require("101_common_oop.lua");
end
----------------------------------------------------------------------------------------------------------
--
-- ǂłgRNVnʃNXQ
--
--		EArrayList			:Ȃ񂿂ArrayList(Vector݂Ȃ)
--		EHistoricalList	:TCYList ɗێp ArrayListpB
--		ELearnedList		:TCYList ɊwKʕێp HistoricalListpB
--		EAverageCalculator	:dώZoNX
--
----------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------
--
--	Ȃ񂿂ėArrayList
--	PȂTable색bp[ɂȂ艺Ă܂B
--	R}`XbhȂ񂼍lĂȂ̂ŋC܂傤B
--
----------------------------------------------------------------------------------------------------------
ArrayList=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	----------------------------------------------------------------------------------------------------------
	function ArrayList:constructor()
		self.name = "ArrayList";
		self.arrayList = {};	-- ێ̃e[u
	end

	----------------------------------------------------------------------------------------------------------
	--	wIndex̗vf擾܂B
	--	̑Ó`FbNȂĂ܂B
	--		
	--			index		:قʒu
	----------------------------------------------------------------------------------------------------------
	function ArrayList:get(index)
		return self.arrayList[index];
	end

	----------------------------------------------------------------------------------------------------------
	--	vf𖖔ɒǉ܂B
	--		
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function ArrayList:add(element)
		table.insert(self.arrayList, element);
	end

	----------------------------------------------------------------------------------------------------------
	--	wʒuɗvf}܂
	--		
	--			index		:}ʒu
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function ArrayList:insert(index, element)
		table.insert(self.arrayList, index, element);
	end

	----------------------------------------------------------------------------------------------------------
	--	wIndex̗vfwvfɒu܂B
	--	̑Ó`FbNȂĂ܂B
	--		
	--			index		:uʒu
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function ArrayList:set(index, element)
		-- qgƎq̃I[o[Chꂽ\bhgꂿႤ̂łB
		table.remove(self.arrayList, index);
		table.insert(self.arrayList, index, element);
	end

	----------------------------------------------------------------------------------------------------------
	--	wIndex̗vf폜܂B
	--	̑Ó`FbNȂĂ܂B
	--		
	--			index		: 1`MaxSizew
	----------------------------------------------------------------------------------------------------------
	function ArrayList:remove(index)
		table.remove(self.arrayList, index);
	end

	----------------------------------------------------------------------------------------------------------
	--	ێĂvfԂ܂B
	----------------------------------------------------------------------------------------------------------
	function ArrayList:size()
		return #self.arrayList;
	end

	----------------------------------------------------------------------------------------------------------
	-- ێvfׂStringŌĕԂ܂B
	----------------------------------------------------------------------------------------------------------
	function ArrayList:toString()
		return "[" .. self.name .. "] " .. table.concat(self.arrayList, ", ");
	end

----------------------------------------------------------------------------------------------------------
--
--	TCYList
--		ێTCYI[o[̏ꍇAԌÂvf폜܂B
--		XV񓯊łƂɂȂ邱ƐB
--
----------------------------------------------------------------------------------------------------------
HistoricalList=extends(ArrayList);

	----------------------------------------------------------------------------------------------------------
	--	RXgN^
	--		
	--			maxSize		:ێTCY
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:constructor(maxSize)
		--self.super:constructor();	-- extends()ŌĂяo悤ύX
		self.name = "HistoricalList";
		self.maxSize = maxSize;		-- őTCY
	end

	----------------------------------------------------------------------------------------------------------
	--	@Override
	--	vf𖖔ɒǉ܂B
	--	TCYI[o[̏ꍇAԌÂvf폜ĐVɒǉ܂B
	--		
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:add(element)
		-- u:v ł͂Ȃ u.v ŌĂł̂|Cg
		--print(self.name, element:serialize());
		--self.super.add(self, element) TODO ȂƂȂƁB
		ArrayList.add(self, element)
		self:removeOldestElement();
	end

	----------------------------------------------------------------------------------------------------------
	--	@Override
	--	wʒuɗvf}܂
	--	TCYI[o[̏ꍇAԌÂvf폜ĐVɒǉ܂B
	--		
	--			index		:}ʒu
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:insert(index, element)
		assert(false, "HistoricalList: insert\\bh͖ΉB낢Ɩ肪cB");
	end

	----------------------------------------------------------------------------------------------------------
	--	@Override
	--	wIndex̗vfwvfɒu܂B
	--	̑Ó`FbNȂĂ܂B
	--	windex͈͂𒴂ĂꍇG[ƂȂ܂B
	--		
	--			index		:uʒu
	--			element		:vfBȂłB
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:set(index, element)
		assert(false, "HistoricalList: set\\bh͖ΉB낢Ɩ肪cB");
	end

	----------------------------------------------------------------------------------------------------------
	--	ԐVvf擾܂B
	--		߂l
	--			ԐVvf
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:current()
		return self:get(self:size());
	end

	----------------------------------------------------------------------------------------------------------
	--	ŐV̂ЂƂOɒǉꂽvf擾܂B
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:before()
		if (self:size() < 2)
		then
			return nil;
		end
		return self:get(self:size() - 1);
	end

	----------------------------------------------------------------------------------------------------------
	--	TCYӂĂꍇAԌÂvf폜܂B
	--	insertIndex␳ĂO񥥥ƂĂꂽB
	----------------------------------------------------------------------------------------------------------
	function HistoricalList:removeOldestElement()
		--print(self.maxSize);
		if (self:size() > self.maxSize)
		then
			self:remove(1);
		end
	end

----------------------------------------------------------------------------------------------------------
--
-- ϒlZoNX
--	ӖcollectionƂȂ̂łɁEEEB
--
----------------------------------------------------------------------------------------------------------
AverageCalculator=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- RXgN^
	----------------------------------------------------------------------------------------------------------
	function AverageCalculator:constructor()
		self.values={};			-- lێe[u
		self.weights={};		-- dݕێe[u
	end

	----------------------------------------------------------------------------------------------------------
	-- lZbg܂B
	--	
	--		value		:l
	--		weight		:d
	----------------------------------------------------------------------------------------------------------
	function AverageCalculator:addValue(value, weight)
		table.insert(self.values, value);
		table.insert(self.weights, weight);
	end

	----------------------------------------------------------------------------------------------------------
	-- dςZo܂B
	----------------------------------------------------------------------------------------------------------
	function AverageCalculator:average()
		local sum = 0;
		local weightSum = 0;
		for key, value in pairs(self.values)
		do
			sum = sum + (value * self.weights[key]);
			weightSum = weightSum + self.weights[key];
		end

		logger:trace("AverageCalculator", "sum : " .. sum .. " weightSum:" .. weightSum);

		return sum / weightSum;
	end


----------------------------------------------------------------------------------------------------------
-- ȉAeXgp
----------------------------------------------------------------------------------------------------------
function main()
	
	local result = ArrayList.new();
	result:add("ElementA");
	print(result:size(), result:toString(), result:get(1));
	result:remove(1);

	result:add("ElementA");
	result:add("ElementB");
	print(result:size(), result:toString(), result:get(2));

	result:insert(2, "ElementB'");
	print(result:size(), result:toString(), result:get(2));

	result:set(2, "ElementBB");
	print(result:size(), result:toString(), result:get(2));
	result:set(1, "ElementAA");
	print(result:size(), result:toString(), result:get(2));

	local history = HistoricalList.new(5);
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist1");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist2");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist3");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist4");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist5");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist6");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist7");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist8");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("hist9");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("histA");
	print(history:size(), history:toString(), history:current(), history:before());
	history:add("histB");
	print(history:size(), history:toString(), history:current(), history:before());

	--[[
	history:set(1, "hist1.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	history:set(2, "hist2.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	history:set(3, "hist3.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	history:set(4, "hist4.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	history:set(5, "hist5.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	-- ꂢ̂Ęb邪邢̂ŖڂԂ
	history:set(6, "hist6.1");
	print(history:size(), history:toString(), history:peek(), history:getBeforeElement());
	]]--

	while true
	do
		yield();
	end
end