#include <windows.h>
#include <tchar.h>

#include <boost/assert.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/type_traits/remove_pointer.hpp>
#include <boost/filesystem.hpp>

void MyCloseHandle(HANDLE handle) {
	if(handle != NULL) {
		::CloseHandle(handle);
	}
}

typedef boost::shared_ptr<boost::remove_pointer<HANDLE>::type> SHARED_HANDLE;

SHARED_HANDLE MyCreateFile(const wchar_t *path, DWORD access_mode, DWORD share_mode,  DWORD create_mode) {
	SHARED_HANDLE ret;
	HANDLE ptr = ::CreateFileW(path, access_mode, share_mode, NULL, create_mode, 0, NULL);
	if(ptr != NULL) {
		ret.reset(ptr, MyCloseHandle);
	}
	return ret;
}

class CryptHash {
public:
	CryptHash() : prov(NULL), hash(NULL) {
	}
	~CryptHash() {
		if(hash != NULL) {
			const BOOL result = ::CryptDestroyHash(hash);
			BOOST_ASSERT(result != FALSE);
		}
		if(prov != NULL) {
			const BOOL result = ::CryptReleaseContext(prov, 0);
			BOOST_ASSERT(result != FALSE);
		}
	}
	bool Initialize(void) {
		if(FALSE == ::CryptAcquireContextW(&prov, NULL, NULL, PROV_RSA_FULL, CRYPT_VERIFYCONTEXT)) {
			return false;
		}
		if (FALSE == ::CryptCreateHash(prov, CALG_MD5, 0, 0, &hash)) {
			return false;
		}
		return true;
	}
	bool AddData(const BYTE *buffer, unsigned int buffer_size) {
		if(FALSE == ::CryptHashData(hash, buffer, buffer_size, 0)) {
			return false;
		}
		return true;
	}
	bool GetValue(BYTE *buffer, DWORD buffer_size) const {
		DWORD ret_size = buffer_size;
		if(FALSE == ::CryptGetHashParam(hash, HP_HASHVAL, NULL, &ret_size, 0) || ret_size != buffer_size) {
			return false;
		}
		if(FALSE == ::CryptGetHashParam(hash, HP_HASHVAL, buffer, &ret_size, 0)) {
			return false;
		}
		return true;
	}
protected:
	HCRYPTPROV prov;
	HCRYPTHASH hash;
};

bool getSWRSHash(BYTE retVal[16]) {
	CryptHash hash;
	if(!hash.Initialize()) {
		return false;
	}

	wchar_t swrs_path[MAX_PATH];
	if(FALSE == ::GetModuleFileNameW(NULL, swrs_path, MAX_PATH)) {
		return false;
	}

	SHARED_HANDLE file = MyCreateFile(swrs_path, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	if(!file) {
		return false;
	}

	while(true) {
		BYTE buff[1024];
		DWORD readSize;
		if(FALSE == ::ReadFile(file.get(), buff, sizeof(buff), &readSize, NULL)) {
			return false;
		}
		if(readSize == 0) {
			break;
		}

		if(!hash.AddData(buff, readSize)) {
			return false;
		}
	}

	if(!hash.GetValue(retVal, 16)) {
		return false;
	}
	return true;
}

bool Hook(HMODULE this_module) {
	BYTE hash[16];
	if (!getSWRSHash(hash)) {
		return false;
	}

	wchar_t app_dir_impl[MAX_PATH];
	if(FALSE == ::GetModuleFileNameW(NULL, app_dir_impl, MAX_PATH)) {
		return false;
	}
	const boost::filesystem::path app_dir = boost::filesystem::path(app_dir_impl).remove_filename();
	const boost::filesystem::path setting_path = app_dir / "SWRSToys.ini";

	TCHAR moduleKeys[1024];
	TCHAR moduleValue[MAX_PATH];
	::GetPrivateProfileStringW(L"Module", NULL, NULL, moduleKeys, sizeof(moduleKeys), setting_path.c_str());
	for(TCHAR *key = moduleKeys; *key; key += ::_tcslen(key) + 1) {
		::GetPrivateProfileStringW(L"Module", key, NULL, moduleValue, sizeof(moduleValue), setting_path.c_str());
		const boost::filesystem::path module_path = app_dir / moduleValue;

		HMODULE module = ::LoadLibraryW(module_path.c_str());
		if(module != NULL) {
			bool (* const CheckVersion)(const BYTE[16]) = reinterpret_cast<bool (*)(const BYTE[16])>(::GetProcAddress(module, "CheckVersion"));
			bool (* const Initialize)(HMODULE, HMODULE) = reinterpret_cast<bool (*)(HMODULE, HMODULE)>(::GetProcAddress(module, "Initialize"));
			if(CheckVersion == NULL || Initialize == NULL || !CheckVersion(hash) || !Initialize(module, this_module)) {
				::FreeLibrary(module);
			}
		}
	}

	return true;
}
