#include "pch.hpp"
#include "TH145AddrDef.h"
#include "Hengokuroku.hpp"

static void (*GiveTH145IO)();
static HMODULE (*GetTH145ModuleHandle)();
static BOOL(*ReadTH145ProcessMemory)(LPCVOID lpBaseAddress, LPVOID lpBuffer, SIZE_T nSize, SIZE_T * lpNumberOfBytesRead);
static bool(*TH145Exists)();

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define POLL_INTERVAL 50

#define SQSTRING_LIMIT 260

#define Default_CoreBase        0x00543fc4
#define Default_TH145GiveIOPath _T("GiveTH145IO.DLL")

static TH145CHARNAME s_charNames[] = {
	{ _T("얲"), _T("얲") },
	{ _T("J"), _T("") },
	{ _T("_"), _T("") },
	{ _T("@"), _T("@") },
	{ _T("zs"), _T("zs") },
	{ _T("L_q"), _T("_q") },
	{ _T("͏ɂƂ"), _T("ɂƂ") },
	{ _T("Ön"), _T("") },
	{ _T("b}~]E"), _T("}~]E") },
	{ _T("`"), _T("") },
	{ _T("؉ؐ"), _T("ؐ") },
	{ _T("g"), _T("g") },
	{ _T("j"), _T("j") },
	{ _T("F俎q"), _T("俎q") }
};

static TCHAR s_TH145GiveIOPath[256];

static DWORD s_CoreBase;

static HWND   s_ThWnd;
static DWORD  s_TH135Base;

static HWND s_callbackWnd;
static int  s_callbackMsg;

static HANDLE s_userThread;
static HANDLE s_thread;
static DWORD s_threadId;

static int s_paramOld[TH145PARAM_MAX];
static Minimal::ProcessHeapStringA s_paramStr;

static TH145STATE s_TH145State;

static void TH145LoadProfile()
{
#define LoadAddress(N) { TCHAR addrStr[16]; \
	s_##N = profile.ReadString(_T("Address"), _T(#N), _T(""), addrStr, sizeof addrStr); \
	if (!::StrToIntEx(addrStr, STIF_SUPPORT_HEX, reinterpret_cast<int *>(&s_##N))) s_##N = Default_##N;  }
#define LoadChar(N) profile.ReadString(_T("TH145"), _T(#N), Default_##N, s_##N, sizeof s_##N)

	Minimal::ProcessHeapPath profPath = g_appPath;
	CProfileIO profile(profPath /= _T("TH145Addr.ini"));
	LoadAddress(CoreBase);
	LoadChar(TH145GiveIOPath);
}

// strtok ̂悤 iterator class
class StringSplitter {
private:
	Minimal::ProcessHeapStringA buff;
	LPCSTR begin;
	LPCSTR end;
	char sep;

public:
	StringSplitter(LPCSTR src, char separator):
		begin(src), end(src), sep(separator) {}

public:
	LPCSTR Next() {
		if (begin == NULL) return NULL;
		end = ::StrChrA(begin, sep);
		if (end == NULL) {
			buff = begin;
			begin = end;
		} else {
			buff = Minimal::ProcessHeapStringA(begin, end).GetRaw();
			begin = end + 1;
		}
		return buff.GetRaw();
	}
};

// CoreBase class instance ɂ SQVM instance  Root Table  w肳ꂽpX item value  fetch
static bool FindRTChild(LPCSTR path, DWORD &retType, DWORD &retVal)
{
	DWORD_PTR items;
	DWORD_PTR itemVal;
	DWORD_PTR itemVal2;
	DWORD itemType;
	DWORD itemNum;
	DWORD itemLen;
	DWORD itemIndex;
	DWORD readSize;
	BOOL ret;
	DWORD j;

	// CoreBase  table ǂݍ
	ret = ::ReadTH145ProcessMemory((LPVOID)(s_TH135Base + s_CoreBase), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;
	ret = ::ReadTH145ProcessMemory((LPVOID)((DWORD_PTR)itemVal + 0x34), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;

	itemType = 0x20;

	StringSplitter tokenizer(path, '/');
	LPCSTR pathToken;
	while (pathToken = tokenizer.Next()) {
		switch(itemType & 0xFFFFF) {
		case 0x20:	// TABLE
			// Table ̏ǂݍ
			ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Table items T
			for (j = 0; j < itemNum; ++j) {
				// Table item key ǂݍ
				ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x0c), &itemVal, sizeof itemVal, &readSize);
				if (!ret) return false;
				//  Table item key ̂Ƃ󂯕t
				if ((itemType & 0xFFFFF) == 0x10) {	
					//  Table item key 𕶎Ƃēǂݍ
					ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x14), &itemLen, sizeof itemLen, &readSize);
					if (!ret) return false;
					if (itemLen < SQSTRING_LIMIT) {
						Minimal::ProcessHeapArrayT<char> key(itemLen + 1);
						ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x1C), key.GetRaw(), itemLen, &readSize);
						if (!ret) return false;
						key[itemLen] = 0;
						// Table item key ̒l path ̃g[Nƈv table item value ǂݍ
						if (::lstrcmpA(key.GetRaw(), pathToken) == 0) {
							ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
							if (!ret) return false;
							ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x04), &itemVal, sizeof itemVal, &readSize);
							if (!ret) return false;
							break;
						}
					}
				}
			}
			if (j == itemNum) return false;
			break;
		case 0x40:	// ARRAY
			// Array item ̐擪AhX item ǂݍ
			ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x1C), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Path ̃g[N Array item  index ƌȂĔ͈̓`FbN
			itemIndex = StrToIntA(pathToken);
			if(itemNum <= itemIndex) return false;
			// Array item ǂݍ
			ret = ::ReadTH145ProcessMemory((LPVOID)(items + itemIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(items + itemIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
			if (!ret) return false;
			break;
		case 0x8000:	// INSTANCE
			// Instance members ̏ǂݍ
			ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x1C), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(items + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(items + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			ret = ::ReadTH145ProcessMemory((LPVOID)(items + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			// Instance members T
			for (j = 0; j < itemNum; ++j) {
				// Instance member metadata value ǂݍ
				ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x04), &itemVal2, sizeof itemVal, &readSize);
				if (!ret) return false;
				// Instance member metadata value LȂƂ󂯕t
				if ((itemType & 0xFFFFF) == 0x02) {
					// Instance member metadata value  instance member type  instance member index 𒊏o
					DWORD memberType  = itemVal2 & 0xFF000000;
					DWORD memberIndex = itemVal2 & 0x00FFFFFF;
					// Instance member type LȂƂ󂯕t
					if (memberType == 0x02000000) {
						// Instance member metadata key ǂݍ
						ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
						if (!ret) return false;
						ret = ::ReadTH145ProcessMemory((LPVOID)(items + j * 0x14 + 0x0c), &itemVal2, sizeof itemVal, &readSize);
						if (!ret) return false;
						// Instance member metadata key ̂Ƃ󂯕t
						if ((itemType & 0xFFFFF) == 0x10) {
							//  Instance member metadata key 𕶎Ƃēǂݍ
							ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal2 + 0x14), &itemLen, sizeof itemLen, &readSize);
							if (!ret) return false;
							if (itemLen < SQSTRING_LIMIT) {
								Minimal::ProcessHeapArrayT<char> key(itemLen + 1);
								ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal2 + 0x1C), key.GetRaw(), itemLen, &readSize);
								if (!ret) return false;
								key[itemLen] = 0;
								// Instance member metadata key ̒l path ̃g[Nƈv instance member value ǂݍ
								if (::lstrcmpA(key.GetRaw(), pathToken) == 0) {
									ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
									if (!ret) return false;
									ret = ::ReadTH145ProcessMemory((LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
									if (!ret) return false;
									break;
								}
							}
						}
					}
				}
			}
			if (j == itemNum) return false;
			break;
		}
	}

	retType = itemType;
	retVal = itemVal;
	return true;
}

// Squirrel item value  string  fetch
static bool RTChildToString(DWORD_PTR childVal, Minimal::ProcessHeapStringA &out)
{
	DWORD strLen;
	DWORD readSize;
	BOOL ret;

	ret = ::ReadTH145ProcessMemory((LPVOID)(childVal + 0x14), &strLen, sizeof strLen, &readSize);
	if (!ret) return false;
	if (strLen >= SQSTRING_LIMIT) return false;
	Minimal::ProcessHeapArrayT<char> buff(strLen + 1);
	ret = ::ReadTH145ProcessMemory((LPVOID)(childVal + 0x1C), buff.GetRaw(), strLen, &readSize);
	if (!ret) return false;
	buff[strLen] = 0;
	out = buff.GetRaw();
	return true;
}

static void APIENTRY InterruptAPCCallback(ULONG_PTR)
{
}

static void TH145Callback(short Msg, short param1, int param2)
{
	if (s_callbackWnd) {
		::PostMessage(s_callbackWnd, s_callbackMsg, MAKELONG(Msg, param1), param2);
	}
}

static TH145STATE TH145StateFindWindow()
{
	if (TH145Exists()) {
		s_TH135Base = (DWORD)GetTH145ModuleHandle();
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_WAITFORNETBATTLE, 0);
		::ZeroMemory(s_paramOld, sizeof s_paramOld);
		return TH145STATE_WAITFORNETBATTLE;
	} else {
		return TH145STATE_NOTFOUND;
	}
}

static TH145STATE TH145StateWaitForNetBattle()
{
	if (!TH145Exists()) {
		s_ThWnd = nullptr;
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_NOTFOUND, 0);
		return TH145STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		return TH145STATE_NETBATTLE;
	} else {
		return TH145STATE_WAITFORNETBATTLE;
	}
}

static TH145STATE TH145StateNetBattle()
{
	if (!TH145Exists()) {
		s_ThWnd = nullptr;
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_NOTFOUND, 0);
		return TH145STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		int param;
		for (int i = 0; i < TH145PARAM_MAX; ++i) {
			if ((param = TH145AddrGetParam(i)) != -1) {
				if (param != s_paramOld[i])
					TH145Callback(TH145MSG_PARAMCHANGE, i, param);
				s_paramOld[i] = param;
			} else s_paramOld[i] = 0;
		}
		return TH145STATE_NETBATTLE;
	} else {
		return TH145STATE_WAITFORNETBATTLE;
	}
}

static DWORD WINAPI TH145AddrWorkThread(LPVOID)
{
	MSG msg;

	s_TH145State = TH145STATE_NOTFOUND;
	while(!::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) || msg.message != WM_QUIT) {
		switch(s_TH145State) {
		case TH145STATE_NOTFOUND:            s_TH145State = TH145StateFindWindow(); break;
		case TH145STATE_WAITFORNETBATTLE:    s_TH145State = TH145StateWaitForNetBattle(); break;
		case TH145STATE_NETBATTLE:           s_TH145State = TH145StateNetBattle(); break;
		};
		::SleepEx(POLL_INTERVAL, TRUE);
	}
	::ExitThread(0);
	return 0;
}

int TH145AddrInit(HWND callbackWnd, int callbackMsg)
{
	TH145LoadProfile();

	HMODULE giveio = LoadLibrary(s_TH145GiveIOPath);
	*(FARPROC*)&GiveTH145IO = GetProcAddress(giveio, "GiveTH145IO");
	*(FARPROC*)&GetTH145ModuleHandle = GetProcAddress(giveio, "GetTH145ModuleHandle");
	*(FARPROC*)&ReadTH145ProcessMemory = GetProcAddress(giveio, "ReadTH145ProcessMemory");
	*(FARPROC*)&TH145Exists = GetProcAddress(giveio, "TH145Exists");
	if (GiveTH145IO == nullptr || GetTH145ModuleHandle == nullptr || ReadTH145ProcessMemory == nullptr || TH145Exists == nullptr) {
		return 0;
	}
	GiveTH145IO();

	s_callbackWnd = callbackWnd;
	s_callbackMsg = callbackMsg;
	s_thread = ::CreateThread(NULL, 0, TH145AddrWorkThread, NULL, 0, &s_threadId);
	s_userThread = ::GetCurrentThread();
	return s_thread != NULL;
}

int TH145AddrFinish()
{
	if (s_thread) {
		::PostThreadMessage(s_threadId, WM_QUIT, 0, 0);
		::QueueUserAPC(InterruptAPCCallback, s_thread, 0);
		::WaitForSingleObject(s_thread, INFINITE);
		::CloseHandle(s_thread);
	}
	return 0;
}

TH145STATE TH145AddrGetState()
{
	return s_TH145State;
}

DWORD_PTR TH145AddrGetParam(int param)
{
	DWORD childType, childVal, readSize;

	switch(param) {
	case TH145PARAM_BATTLESTATE:
		if (::FindRTChild("game/battleState", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH145PARAM_ISNETCLIENT:
		if (::FindRTChild("network_is_client", childType, childVal) && (childType & 0xFFFFF) == 0x08) { 
			return childVal;
		}
		break;
	case TH145PARAM_P1CHAR:
		if (::FindRTChild("load_data/player/0", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH145PARAM_P2CHAR:
		if (::FindRTChild("load_data/player/1", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH145PARAM_P1WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p1/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH145PARAM_P2WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p2/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH145PARAM_TOADDR:
		if ((::FindRTChild("mb_client", childType, childVal) && (childType & 0xFFFFF) == 0x8000) || (::FindRTChild("mb_server", childType, childVal) && (childType & 0xFFFFF) == 0x8000)) {
			if (::ReadTH145ProcessMemory((LPCVOID)(childVal + 0x20), &childVal, sizeof childVal, &readSize) && readSize == 4) {
				if (::ReadTH145ProcessMemory((LPCVOID)(childVal + 0x10), &childVal, sizeof childVal, &readSize) && readSize == 4) {
					if (::ReadTH145ProcessMemory((LPCVOID)(childVal + 0x23C), &childVal, sizeof childVal, &readSize) && readSize == 4) {
						return childVal;
					}
				}
			}
		}
		break;
	case TH145PARAM_P1NAME:
		if (::FindRTChild("load_data/profile/0/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, s_paramStr)) { 
			return (DWORD_PTR)s_paramStr.GetRaw();
		}
		break;
	case TH145PARAM_P2NAME:
		if (::FindRTChild("load_data/profile/1/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, s_paramStr)) {
			return (DWORD_PTR)s_paramStr.GetRaw();
		}
		break;
	}
	return -1;
}

const TH145CHARNAME * const TH145AddrGetCharName(int index)
{
	if (TH145AddrGetCharCount() <= index) return NULL;
	return &s_charNames[index];
}

int TH145AddrGetCharCount()
{
	return _countof(s_charNames);
}
