#ifndef TH145ADDRDEF_H_INCLUDED
#define TH145ADDRDEF_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

enum TH145CBMSG {
	TH145MSG_STATECHANGE,
	TH145MSG_PARAMCHANGE,
};

enum TH145STATE {
	TH145STATE_NOTFOUND,
	TH145STATE_WAITFORNETBATTLE,
	TH145STATE_NETBATTLE
};

enum TH145SCHAR {
	TH145CHAR_REIMU = 0,
	TH145CHAR_MARISA = 1,
	TH145CHAR_ICHIRIN = 2,
	TH145CHAR_HIJIRI = 3,
	TH145CHAR_FUTO = 4,
	TH145CHAR_MIKO = 5,
	TH145CHAR_NITORI = 6,
	TH145CHAR_KOISHI = 7,
	TH145CHAR_MAMIZOU = 8,
	TH145CHAR_KOKORO = 9,
	TH145CHAR_KASEN = 10,
	TH145CHAR_MOKOU = 11,
	TH145CHAR_SINMYOUMARU = 12,
	TH145CHAR_USAMI = 13,
	TH145CHAR_LIMIT = 14,
};

enum TH145PARAM {
	TH145PARAM_BATTLESTATE = 0,
	TH145PARAM_ISNETCLIENT,
	TH145PARAM_P1CHAR,
	TH145PARAM_P2CHAR,
	TH145PARAM_P1WIN,
	TH145PARAM_P2WIN,
	TH145PARAM_MAX,
	TH145PARAM_P1NAME,
	TH145PARAM_P2NAME,
};

BOOL WINAPI TH145AddrStartup(int APIVersion, HWND callbackWnd, int callbackMsg);
BOOL WINAPI TH145AddrCleanup();
TH145STATE WINAPI TH145AddrGetState();
DWORD_PTR WINAPI TH145AddrGetParam(int param);

#ifdef __cplusplus
}
#endif

#endif /* TH145ADDRDEF_H_INCLUDED */
