#include <Windows.h>
#include <shlwapi.h>
#include <ImageHlp.h>
#include <tchar.h>
#include <aclapi.h>
#include <lmcons.h>
#include <Winternl.h>
#include "TH145AddrDef.hpp"
#include "ProfileIO.hpp"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define TH145_APIVERSION 1

#define POLL_INTERVAL 50

#define Default_CoreBase        0x00543fc4
#define Default_WindowClass     _T("th145")
#define Default_WindowCaption   _T("[^ ver1.03b")

#define SQSTRING_LIMIT 256

#undef OutputDebugString
#define OutputDebugString(x)

#define TH145AddrIPCWndClass      _T("TH145AddrIPCWndClass")
#define TH145AddrInstallMutex     _T("TH145AddrInstallMutex")
#define TH145AddrInstalledEvent   _T("TH145AddrInstalledEvent")
#define TH145AddrIPCMutex         _T("TH145AddrIPCMutex")

#define WM_FINDRTCHILD (WM_APP + 0)
#define WM_RTCHILDTOSTRING (WM_APP + 1)

#pragma comment(lib, "shlwapi.lib")

#pragma data_seg(".th145hook")
HHOOK hookHandle = nullptr;
union {
	struct {
		DWORD len;
		char val[SQSTRING_LIMIT];
	} str;
	struct {
		UINT type;
		UINT val;
	} var;
} ipcData = {};
#pragma data_seg()

static bool isClientInitialized = false;
static HANDLE clientWorkerThread = nullptr;
static DWORD clientWorkerThreadId = 0;
static HWND clientCallbackWnd = nullptr;
static UINT clientCallbackMsg = 0;

static bool isIPCWindowCreated = false;
static HMODULE libModuleSaved = nullptr;
static HWND ipcWindow = nullptr;

static TCHAR th145WindowClass[256];
static TCHAR th145WindowCaption[256];
static DWORD th145CoreBase = 0;

static int paramOld[TH145PARAM_MAX];
static char paramBuff[SQSTRING_LIMIT];

static TH145STATE TH145State;

UINT WINAPI DllMain(HMODULE libModule, DWORD reason, LPVOID reserved)
{
	switch (reason) {
	case DLL_PROCESS_ATTACH:
		libModuleSaved = libModule;
		DisableThreadLibraryCalls(libModule);
	default:
		break;
	}
	return TRUE;
}

#define LoadAddress(V,N) { TCHAR addrStr[16]; \
	profile.ReadString(_T("Address"), _T(#N), _T(""), addrStr, sizeof addrStr); \
	if (!::StrToIntEx(addrStr, STIF_SUPPORT_HEX, reinterpret_cast<int *>(&##V))) ##V = Default_##N;  }
#define LoadChar(V,N) profile.ReadString(_T("TH145"), _T(#N), Default_##N, ##V, sizeof(##V))
static bool TH145LoadProfileForClient()
{
	Minimal::ProcessHeapPath profPath;
	if (!TryGetModulePath(libModuleSaved, profPath)) return false;
	CProfileIO profile(profPath /= _T("TH145Addr.ini"));
	LoadChar(th145WindowClass,   WindowClass);
	LoadChar(th145WindowCaption, WindowCaption);
	return true;
}

static bool TH145LoadProfileForVictim()
{
	Minimal::ProcessHeapPath profPath;
	if (!TryGetModulePath(libModuleSaved, profPath)) return false;
	CProfileIO profile(profPath /= _T("TH145Addr.ini"));
	LoadAddress(th145CoreBase, CoreBase);
	return true;
}

// strtok ̂悤 iterator class
class StringSplitter {
private:
	Minimal::ProcessHeapStringA buff;
	LPCSTR begin;
	LPCSTR end;
	char sep;

public:
	StringSplitter(LPCSTR src, char separator) :
		begin(src), end(src), sep(separator) {}

public:
	LPCSTR Next() {
		if (begin == NULL) return NULL;
		end = ::StrChrA(begin, sep);
		if (end == NULL) {
			buff = begin;
			begin = end;
		}
		else {
			buff = Minimal::ProcessHeapStringA(begin, end).GetRaw();
			begin = end + 1;
		}
		return buff.GetRaw();
	}
};

// CoreBase class instance ɂ SQVM instance  Root Table  w肳ꂽpX item value  fetch
static bool FindRTChildProc()
{
	DWORD_PTR items;
	DWORD_PTR itemVal;
	DWORD_PTR itemVal2;
	char  itemStr[SQSTRING_LIMIT];
	DWORD itemType;
	DWORD itemNum;
	DWORD itemLen;
	DWORD itemIndex;
	DWORD readSize;
	BOOL ret;
	DWORD j;

	//if (GetAsyncKeyState(VK_F1) < 0) __asm mov ds:[0], 0xdeadbeef

	HANDLE curProc = GetCurrentProcess();
	// CoreBase  table ǂݍ
	ret = ::ReadProcessMemory(curProc, (LPVOID)((DWORD_PTR)GetModuleHandle(nullptr) + th145CoreBase), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;
	ret = ::ReadProcessMemory(curProc, (LPVOID)((DWORD_PTR)itemVal + 0x34), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;

	itemType = 0x20;

	StringSplitter tokenizer(ipcData.str.val, '/');
	LPCSTR pathToken;
	while (pathToken = tokenizer.Next()) {
		switch (itemType & 0xFFFFF) {
		case 0x20:	// TABLE
			// Table ̏ǂݍ
			ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Table items T
			for (j = 0; j < itemNum; ++j) {
				// Table item key ǂݍ
				ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x0c), &itemVal, sizeof itemVal, &readSize);
				if (!ret) return false;
				//  Table item key ̂Ƃ󂯕t
				if ((itemType & 0xFFFFF) == 0x10) {
					//  Table item key 𕶎Ƃēǂݍ
					ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x14), &itemLen, sizeof itemLen, &readSize);
					if (!ret) return false;
					// 펯IȒ̕񂾂󂯕t
					if (0 < itemLen && itemLen < SQSTRING_LIMIT) {
						ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x1C), itemStr, itemLen, &readSize);
						if (!ret) return false;
						itemStr[itemLen] = 0;
						// Table item key ̒l path ̃g[Nƈv table item value ǂݍ
						if (::lstrcmpA(itemStr, pathToken) == 0) {
							ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
							if (!ret) return false;
							ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x04), &itemVal, sizeof itemVal, &readSize);
							if (!ret) return false;
							break;
						}
					}
				}
			}
			if (j == itemNum) return false;
			break;
		case 0x40:	// ARRAY
			// Array item ̐擪AhX item ǂݍ
			ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x1C), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Path ̃g[N Array item  index ƌȂĔ͈̓`FbN
			itemIndex = StrToIntA(pathToken);
			if (itemNum <= itemIndex) return false;
			// Array item ǂݍ
			ret = ::ReadProcessMemory(curProc, (LPVOID)(items + itemIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(items + itemIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
			if (!ret) return false;
			break;
		case 0x8000:	// INSTANCE
			// Instance members ̏ǂݍ
			ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x1C), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(items + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(items + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(curProc, (LPVOID)(items + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			// Instance members T
			for (j = 0; j < itemNum; ++j) {
				// Instance member metadata value ǂݍ
				ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x04), &itemVal2, sizeof itemVal, &readSize);
				if (!ret) return false;
				// Instance member metadata value LȂƂ󂯕t
				if ((itemType & 0xFFFFF) == 0x02) {
					// Instance member metadata value  instance member type  instance member index 𒊏o
					DWORD memberType = itemVal2 & 0xFF000000;
					DWORD memberIndex = itemVal2 & 0x00FFFFFF;
					// Instance member type LȂƂ󂯕t
					if (memberType == 0x02000000) {
						// Instance member metadata key ǂݍ
						ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
						if (!ret) return false;
						ret = ::ReadProcessMemory(curProc, (LPVOID)(items + j * 0x14 + 0x0c), &itemVal2, sizeof itemVal, &readSize);
						if (!ret) return false;
						// Instance member metadata key ̂Ƃ󂯕t
						if ((itemType & 0xFFFFF) == 0x10) {
							//  Instance member metadata key 𕶎Ƃēǂݍ
							ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal2 + 0x14), &itemLen, sizeof itemLen, &readSize);
							if (!ret) return false;
							// 펯IȒ̕񂾂󂯕t
							if (0 < itemLen && itemLen < SQSTRING_LIMIT) {
								ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal2 + 0x1C), itemStr, itemLen, &readSize);
								if (!ret) return false;
								itemStr[itemLen] = 0;
								// Instance member metadata key ̒l path ̃g[Nƈv instance member value ǂݍ
								if (::lstrcmpA(itemStr, pathToken) == 0) {
									ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
									if (!ret) return false;
									ret = ::ReadProcessMemory(curProc, (LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
									if (!ret) return false;
									break;
								}
							}
						}
					}
				}
			}
			if (j == itemNum) return false;
			break;
		}
	}
	ipcData.var.type = itemType;
	ipcData.var.val = itemVal;
	return true;
}

// Squirrel item value  string  fetch
static bool RTChildToStringProc(DWORD_PTR childVal)
{
	DWORD strLen;
	DWORD readSize;
	BOOL ret;
	HANDLE curProc = GetCurrentProcess();

	// if (GetAsyncKeyState(VK_F2) < 0) __asm mov ds : [0], 0xdeadbeef

	ret = ::ReadProcessMemory(curProc, (LPVOID)(childVal + 0x14), &strLen, sizeof strLen, &readSize);
	if (!ret) return false;
	if (!(0 < strLen && strLen < SQSTRING_LIMIT)) return false;

	ret = ::ReadProcessMemory(curProc, (LPVOID)(childVal + 0x1C), ipcData.str.val, strLen, &readSize);
	if (!ret) return false;

	ipcData.str.val[strLen] = 0;
	ipcData.str.len = strLen;
	return true;
}

static void DeadBeef(
	PEXCEPTION_RECORD ExceptionRecord,
	PVOID EstablisherFrame,
	PCONTEXT ContextRecord,
	PVOID DispatcherContext)
{

	BOOL (WINAPI *MiniDumpWriteDump)(
		_In_ HANDLE                            hProcess,
		_In_ DWORD                             ProcessId,
		_In_ HANDLE                            hFile,
		_In_ UINT                              DumpType,
		_In_ PMINIDUMP_EXCEPTION_INFORMATION   ExceptionParam,
		_In_ PMINIDUMP_USER_STREAM_INFORMATION UserStreamParam,
		_In_ PMINIDUMP_CALLBACK_INFORMATION    CallbackParam
	);
	*(FARPROC*)&MiniDumpWriteDump = GetProcAddress(LoadLibrary(_T("dbghelp.dll")), "MiniDumpWriteDump");
	if (MiniDumpWriteDump != nullptr) {
		Minimal::ProcessHeapPath dumpPath;
		if (!TryGetModulePath(libModuleSaved, dumpPath)) dumpPath = _T("C:\\");
		CProfileIO profile(dumpPath /= _T("TH145Addr.dmp"));
		HANDLE file = ::CreateFile(dumpPath, GENERIC_WRITE, FILE_SHARE_WRITE, nullptr, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, nullptr);

		_MINIDUMP_EXCEPTION_INFORMATION excptInfo;
		EXCEPTION_POINTERS excptPtrs = { ExceptionRecord, ContextRecord };
		excptInfo.ThreadId = ::GetCurrentThreadId();
		excptInfo.ExceptionPointers = &excptPtrs;
		excptInfo.ClientPointers = FALSE;
		MiniDumpWriteDump(GetCurrentProcess(), GetCurrentProcessId(), file, MiniDumpNormal | MiniDumpFilterModulePaths, &excptInfo, NULL, NULL);
		::CloseHandle(file);
	}

	MessageBox(nullptr, _T("\ȂG[܂BOK{^ƃQ[I܂B"), _T("TH145Addr"), MB_ICONEXCLAMATION);
	TerminateProcess(GetCurrentProcess(), 0);
	return;
}

static __declspec(naked) bool FindRTChildProcDbg()
{
	__asm {
		push DeadBeef
		mov eax, fs:[0]
		push eax
		mov fs:[0], esp
		call FindRTChildProc
		pop ecx
		mov fs:[0], ecx
		pop ecx
		retn
	}
}

static __declspec(naked) bool RTChildToStringProcDbg(WPARAM wparam)
{
	__asm {
		mov ecx, ds:[esp+4]
		push DeadBeef
		mov eax, fs:[0]
		push eax
		mov fs:[0], esp
		push ecx
		call RTChildToStringProc
		add esp, 4
		pop ecx
		mov fs:[0], ecx
		pop ecx
		retn
	}
}


LRESULT CALLBACK ipcWindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg) {
	case WM_FINDRTCHILD:
		return FindRTChildProcDbg() != false;
	case WM_RTCHILDTOSTRING:
		return RTChildToStringProcDbg(wparam) != false;
	}
	return DefWindowProc(hwnd, msg, wparam, lparam);
}
static bool IPCWindowExists()
{
	return IsWindow(ipcWindow) || (ipcWindow = FindWindow(TH145AddrIPCWndClass, nullptr));
}

LRESULT CALLBACK TH145HookProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HC_ACTION && !isIPCWindowCreated) {
		if (TH145LoadProfileForVictim()) {
			WNDCLASSEX wc;
			wc.cbSize = sizeof(WNDCLASSEX);
			wc.hInstance = libModuleSaved;
			wc.lpszClassName = TH145AddrIPCWndClass;
			wc.lpfnWndProc = ipcWindowProc;
			wc.style = CS_DBLCLKS;
			wc.hIcon = LoadIcon(nullptr, IDI_APPLICATION);
			wc.hIconSm = LoadIcon(nullptr, IDI_APPLICATION);
			wc.hCursor = LoadCursor(nullptr, IDC_ARROW);
			wc.lpszMenuName = nullptr;
			wc.cbClsExtra = 0;
			wc.cbWndExtra = 0;
			wc.hbrBackground = (HBRUSH)COLOR_BACKGROUND;
			if (RegisterClassEx(&wc) == 0) {
				OutputDebugString(_T("Failed registering ipcWindow class."));
			} else {
				if (CreateWindowEx(0, TH145AddrIPCWndClass, _T(""), WS_POPUPWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, 300, 400, HWND_DESKTOP, nullptr, libModuleSaved, nullptr) == nullptr) {
					OutputDebugString(_T("Failed creating ipcWindow."));
				} else {
					TCHAR libModuleName[1024];
					GetModuleFileName(libModuleSaved, libModuleName, sizeof(libModuleName));
					LoadLibrary(libModuleName);

					isIPCWindowCreated = true;
					HANDLE hookedEvent = CreateEvent(nullptr, FALSE, FALSE, TH145AddrInstalledEvent);
					SetEvent(hookedEvent);
					CloseHandle(hookedEvent);
					OutputDebugString(_T("Creating ipcWindow succeeded."));
				}
			}
		}

	}
	return CallNextHookEx(hookHandle, nCode, wParam, lParam);
}

static bool FindRTChild(LPCSTR path, DWORD &retType, DWORD &retVal)
{
	if (!IPCWindowExists()) return false;
	DWORD pathLen = lstrlenA(path) + 1;
	if (!(0 < pathLen && pathLen < SQSTRING_LIMIT)) return false;
	HANDLE ipcLock = CreateMutex(nullptr, FALSE, TH145AddrIPCMutex);
	WaitForSingleObject(ipcLock, INFINITE);
	::RtlCopyMemory(ipcData.str.val, path, pathLen);
	LRESULT ret = SendMessage(ipcWindow, WM_FINDRTCHILD, 0, 0);
	if (ret != FALSE) {
		OutputDebugStringA(path);
		retType = ipcData.var.type;
		retVal = ipcData.var.val;
	}
	ReleaseMutex(ipcLock);
	CloseHandle(ipcLock);
	return ret != FALSE;
}


static bool RTChildToString(DWORD_PTR childVal, LPSTR outBuffer, DWORD bufLen)
{
	if (!IPCWindowExists()) return false;
	HANDLE ipcLock = CreateMutex(nullptr, FALSE, TH145AddrIPCMutex);
	WaitForSingleObject(ipcLock, INFINITE);
	LRESULT ret = SendMessage(ipcWindow, WM_RTCHILDTOSTRING, childVal, 0);
	if (ret != FALSE) {
		::RtlCopyMemory(outBuffer, ipcData.str.val, ipcData.str.len + 1);
		OutputDebugStringA(outBuffer);
	}
	ReleaseMutex(ipcLock);
	CloseHandle(ipcLock);
	return ret != FALSE;
}

static void APIENTRY InterruptAPCCallback(ULONG_PTR)
{
}

static void TH145Callback(short Msg, short param1, int param2)
{
	if (clientCallbackWnd) {
		::PostMessage(clientCallbackWnd, clientCallbackMsg, MAKELONG(Msg, param1), param2);
	}
}

static TH145STATE TH145StateWaitForHooking()
{
	TH145STATE ret = TH145STATE_NOTFOUND;
	HWND th145Window = FindWindow(th145WindowClass, th145WindowCaption);
	if (th145Window != nullptr) {
		DWORD th145TId, th145PId;
		th145TId = GetWindowThreadProcessId(th145Window, &th145PId);

		HANDLE hookLock = CreateMutex(nullptr, FALSE, TH145AddrInstallMutex);
		WaitForSingleObject(hookLock, INFINITE);
		if (!IPCWindowExists()) {
			hookHandle = SetWindowsHookEx(WH_GETMESSAGE, TH145HookProc, libModuleSaved, th145TId);
			if (hookHandle != nullptr) {
				HANDLE hookedEvent = CreateEvent(nullptr, FALSE, FALSE, TH145AddrInstalledEvent);
				PostMessage(th145Window, WM_NULL, 0, 0);
				if (WaitForSingleObject(hookedEvent, 10000) == 0) {
					TH145Callback(TH145MSG_STATECHANGE, TH145STATE_WAITFORNETBATTLE, 0);
					::ZeroMemory(paramOld, sizeof paramOld);
					ret = TH145STATE_WAITFORNETBATTLE;
				}
				CloseHandle(hookedEvent);
				UnhookWindowsHookEx(hookHandle);
				hookHandle = nullptr;
			}
		} else {
			TH145Callback(TH145MSG_STATECHANGE, TH145STATE_WAITFORNETBATTLE, 0);
			::ZeroMemory(paramOld, sizeof paramOld);
			ret = TH145STATE_WAITFORNETBATTLE;
		}
		ReleaseMutex(hookLock);
		CloseHandle(hookLock);
	}
	return ret;
}

static TH145STATE TH145StateWaitForNetBattle()
{
	if (!IPCWindowExists()) {
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_NOTFOUND, 0);
		return TH145STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_NETBATTLE, 0);
		return TH145STATE_NETBATTLE;
	}
	else {
		return TH145STATE_WAITFORNETBATTLE;
	}
}

static TH145STATE TH145StateNetBattle()
{
	if (!IPCWindowExists()) {
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_NOTFOUND, 0);
		return TH145STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		int param;
		for (int i = 0; i < TH145PARAM_MAX; ++i) {
			if ((param = TH145AddrGetParam(i)) != -1) {
				if (param != paramOld[i])
					TH145Callback(TH145MSG_PARAMCHANGE, i, param);
				paramOld[i] = param;
			}
			else paramOld[i] = 0;
		}
		return TH145STATE_NETBATTLE;
	}
	else {
		TH145Callback(TH145MSG_STATECHANGE, TH145STATE_WAITFORNETBATTLE, 0);
		return TH145STATE_WAITFORNETBATTLE;
	}
}

static DWORD WINAPI TH145AddrWorkerThread(LPVOID)
{
	MSG msg;

	TH145State = TH145STATE_NOTFOUND;
	while (!::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) || msg.message != WM_QUIT) {
		switch (TH145State) {
		case TH145STATE_NOTFOUND:            TH145State = TH145StateWaitForHooking(); break;
		case TH145STATE_WAITFORNETBATTLE:    TH145State = TH145StateWaitForNetBattle(); break;
		case TH145STATE_NETBATTLE:           TH145State = TH145StateNetBattle(); break;
		};
		::SleepEx(POLL_INTERVAL, TRUE);
	}
	::ExitThread(0);
	return 0;
}

extern "C"
BOOL WINAPI TH145AddrStartup(int APIVersion, HWND callbackWnd, int callbackMsg)
{
	if (isClientInitialized) return FALSE;
	if (APIVersion != TH145_APIVERSION) return FALSE;

	if (!TH145LoadProfileForClient()) return FALSE;
	clientCallbackWnd = callbackWnd;
	clientCallbackMsg = callbackMsg;
	clientWorkerThread = ::CreateThread(NULL, 0, TH145AddrWorkerThread, NULL, 0, &clientWorkerThreadId);
	if (clientWorkerThread == nullptr) return FALSE;

	isClientInitialized = true;
	return TRUE;
}

extern "C"
BOOL WINAPI TH145AddrCleanup()
{
	if (!isClientInitialized)  return FALSE;

	::PostThreadMessage(clientWorkerThreadId, WM_QUIT, 0, 0);
	::QueueUserAPC(InterruptAPCCallback, clientWorkerThread, 0);
	::WaitForSingleObject(clientWorkerThread, INFINITE);
	::CloseHandle(clientWorkerThread);

	return 0;
}

extern "C"
TH145STATE WINAPI TH145AddrGetState()
{
	return TH145State;
}

extern "C"
DWORD_PTR WINAPI TH145AddrGetParam(int param)
{
	DWORD childType, childVal;

	switch (param) {
	case TH145PARAM_BATTLESTATE:
		if (::FindRTChild("game/battleState", childType, childVal) && (childType & 0xFFFFF) == 0x02) {
			return childVal;
		}
		break;
	case TH145PARAM_ISNETCLIENT:
		if (::FindRTChild("network_is_client", childType, childVal) && (childType & 0xFFFFF) == 0x08) {
			return childVal;
		}
		break;
	case TH145PARAM_P1CHAR:
		if (::FindRTChild("load_data/player/0", childType, childVal) && (childType & 0xFFFFF) == 0x02) {
			return childVal;
		}
		break;
	case TH145PARAM_P2CHAR:
		if (::FindRTChild("load_data/player/1", childType, childVal) && (childType & 0xFFFFF) == 0x02) {
			return childVal;
		}
		break;
	case TH145PARAM_P1WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p1/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) {
			return childVal;
		}
		break;
	case TH145PARAM_P2WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p2/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) {
			return childVal;
		}
		break;
	case TH145PARAM_P1NAME:
		if (::FindRTChild("load_data/profile/0/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, paramBuff, sizeof(paramBuff))) {
			return (DWORD_PTR)paramBuff;
		}
		break;
	case TH145PARAM_P2NAME:
		if (::FindRTChild("load_data/profile/1/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, paramBuff, sizeof(paramBuff))) {
			return (DWORD_PTR)paramBuff;
		}
		break;
	}
	return -1;
}

