#include "pch.hpp"
#include "TH145AddrDef.h"
#include "Hengokuroku.hpp"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

static int (WINAPI *func_TH145AddrStartup)(int, HWND, UINT);
static int (WINAPI *func_TH145AddrCleanup)();
static DWORD_PTR (WINAPI *func_TH145AddrGetParam)(int);
static TH145STATE (WINAPI *func_TH145AddrGetState)();

static TH145CHARNAME s_charNames[] = {
	{ _T("얲"), _T("얲") },
	{ _T("J"), _T("") },
	{ _T("_"), _T("") },
	{ _T("@"), _T("@") },
	{ _T("zs"), _T("zs") },
	{ _T("L_q"), _T("_q") },
	{ _T("͏ɂƂ"), _T("ɂƂ") },
	{ _T("Ön"), _T("") },
	{ _T("b}~]E"), _T("}~]E") },
	{ _T("`"), _T("") },
	{ _T("؉ؐ"), _T("ؐ") },
	{ _T("g"), _T("g") },
	{ _T("j"), _T("j") },
	{ _T("F俎q"), _T("俎q") }
};

int TH145AddrInit(HWND callbackWnd, int callbackMsg)
{
	Minimal::ProcessHeapPath defaultTH145AddrPath;
	if (TryGetModulePath(GetModuleHandle(nullptr), defaultTH145AddrPath)) {
		defaultTH145AddrPath /= _T("TH145Addr.dll");
	} else {
		defaultTH145AddrPath = _T("TH145Addr.dll");
	}
	TCHAR th145AddrPath[1024];
	g_settings.ReadString(_T("Path"), _T("TH145Addr"), defaultTH145AddrPath, th145AddrPath, sizeof(th145AddrPath));
	
	HMODULE th145Addr = LoadLibrary(th145AddrPath);
	*(FARPROC*)&func_TH145AddrStartup = GetProcAddress(th145Addr, "TH145AddrStartup");
	*(FARPROC*)&func_TH145AddrCleanup = GetProcAddress(th145Addr, "TH145AddrCleanup");
	*(FARPROC*)&func_TH145AddrGetParam = GetProcAddress(th145Addr, "TH145AddrGetParam");
	*(FARPROC*)&func_TH145AddrGetState = GetProcAddress(th145Addr, "TH145AddrGetState");
	if (func_TH145AddrStartup == nullptr || func_TH145AddrCleanup == nullptr || func_TH145AddrGetParam == nullptr || func_TH145AddrGetState == nullptr) {
		return 0;
	}

	return func_TH145AddrStartup(1, callbackWnd, callbackMsg) != 0;
}

int TH145AddrFinish()
{
	return func_TH145AddrCleanup();
}

TH145STATE TH145AddrGetState()
{
	return func_TH145AddrGetState();
}

DWORD_PTR TH145AddrGetParam(int param)
{
	return func_TH145AddrGetParam(param);
}

const TH145CHARNAME * const TH145AddrGetCharName(int index)
{
	if (TH145AddrGetCharCount() <= index) return NULL;
	return &s_charNames[index];
}

int TH145AddrGetCharCount()
{
	return _countof(s_charNames);
}
