#include <Windows.h>
#include <tchar.h>

int CALLBACK WindowProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg) {
	case WM_CLOSE:
		PostQuitMessage(0);
		return TRUE;
	default:
		return DefWindowProc(hwnd, msg, wparam, lparam);
	}
}
int WINAPI WinMain(HINSTANCE instance, HINSTANCE prevInstance, LPSTR cmdLine, int showcmd)
{
	void (*SPRHookInstall)();
	*(FARPROC*)&SPRHookInstall = GetProcAddress(LoadLibrary(_T("SPRHook.dll")), "SPRHookInstall");
	if (SPRHookInstall == nullptr) {
		return -1;
	}

	SPRHookInstall();
	HWND hwnd = CreateWindow(_T("static"), _T("SPRHook"), WS_VISIBLE | WS_POPUPWINDOW | WS_CAPTION, 0, 0, 640, 480, nullptr, nullptr, instance, 0);
	SetWindowLongPtr(hwnd, GWLP_WNDPROC, (LONG)WindowProc);
	UpdateWindow(hwnd);
	MSG msg;

	while (GetMessage(&msg, NULL, 0, 0) > 0) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}
