#ifndef TH145ADDRDEF_H_INCLUDED
#define TH145ADDRDEF_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

enum TH145CBMSG {
	TH145MSG_STATECHANGE,
	TH145MSG_PARAMCHANGE,
};

enum TH145STATE {
	TH145STATE_NOTFOUND,
	TH145STATE_WAITFORNETBATTLE,
	TH145STATE_NETBATTLE
};

enum TH145SCHAR {
	TH145CHAR_REIMU = 0,
	TH145CHAR_MARISA = 1,
	TH145CHAR_SECRET = 2,
	TH145CHAR_KASEN = 10,
	TH145CHAR_LIMIT = 11,
};

enum TH145PARAM {
	TH145PARAM_BATTLESTATE,
	TH145PARAM_ISNETCLIENT,
	TH145PARAM_P1CHAR,
	TH145PARAM_P2CHAR,
	TH145PARAM_P1WIN,
	TH145PARAM_P2WIN,
	TH145PARAM_TOADDR,
	TH145PARAM_MAX,
	TH145PARAM_P1NAME,
	TH145PARAM_P2NAME,
};

typedef void (__cdecl *TH145ADDRCALLBACKPROC)(int, int, int, void *);

typedef struct {
	PCTSTR full;
	PCTSTR abbr;
} TH145CHARNAME;

int TH145AddrInit(HWND, int);
int TH145AddrFinish();
DWORD_PTR TH145AddrGetParam(int);
TH145STATE TH145AddrGetState();
const TH145CHARNAME * const TH145AddrGetCharName(int index);
int TH145AddrGetCharCount();


#ifdef __cplusplus
}
#endif

#endif /* TH145ADDRDEF_H_INCLUDED */
