#include "stdafx.h"
#include "ProfileIO.h"

extern HINSTANCE g_modinst;

CProfileIO::CProfileIO()
{
	m_name[0] = 0;
}

CProfileIO::CProfileIO(LPCSTR name)
{
	SetName(name);
}

BOOL CProfileIO::SetName(LPCSTR name)
{
	// inipX𐶐
	GetModuleFileName(g_modinst, m_name, sizeof(m_name));
	PathRemoveFileSpec(m_name);
	PathAppend(m_name, name);

	return TRUE;
}

DWORD CProfileIO::ReadString(LPCSTR sec, LPCSTR key, LPCSTR def, LPSTR buf, DWORD len)
{
	return GetPrivateProfileString(sec, key, def, buf, len, m_name);
}

UINT CProfileIO::ReadInteger(LPCSTR sec, LPCSTR key, INT def)
{
	return GetPrivateProfileInt(sec, key, def, m_name);
}

DWORD CProfileIO::WriteString(LPCSTR sec, LPCSTR key, LPSTR value)
{
	return WritePrivateProfileString(sec, key, value, m_name);
}

DWORD CProfileIO::WriteInteger(LPCSTR sec, LPCSTR key, INT value)
{
	char buff[16];
	::wnsprintf(buff, 16, "%d", value);
	return WritePrivateProfileString(sec, key, buff, m_name);
}

