// THSSP.cpp : DLL AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"
#include "Susie.h"
#include "ConfigDlg.h"
#include "ProfileIO.h"

#ifdef _MANAGED
#pragma managed(push, off)
#endif

template <typename T>
class CLocalPtr :
public ATL::CHeapPtr<T, ATL::CLocalAllocator>
{
};

#define memword(p) ((WORD)((LPBYTE)(p))[0] | ((WORD)((LPBYTE)(p))[1] << 8))
#define isdigit(x) ((x) >= '0' && (x) <= '9')

struct cdginfo
{
	int planesize;
	int width;
	int height;
	int count;
	int type;

	bool FromMemory(BYTE *p, int len = -1 /* without length check */)
	{
		this->planesize = memword(p + 0);
		this->width     = memword(p + 2);
		this->height    = memword(p + 4);
		this->count     = p[10];
		this->type      = p[11];

		if(!this->planesize || !this->width || !this->height ||
			(this->width & 7) ||
			(this->width >> 3) * this->height != this->planesize ||
			this->type > 2) return false;

		if(len < 0) return true;

		if((len - 16) % this->planesize) return false;

		// fix the type
		int newcount = (len - 16) / this->planesize;
		if(this->type != 2)
		{
			if(newcount % 5 == 0)
			{
				this->type = 1;
				this->count = newcount / 5;
			}
			else if(newcount % 4 == 0)
			{
				type = 0;
				this->count = newcount / 4;
			}
			else
			{
				return false;
			}
		}
		else
		{
			if(this->count != newcount) return false;
		}

		// fix the count
		if(!this->count) this->count = 1;

		return true;
	}
};

RGBQUAD g_palette[16] =
{
	{ 0x00, 0x00, 0x00, 0x00 },
	{ 0xFF, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0xFF, 0x00 },
	{ 0xFF, 0x00, 0xFF, 0x00 },
	{ 0x00, 0xFF, 0x00, 0x00 },
	{ 0xFF, 0xFF, 0x00, 0x00 },
	{ 0x00, 0xFF, 0xFF, 0x00 },
	{ 0xFF, 0xFF, 0xFF, 0x00 },
	{ 0xAA, 0x00, 0x00, 0x00 },
	{ 0xAA, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0xAA, 0x00 },
	{ 0xAA, 0x00, 0xAA, 0x00 },
	{ 0x00, 0xAA, 0x00, 0x00 },
	{ 0xAA, 0xAA, 0x00, 0x00 },
	{ 0x00, 0xAA, 0xAA, 0x00 },
	{ 0xAA, 0xAA, 0xAA, 0x00 }
};

const RGBQUAD g_monopal[2] =
{
	{ 0, 0, 0, 0 },
	{ 255, 255, 255, 0 },
};

const char * g_infostr[] =
{
	/* Plug-in API Version */
	"00AM",
	/* Plug-in Description */
	"CD2/CDG to DIB filter p.t.0",
	/* Supported extensions */
	"*.CD2;*.CDG",
	/* Supported format description */
	"Touhou Character Dot Graphics"
};

HINSTANCE g_modinst;

extern HANDLE g_heap;

int PASCAL GetPluginInfo(int infono, LPSTR buf, int buflen)
{
	if(infono < 0 || infono >= ARRAYSIZE(g_infostr)) return 0;

	int writesize = ::wnsprintf(buf, buflen, g_infostr[infono]);
	if(writesize < 0) writesize = 0;
	return writesize;
}

int PASCAL IsSupported(LPSTR filename, DWORD dw)
{
	BYTE buff[16];
	LPBYTE p;

	if(!HIWORD(dw))
	{
		DWORD readsize;
		BOOL ret = ::ReadFile(reinterpret_cast<HANDLE>(dw), buff, 16, &readsize, NULL);
		if(!ret || readsize < 16) return 0;
		p = buff;
	}
	else p = reinterpret_cast<LPBYTE>(dw);

	cdginfo info;
	return info.FromMemory(p);
}

bool MyReadHeader(cdginfo &info, const char *name, int offset)
{
	ATL::CAtlFile file;
	HRESULT hret = file.Create(name, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	if(FAILED(hret)) return false;
	ULARGE_INTEGER len;
	hret = file.GetSize(len.QuadPart);
	if(FAILED(hret)) return false;

	hret = file.Seek(offset, FILE_BEGIN);
	if(FAILED(hret)) return false;
	BYTE buff[16];
	DWORD readsize;
	hret = file.Read(buff, 16, readsize);
	if(FAILED(hret) || readsize < 16) return false;

	if(!info.FromMemory(buff, len.LowPart)) return false;

	return true;
}

errno_t PASCAL GetArchiveInfo(LPSTR buf, long len, unsigned int flag, HLOCAL *lphInf)
{
	if(flag & 7) return -1;

	cdginfo info;
	if(!MyReadHeader(info, buf, len)) return 3;

	CLocalPtr<fileInfo> list;
	if(!list.Allocate(info.count + 1)) return 4;

	const int planes[] = { 4, 5, 1 };
	int sprsize = info.planesize * planes[info.type];

	int bits = info.type == 2 ? 1: 4;
	int outwidth = (info.width / (8 / bits) + 3) & ~3;
	int colors = 1 << bits;
	int dataofs =
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		sizeof(RGBQUAD) * colors;
	int outsize = 
		dataofs + 
		outwidth * info.height;

	for(int i = 0; i < info.count; ++i)
	{
		strcpy(list.m_pData[i].method, "CDG");
		list.m_pData[i].position = 0x80000000 | (i << 23);
		list.m_pData[i].compsize = sprsize;
		list.m_pData[i].filesize = outsize;
		list.m_pData[i].timestamp = 0;
		list.m_pData[i].path[0] = 0;
		::wnsprintf(list.m_pData[i].filename,
			200, "cdg%02d.bmp", i + 1);
		list.m_pData[i].crc = 0;
	}
	list.m_pData[info.count].method[0] = 0;

	*lphInf = static_cast<HLOCAL>(list.Detach());

	CProfileIO profile("THSSP.INI");
	if(profile.ReadInteger("Palette", "SetEverytimes", 0))
	{
		char palpath[2048];
		profile.ReadString("Palette", "Path", NULL, palpath, sizeof(palpath));
		if(CDGSelectPaletteDlg(NULL, palpath, 2048))
		{
			profile.WriteString("Palette", "Path", palpath);
		}
	}
	return 0;
}

errno_t PASCAL GetFileInfo(LPSTR buf, long len, LPSTR filename, unsigned int flag, fileInfo *lpInfo)
{
	if(flag & 7) return -1;
	if(!(len >> 31)) return -1;
	int index = (len >> 23) & 0xFF;
	len &= 0x007FFFFF;

	cdginfo info;
	if(!MyReadHeader(info, buf, len)) return 3;

	const int planes[] = { 4, 5, 1 };
	int sprsize = info.planesize * planes[info.type];

	int bits = info.type == 2 ? 1: 4;
	int outwidth = (info.width / (8 / bits) + 3) & ~3;
	int colors = 1 << bits;
	int dataofs =
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		sizeof(RGBQUAD) * colors;
	int outsize = 
		dataofs + 
		outwidth * info.height;

	strcpy(lpInfo->method, "CDG");
	lpInfo->position = 0x80000000 | (index << 23);
	lpInfo->compsize = sprsize;
	lpInfo->filesize = outsize;
	lpInfo->timestamp = 0;
	lpInfo->path[0] = 0;
	strcpy(lpInfo->filename, filename);
	lpInfo->crc = 0;

	return 0;
}

void ReadPalette()
{
	char palpath[2048];
	CProfileIO profile("THSSP.INI");
	profile.ReadString("Palette", "Path", NULL, palpath, sizeof(palpath));

	BYTE buff[0x30];
	ATL::CAtlFile file;
	HRESULT hret = file.Create(palpath, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	if(FAILED(hret)) return;
	ULONGLONG len;
	hret = file.GetSize(len);
	if(FAILED(hret)) return;
	if(len != 0x30) return;
	
	hret = file.Read(buff, 0x30);
	if(FAILED(hret)) return;

	for(int i = 0; i < 16; ++i)
	{
		g_palette[i].rgbRed   = buff[i * 3 + 0] * 17;
		g_palette[i].rgbGreen = buff[i * 3 + 1] * 17;
		g_palette[i].rgbBlue  = buff[i * 3 + 2] * 17;
	}
}

bool BuildBitmapSkelton(CLocalPtr<BYTE> &out, BYTE *&data, int width, int height, int bits, const RGBQUAD palette[])
{
	int outwidth = (width / (8 / bits) + 3) & ~3;
	int colors = 1 << bits;
	int dataofs =
		sizeof(BITMAPFILEHEADER) +
		sizeof(BITMAPINFOHEADER) +
		sizeof(RGBQUAD) * colors;
	int outsize = 
		dataofs + 
		outwidth * height;
	if(!out.Allocate(outsize)) return false;

	BITMAPFILEHEADER *bfh = reinterpret_cast<BITMAPFILEHEADER *>(out.m_pData);
	bfh->bfType = 'MB';
	bfh->bfSize = outsize;
	bfh->bfOffBits = dataofs;

	BITMAPINFO *bi = reinterpret_cast<BITMAPINFO *>(bfh + 1);
	bi->bmiHeader.biSize = sizeof(bi->bmiHeader);
	bi->bmiHeader.biWidth = width;
	bi->bmiHeader.biHeight = height;
	bi->bmiHeader.biPlanes = 1;
	bi->bmiHeader.biBitCount = bits;
	bi->bmiHeader.biCompression = 0;
	bi->bmiHeader.biSizeImage = 0;
	bi->bmiHeader.biXPelsPerMeter = 1;
	bi->bmiHeader.biYPelsPerMeter = 1;
	bi->bmiHeader.biClrUsed = 0;
	bi->bmiHeader.biClrImportant = 0;

	::RtlMoveMemory(bi->bmiColors, palette, sizeof(RGBQUAD) * colors);

	data = reinterpret_cast<BYTE *>(bfh) + dataofs;
	return true;
}

bool CDGMonoToBitmap(CLocalPtr<BYTE> &out, BYTE *in, cdginfo &info)
{
	BYTE *data;
	if(!BuildBitmapSkelton(out, data, info.width, info.height, 1, g_monopal)) return false;

	int inwidth = info.width / 8;
	int outwidth = (inwidth + 3) & ~3;
	if(inwidth == outwidth)
	{
		::RtlMoveMemory(data, in, inwidth * info.height);
	}
	else
	{
		for(int y = 0; y < info.height; ++y)
		{
			::RtlMoveMemory(data + y * outwidth, in + y * inwidth, inwidth);
		}
	}

	return true;
}

bool CDGColorToBitmap(CLocalPtr<BYTE> &out, BYTE *in, cdginfo &info)
{
	ReadPalette();

	BYTE *data;
	if(!BuildBitmapSkelton(out, data, info.width, info.height, 4, g_palette)) return false;

	if(info.type == 1) /* skip the mask pattern */
	{
		in += info.planesize;
	}
	/* get the pointers to each plane (R/G/B/I) */
	BYTE *rp = in;
	BYTE *gp = rp + info.planesize;
	BYTE *bp = gp + info.planesize;
	BYTE *ip = bp + info.planesize;

	int outwidth = info.width / 2;
	::RtlZeroMemory(data, outwidth * info.height);
	for(int y = 0, inofs = 0, outofs = 0; y < info.height; ++y)
	{
		for(int x = 0; x < info.width; ++inofs, x += 8)
		{
			for(int i = 0, inshift = 7, outshift = 0; i < 8; outofs += (i & 1), ++i, --inshift)
			{
				int val = ((rp[inofs] >> inshift) & 1) << 0;
				val    |= ((gp[inofs] >> inshift) & 1) << 1;
				val    |= ((bp[inofs] >> inshift) & 1) << 2;
				val    |= ((ip[inofs] >> inshift) & 1) << 3;
				outshift = 4 - outshift;
				data[outofs] |= val << outshift;
			}	
		}
	}
	return true;
}

errno_t PASCAL GetFile(LPSTR src, long len, LPSTR dest, unsigned int flag, FARPROC prgressCallback,long lData)
{
	/* reject memory-input */
	if(flag & 7) return -1;
	/* reject file-output */
	if(!(flag & 0x700)) return -1;

	/* retrieve the index of the item from len */
	if(!(len >> 31)) return 3;
	int index = (len >> 23) & 0xFF;
	len &= 0x007FFFFF;

	/* open the CDG file */
	ATL::CAtlFile file;
	HRESULT hret = file.Create(src, GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING);
	if(FAILED(hret)) return 6;
	ULARGE_INTEGER uulen;
	hret = file.GetSize(uulen.QuadPart);
	if(FAILED(hret) || uulen.HighPart) return 6;

	/* read and deserialize the CDG header */
	hret = file.Seek(len, FILE_BEGIN);
	if(FAILED(hret)) return 6;
	BYTE buff[16];
	DWORD readsize;
	hret = file.Read(buff, 16, readsize);
	if(FAILED(hret) || readsize < 16) return 6;
	cdginfo info;
	if(!info.FromMemory(buff, uulen.LowPart)) return 2;

	/* read the CDG image */
	ATL::CAutoVectorPtr<BYTE> bits;
	const int planes[] = { 4, 5, 1 };
	DWORD sprsize = info.planesize * planes[info.type];
	if(!bits.Allocate(sprsize)) return 4;

	hret = file.Seek(sprsize * index, FILE_CURRENT);
	if(FAILED(hret)) return 1;
	hret = file.Read(bits.m_p, sprsize, readsize);
	if(FAILED(hret) || readsize < sprsize) return 6;

	/* covert the CDG image to a bitmap */
	CLocalPtr<BYTE> bitmap;
	switch(info.type)
	{
	case 2: /* monochrome CDG */
		if(!CDGMonoToBitmap(bitmap, bits, info)) return 4;
		break;
	default: /* color CDG (with/without mask pattern) */
		if(!CDGColorToBitmap(bitmap, bits, info)) return 4;
		break;
	}

	*reinterpret_cast<HLOCAL *>(dest) = bitmap.Detach();
	return 0;

}

int PASCAL ConfigurationDlg(HWND parent, int fnc)
{
	switch(fnc)
	{
	case 0: /* about */
		return -1;
	case 1: /* configuration */
		CDGConfigurationDlg(parent);
		break;
	default: /* reserved */
		return -1;
	}
	return 0;
}

#pragma comment(linker, "/entry:MyDllMain")

BOOL APIENTRY MyDllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{	
	switch(ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		g_modinst = reinterpret_cast<HINSTANCE>(hModule);
		g_heap = ::HeapCreate(0, 1024, 0);
		if(!g_heap) return FALSE;
		DisableThreadLibraryCalls(hModule);
		break;
	case DLL_PROCESS_DETACH:
		::HeapDestroy(g_heap);
	}
    return TRUE;
}

#ifdef _MANAGED
#pragma managed(pop)
#endif
