#include "stdafx.h"
#include "ConfigDlg.h"
#include "ProfileIO.h"
#include "resource.h"

#define HANDLE_DLGMSG(hwnd, message, fn)    \
    case (message): return (SetDlgMsgResult(hwnd, message, \
		HANDLE_##message((hwnd), (wParam), (lParam), (fn))));

extern HINSTANCE g_modinst;

bool CDGSelectPaletteDlg(HWND hwndParent, char *buff, int len)
{
	OPENFILENAME ofn;

	RtlZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR;
	ofn.hwndOwner = hwndParent;
	ofn.lpstrFilter = "Palette (*.RGB)\0*.RGB\0\0";
	ofn.lpstrFile = buff;
	ofn.nMaxFile = len;
	return GetOpenFileName(&ofn) != FALSE;
}

LRESULT OnInitDialog(HWND hwndDlg, HWND hwndFirstCtl, LPARAM dwInitParam)
{
	char palpath[2048];
	CProfileIO profile("THSSP.INI");
	profile.ReadString("Palette", "Path", NULL, palpath, sizeof(palpath));
	SetDlgItemText(hwndDlg, IDC_PATH, palpath);
	CheckDlgButton(hwndDlg, IDC_SETEVERYTIMES,
		profile.ReadInteger("Palette", "SetEverytimes", 0) ? 
			BST_CHECKED: BST_UNCHECKED);

	return TRUE;
}

void inline OnBrowseClick(HWND hwndDlg, HWND hwndCtl)
{
	char palpath[2048];

	GetDlgItemText(hwndDlg, IDC_PATH, palpath, sizeof(palpath));
	if(CDGSelectPaletteDlg(hwndDlg, palpath, 2048))
	{
		SetDlgItemText(hwndDlg, IDC_PATH, palpath);
	}
}

void inline OnOKClick(HWND hwndDlg, HWND hwndCtl)
{
	char palpath[2048];
	GetDlgItemText(hwndDlg, IDC_PATH, palpath, sizeof(palpath));

	CProfileIO profile("THSSP.INI");
	profile.WriteString("Palette", "Path", palpath);
	profile.WriteInteger("Palette", "SetEverytimes",
		IsDlgButtonChecked(hwndDlg, IDC_SETEVERYTIMES) == BST_CHECKED);

	EndDialog(hwndDlg, IDOK);
}

void inline OnSetEverytimesClick(HWND hwndDlg, HWND hwndCtl)
{
}

void OnCommand(HWND hwndDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id)
	{
	case IDOK:
		OnOKClick(hwndDlg, hwndCtl);
		break;
	case IDCANCEL:
		EndDialog(hwndDlg, IDCANCEL);
		break;
	case IDC_BROWSE:
		OnBrowseClick(hwndDlg, hwndCtl);
		break;
	}

}

BOOL CALLBACK DialogProc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg)
	{
		HANDLE_DLGMSG(hwndDlg, WM_INITDIALOG, OnInitDialog)
		HANDLE_DLGMSG(hwndDlg, WM_COMMAND, OnCommand)
	}
	return FALSE;
}

int CDGConfigurationDlg(HWND hwndParent)
{
	return DialogBoxParam(g_modinst, MAKEINTRESOURCE(IDD_CONFIG),
		hwndParent, DialogProc, 0);
}
