#include "pch.hpp"
#include "TH135AddrDef.h"
#include "Solfisk.hpp"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define POLL_INTERVAL 50

#define Default_WindowClass    _T("th135")
#define Default_WindowCaption  _T("SYO Ver1.20")
#define Default_CoreBase       0x004D8348

static TH135CHARNAME s_charNames[] = {
	{ _T("얲"), _T("얲") },
	{ _T("J"), _T("") },
	{ _T("_"), _T("") },
	{ _T("@"), _T("@") },
	{ _T("zs"), _T("zs") },
	{ _T("L_q"), _T("_q") },
	{ _T("͏ɂƂ"), _T("ɂƂ") },
	{ _T("Ön"), _T("") },
	{ _T("b}~]E"), _T("}~]E") },
	{ _T("`"), _T("") }
};

static TCHAR s_WindowClass[256];
static TCHAR s_WindowCaption[256];

static DWORD s_CoreBase;

static HANDLE s_ThProc;
static HWND   s_ThWnd;
static MODULEINFO s_th135ModuleInfo;

static HWND s_callbackWnd;
static int  s_callbackMsg;

static HANDLE s_userThread;
static HANDLE s_thread;
static DWORD s_threadId;

static int s_paramOld[TH135PARAM_MAX];
static Minimal::ProcessHeapStringA s_paramStr;

static TH135STATE s_TH135State;

static void TH135LoadProfile()
{
#define LoadAddress(N) { TCHAR addrStr[16]; \
	s_##N = profile.ReadString(_T("Address"), _T(#N), _T(""), addrStr, sizeof addrStr); \
	if (!::StrToIntEx(addrStr, STIF_SUPPORT_HEX, reinterpret_cast<int *>(&s_##N))) s_##N = Default_##N;  }
#define LoadChar(N) profile.ReadString(_T("TH135"), _T(#N), Default_##N, s_##N, sizeof s_##N)

	Minimal::ProcessHeapPath profPath = g_appPath;
	CProfileIO profile(profPath /= _T("TH135Addr.ini"));
	LoadChar(WindowClass);
	LoadChar(WindowCaption);

	LoadAddress(CoreBase);
}

// strtok ̂悤 iterator class
class StringSplitter {
private:
	Minimal::ProcessHeapStringA buff;
	LPCSTR begin;
	LPCSTR end;
	char sep;

public:
	StringSplitter(LPCSTR src, char separator):
		begin(src), end(src), sep(separator) {}

public:
	LPCSTR Next() {
		if (begin == NULL) return NULL;
		end = ::StrChrA(begin, sep);
		if (end == NULL) {
			buff = begin;
			begin = end;
		} else {
			buff = Minimal::ProcessHeapStringA(begin, end).GetRaw();
			begin = end + 1;
		}
		return buff.GetRaw();
	}
};

// CoreBase class instance ɂ SQVM instance  Root Table  w肳ꂽpX item value  fetch
static bool FindRTChild(LPCSTR path, DWORD &retType, DWORD &retVal)
{
	DWORD_PTR items;
	DWORD_PTR itemVal;
	DWORD_PTR itemVal2;
	DWORD itemType;
	DWORD itemNum;
	DWORD itemLen;
	DWORD itemIndex;
	DWORD readSize;
	BOOL ret;
	DWORD j;

	// CoreBase  table ǂݍ
	ret = ::ReadProcessMemory(s_ThProc, (LPVOID)((DWORD_PTR)s_th135ModuleInfo.lpBaseOfDll + s_CoreBase), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;
	ret = ::ReadProcessMemory(s_ThProc, (LPVOID)((DWORD_PTR)itemVal + 0x34), &itemVal, sizeof itemVal, &readSize);
	if (!ret) return false;

	itemType = 0x20;

	StringSplitter tokenizer(path, '/');
	LPCSTR pathToken;
	while (pathToken = tokenizer.Next()) {
		switch(itemType & 0xFFFFF) {
		case 0x20:	// TABLE
			// Table ̏ǂݍ
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Table items T
			for (j = 0; j < itemNum; ++j) {
				// Table item key ǂݍ
				ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x0c), &itemVal, sizeof itemVal, &readSize);
				if (!ret) return false;
				//  Table item key ̂Ƃ󂯕t
				if ((itemType & 0xFFFFF) == 0x10) {	
					//  Table item key 𕶎Ƃēǂݍ
					ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x14), &itemLen, sizeof itemLen, &readSize);
					if (!ret) return false;
					Minimal::ProcessHeapArrayT<char> key(itemLen + 1);
					ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x1C), key.GetRaw(), itemLen, &readSize);
					if (!ret) return false;
					key[itemLen] = 0;
					// Table item key ̒l path ̃g[Nƈv table item value ǂݍ
					if (::lstrcmpA(key.GetRaw(), pathToken) == 0) {
						ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
						if (!ret) return false;
						ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x04), &itemVal, sizeof itemVal, &readSize);
						if (!ret) return false;
						break;
					}
				}
			}
			if (j == itemNum) return false;
			break;
		case 0x40:	// ARRAY
			// Array item ̐擪AhX item ǂݍ
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x1C), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			// Path ̃g[N Array item  index ƌȂĔ͈̓`FbN
			itemIndex = StrToIntA(pathToken);
			if(itemNum <= itemIndex) return false;
			// Array item ǂݍ
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + itemIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + itemIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
			if (!ret) return false;
			break;
		case 0x8000:	// INSTANCE
			// Instance members ̏ǂݍ
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x1C), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + 0x18), &items, sizeof items, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + 0x24), &itemNum, sizeof itemNum, &readSize);
			if (!ret) return false;
			ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + 0x20), &items, sizeof items, &readSize);
			if (!ret) return false;
			// Instance members T
			for (j = 0; j < itemNum; ++j) {
				// Instance member metadata value ǂݍ
				ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x00), &itemType, sizeof itemType, &readSize);
				if (!ret) return false;
				ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x04), &itemVal2, sizeof itemVal, &readSize);
				if (!ret) return false;
				// Instance member metadata value LȂƂ󂯕t
				if ((itemType & 0xFFFFF) == 0x02) {
					// Instance member metadata value  instance member type  instance member index 𒊏o
					DWORD memberType  = itemVal2 & 0xFF000000;
					DWORD memberIndex = itemVal2 & 0x00FFFFFF;
					// Instance member type LȂƂ󂯕t
					if (memberType == 0x02000000) {
						// Instance member metadata key ǂݍ
						ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x08), &itemType, sizeof itemType, &readSize);
						if (!ret) return false;
						ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(items + j * 0x14 + 0x0c), &itemVal2, sizeof itemVal, &readSize);
						if (!ret) return false;
						// Instance member metadata key ̂Ƃ󂯕t
						if ((itemType & 0xFFFFF) == 0x10) {
							//  Instance member metadata key 𕶎Ƃēǂݍ
							ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal2 + 0x14), &itemLen, sizeof itemLen, &readSize);
							if (!ret) return false;
							Minimal::ProcessHeapArrayT<char> key(itemLen + 1);
							ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal2 + 0x1C), key.GetRaw(), itemLen, &readSize);
							if (!ret) return false;
							key[itemLen] = 0;
							// Instance member metadata key ̒l path ̃g[Nƈv instance member value ǂݍ
							if (::lstrcmpA(key.GetRaw(), pathToken) == 0) {
								ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x00), &itemType, sizeof itemType, &readSize);
								if (!ret) return false;
								ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(itemVal + 0x2C + memberIndex * 0x08 + 0x04), &itemVal, sizeof itemVal, &readSize);
								if (!ret) return false;
								break;
							}
						}
					}
				}
			}
			if (j == itemNum) return false;
			break;
		}
	}

	retType = itemType;
	retVal = itemVal;
	return true;
}

// Squirrel item value  string  fetch
static bool RTChildToString(DWORD_PTR childVal, Minimal::ProcessHeapStringA &out)
{
	DWORD strLen;
	DWORD readSize;
	BOOL ret;

	ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(childVal + 0x14), &strLen, sizeof strLen, &readSize);
	if (!ret) return false;
	Minimal::ProcessHeapArrayT<char> buff(strLen + 1);
	ret = ::ReadProcessMemory(s_ThProc, (LPVOID)(childVal + 0x1C), buff.GetRaw(), strLen, &readSize);
	if (!ret) return false;
	buff[strLen] = 0;
	out = buff.GetRaw();
	return true;
}

static void APIENTRY InterruptAPCCallback(ULONG_PTR)
{
}

static void TH135Callback(short Msg, short param1, int param2)
{
	if (s_callbackWnd) {
		::PostMessage(s_callbackWnd, s_callbackMsg, MAKELONG(Msg, param1), param2);
	}
}

static TH135STATE TH135StateFindWindow()
{
	s_ThWnd = ::FindWindow(s_WindowClass, s_WindowCaption);
	if (s_ThWnd != NULL) {
		DWORD dwThId;
		::GetWindowThreadProcessId(s_ThWnd, &dwThId);
		s_ThProc = ::OpenProcess(PROCESS_ALL_ACCESS, FALSE, dwThId);

		DWORD enumBufNeeded;
		::EnumProcessModules(s_ThProc, NULL, 0, &enumBufNeeded);
		Minimal::ProcessHeapArrayT<HMODULE> modules(enumBufNeeded);
		::EnumProcessModules(s_ThProc, modules.GetRaw(), enumBufNeeded, &enumBufNeeded);

		::GetModuleInformation(s_ThProc, modules[0], &s_th135ModuleInfo, sizeof s_th135ModuleInfo);

		TH135Callback(TH135MSG_STATECHANGE, TH135STATE_WAITFORNETBATTLE, 0);
		::ZeroMemory(s_paramOld, sizeof s_paramOld);
		return TH135STATE_WAITFORNETBATTLE;
	} else {
		return TH135STATE_NOTFOUND;
	}
}

static TH135STATE TH135StateWaitForNetBattle()
{
	DWORD ret = ::WaitForSingleObject(s_ThProc, 0);
	if (ret != WAIT_TIMEOUT) {
		::CloseHandle(s_ThProc);
		s_ThProc = NULL;
		TH135Callback(TH135MSG_STATECHANGE, TH135STATE_NOTFOUND, 0);
		return TH135STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		return TH135STATE_NETBATTLE;
	} else {
		return TH135STATE_WAITFORNETBATTLE;
	}
}

static TH135STATE TH135StateNetBattle()
{
	DWORD ret = ::WaitForSingleObject(s_ThProc, 0);
	if (ret != WAIT_TIMEOUT) {
		::CloseHandle(s_ThProc);
		s_ThProc = NULL;
		TH135Callback(TH135MSG_STATECHANGE, TH135STATE_NOTFOUND, 0);
		return TH135STATE_NOTFOUND;
	}

	DWORD childType, childVal;
	if ((::FindRTChild("game", childType, childVal) && (childType & 0x20) != 0) &&
		(::FindRTChild("network_inst", childType, childVal) && (childType & 0x8000) != 0) &&
		(::FindRTChild("network_is_watch", childType, childVal) && (childType & 0x8) != 0 && childVal == 0)) {
		int param;
		for (int i = 0; i < TH135PARAM_MAX; ++i) {
			if ((param = TH135AddrGetParam(i)) != -1) {
				if (param != s_paramOld[i])
					TH135Callback(TH135MSG_PARAMCHANGE, i, param);
				s_paramOld[i] = param;
			} else s_paramOld[i] = 0;
		}
		return TH135STATE_NETBATTLE;
	} else {
		return TH135STATE_WAITFORNETBATTLE;
	}
}

static DWORD WINAPI TH135AddrWorkThread(LPVOID)
{
	MSG msg;

	s_TH135State = TH135STATE_NOTFOUND;
	while(!::PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) || msg.message != WM_QUIT) {
		switch(s_TH135State) {
		case TH135STATE_NOTFOUND:            s_TH135State = TH135StateFindWindow(); break;
		case TH135STATE_WAITFORNETBATTLE:    s_TH135State = TH135StateWaitForNetBattle(); break;
		case TH135STATE_NETBATTLE:           s_TH135State = TH135StateNetBattle(); break;
		};
		::SleepEx(POLL_INTERVAL, TRUE);
	}
	::ExitThread(0);
	return 0;
}

int TH135AddrInit(HWND callbackWnd, int callbackMsg)
{
	TH135LoadProfile();
	s_callbackWnd = callbackWnd;
	s_callbackMsg = callbackMsg;
	s_thread = ::CreateThread(NULL, 0, TH135AddrWorkThread, NULL, 0, &s_threadId);
	s_userThread = ::GetCurrentThread();
	return s_thread != NULL;
}

int TH135AddrFinish()
{
	if (s_thread) {
		::PostThreadMessage(s_threadId, WM_QUIT, 0, 0);
		::QueueUserAPC(InterruptAPCCallback, s_thread, 0);
		::WaitForSingleObject(s_thread, INFINITE);
		::CloseHandle(s_thread);
	}
	return 0;
}

TH135STATE TH135AddrGetState()
{
	return s_TH135State;
}

DWORD_PTR TH135AddrGetParam(int param)
{
	DWORD childType, childVal, readSize;

	switch(param) {
	case TH135PARAM_BATTLESTATE:
		if (::FindRTChild("game/battleState", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH135PARAM_ISNETCLIENT:
		if (::FindRTChild("network_is_client", childType, childVal) && (childType & 0xFFFFF) == 0x08) { 
			return childVal;
		}
		break;
	case TH135PARAM_P1CHAR:
		if (::FindRTChild("load_data/player/0", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH135PARAM_P2CHAR:
		if (::FindRTChild("load_data/player/1", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH135PARAM_P1WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p1/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH135PARAM_P2WIN:
		if (::FindRTChild("act/BattleStatus/global/status/p2/win", childType, childVal) && (childType & 0xFFFFF) == 0x02) { 
			return childVal;
		}
		break;
	case TH135PARAM_TOADDR:
		if ((::FindRTChild("mb_client", childType, childVal) && (childType & 0xFFFFF) == 0x8000) || (::FindRTChild("mb_server", childType, childVal) && (childType & 0xFFFFF) == 0x8000)) {
			if (::ReadProcessMemory(s_ThProc, (LPCVOID)(childVal + 0x20), &childVal, sizeof childVal, &readSize) && readSize == 4) {
				if (::ReadProcessMemory(s_ThProc, (LPCVOID)(childVal + 0x10), &childVal, sizeof childVal, &readSize) && readSize == 4) {
					if (::ReadProcessMemory(s_ThProc, (LPCVOID)(childVal + 0x23C), &childVal, sizeof childVal, &readSize) && readSize == 4) {
						return childVal;
					}
				}
			}
		}
		break;
	case TH135PARAM_P1NAME:
		if (::FindRTChild("load_data/profile/0/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, s_paramStr)) { 
			return (DWORD_PTR)s_paramStr.GetRaw();
		}
		break;
	case TH135PARAM_P2NAME:
		if (::FindRTChild("load_data/profile/1/name", childType, childVal) && (childType & 0xFFFFF) == 0x10 && RTChildToString(childVal, s_paramStr)) {
			return (DWORD_PTR)s_paramStr.GetRaw();
		}
		break;
	}
	return -1;
}

const TH135CHARNAME * const TH135AddrGetCharName(int index)
{
	if (TH135AddrGetCharCount() <= index) return NULL;
	return &s_charNames[index];
}

int TH135AddrGetCharCount()
{
	return _countof(s_charNames);
}
