/*
  Unzan.cpp - The partner of Ichirin Kumoi. imba strong daemon ;-)

  Written in 2013 by Sakra Yukikaze <sakura_yukikaze@live.jp> 

  To the extent possible under law, the author(s) have dedicated all copyright and related and neighboring rights to this software to the public domain worldwide.
  This software is distributed without any warranty. 

  You should have received a copy of the CC0 Public Domain Dedication along with this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>. 
 */

#include <Windows.h>
#include <ImageHlp.h>
#include <stdio.h>

#pragma comment (lib, "imagehlp.lib")

const void *memmem(const void *haystack, size_t hlen, const void *needle, size_t nlen)
{
	if (nlen == 0) {
		return haystack;
	}
	if (hlen < nlen) {
		return nullptr;
	}

	const unsigned char *hay = static_cast<const unsigned char *>(haystack);
	const unsigned char *tip = static_cast<const unsigned char *>(needle);
	size_t shifts[UCHAR_MAX + 1];

	for (size_t i = 0; i < _countof(shifts); ++i) {
		shifts[i] = nlen + 1;
	}
	for (size_t i = 0; i < nlen; ++i) {
		shifts[tip[i]] = nlen - i;
	}
	for (size_t i = 0; i <= hlen - nlen; i += shifts[hay[i + nlen]]) {
		if (!memcmp(tip, hay + i, nlen)) {
			return hay + i;
		}
	}

	return nullptr;
}

const void *findNearCall(const void *haystack, size_t hlen, const void *callee) {
	const unsigned char *begin = static_cast<const unsigned char *>(haystack);
	const unsigned char *last_possible = begin + hlen - sizeof(callee) - 1;
	ptrdiff_t tail = static_cast<const unsigned char *>(callee) - begin - 5;

	for (; begin <= last_possible; begin++, tail--) {
		if (*begin == 0xE8 && !memcmp(begin + 1, &tail, sizeof tail)) {
			return begin;
		}
	}

	return nullptr;
}

PIMAGE_SECTION_HEADER getSection(LOADED_IMAGE &img, PCSTR sectionName)
{
	for(ULONG i = 0; i < img.NumberOfSections; ++i) {
		if(strcmp(reinterpret_cast<char *>(img.Sections[i].Name), sectionName) == 0) {
			return &img.Sections[i];
		}
	}

	return nullptr;
}

int main(int argc, char *argv[])
{
	if (argc != 2) {
		puts("Usage: <program> path\n");
		return 1;
	}

	LOADED_IMAGE img;
	if (!::MapAndLoad(argv[1], NULL, &img, FALSE, TRUE)) {
		return 1;
	}

	PIMAGE_SECTION_HEADER text = getSection(img, ".text");
	PIMAGE_SECTION_HEADER rdata = getSection(img, ".rdata");
	PIMAGE_SECTION_HEADER data = getSection(img, ".data");
	if (!text || !rdata || !data) {
		return 2;
	}
	PVOID textBase = ImageRvaToVa(img.FileHeader, img.MappedAddress, text->VirtualAddress, NULL);
	PVOID dataBase = ImageRvaToVa(img.FileHeader, img.MappedAddress, data->VirtualAddress, NULL);
	PVOID rdataBase = ImageRvaToVa(img.FileHeader, img.MappedAddress, rdata->VirtualAddress, NULL);
	DWORD textSize = (text->Misc.VirtualSize + img.FileHeader->OptionalHeader.SectionAlignment - 1) & ~(img.FileHeader->OptionalHeader.SectionAlignment - 1);
	DWORD dataSize = (data->Misc.VirtualSize + img.FileHeader->OptionalHeader.SectionAlignment - 1) & ~(img.FileHeader->OptionalHeader.SectionAlignment - 1);
	DWORD rdataSize = (rdata->Misc.VirtualSize + img.FileHeader->OptionalHeader.SectionAlignment - 1) & ~(img.FileHeader->OptionalHeader.SectionAlignment - 1);

	// Search the RTTI string '.?AUSQVM@@'
	const unsigned char * sqvmRttiStr = static_cast<const unsigned char *>(memmem(dataBase, dataSize, ".?AUSQVM@@", 10));
	if (!sqvmRttiStr) {
		return 3;
	}
	DWORD_PTR sqvmRttiStrRef = img.FileHeader->OptionalHeader.ImageBase + data->VirtualAddress + (sqvmRttiStr - 8 - static_cast<const unsigned char *>(dataBase));

	// Search the RTTI instance of SQVM
	const unsigned char * sqvmRtti = static_cast<const unsigned char *>(memmem(rdataBase, rdataSize, &sqvmRttiStrRef, sizeof DWORD_PTR));
	if (!sqvmRtti) {
		return 4;
	}
	DWORD_PTR sqvmRttiRef = img.FileHeader->OptionalHeader.ImageBase + rdata->VirtualAddress + (sqvmRtti - 12 - static_cast<const unsigned char *>(rdataBase));

	// Search the vtbl of the RTTI instance of SQVM
	const unsigned char * sqvmVtblRtti = static_cast<const unsigned char *>(memmem(rdataBase, rdataSize, &sqvmRttiRef, 4));
	if (!sqvmVtblRtti) {
		return 5;
	}
	DWORD_PTR sqvmVtblRef = img.FileHeader->OptionalHeader.ImageBase + rdata->VirtualAddress + (sqvmVtblRtti + 4 - static_cast<const unsigned char *>(rdataBase));

	// Search the code that uses the vtbl.
	const unsigned char * sqvmCtorHint = static_cast<const unsigned char *>(memmem(textBase, textSize, &sqvmVtblRef, sizeof DWORD_PTR));
	if (!sqvmCtorHint) {
		return 6;
	}

	// Search SQVM::SQVM
	sqvmCtorHint -= 0x40;
	const unsigned char sqvmCtorHead[] = { 0x55, 0x8B, 0xEC, 0x6A, 0xFF };
	const unsigned char * sqvmCtor = static_cast<const unsigned char *>(memmem(sqvmCtorHint, 0x40, sqvmCtorHead, sizeof sqvmCtorHead));
	if (!sqvmCtor) {
		return 7;
	}

	// Search a code that calls the constructor of SQVM
	const unsigned char * sq_openHint = static_cast<const unsigned char *>(findNearCall(textBase, textSize, sqvmCtor));
	if (!sq_openHint) {
		return 8;
	}

	// Search sq_open
	sq_openHint -= 0x48;
	const unsigned char sq_openHead[] = { 0x55, 0x8B, 0xEC }; // push ebp; mov ebp, esp
	const unsigned char * sq_open = static_cast<const unsigned char *>(memmem(sq_openHint, 0x48, sq_openHead, sizeof sq_openHead));
	if (!sq_open) {
		return 9;
	}

	// Search the code that calls sq_open
	const unsigned char * mysq_createHint = static_cast<const unsigned char *>(findNearCall(textBase, textSize, sq_open));
	if (!mysq_createHint) {
		return 10;
	}

	// Search the code that calls mysq_create
	const unsigned char * mysq_initHint;
	int mysq_initHintFindOffset = 1;
	for(; mysq_initHintFindOffset <= 0x10; ++mysq_initHintFindOffset) {
		const unsigned char * mysq_create = mysq_createHint - mysq_initHintFindOffset; // push reg32; push imm32(0x400)
		mysq_initHint = static_cast<const unsigned char *>(findNearCall(textBase, textSize, mysq_create));
		if (mysq_initHint) {
			break;
		}
	}
	if (mysq_initHintFindOffset > 0x10) {
		return 11;
	}

	// Search the code that put the SQVM instance (eax) in the global variable.
	mysq_initHint += 5;
	const unsigned char movToGlobalVarHintOps[] = { 0x51, 0xA3 }; // push ecx; mov ds:[imm32], eax
	const unsigned char * movToGlobalVarHint = static_cast<const unsigned char *>(memmem(mysq_initHint, 0x18, movToGlobalVarHintOps, sizeof movToGlobalVarHintOps));
	if (!movToGlobalVarHint) {
		return 12;
	}

	const void *movToGlobalVarImmRef = movToGlobalVarHint + 2;
	printf("0x%08x\n", *static_cast<const DWORD_PTR*>(movToGlobalVarImmRef) - img.FileHeader->OptionalHeader.ImageBase);

	return 0;
}