#ifndef TH135ADDRDEF_H_INCLUDED
#define TH135ADDRDEF_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

enum TH135CBMSG {
	TH135MSG_STATECHANGE,
	TH135MSG_PARAMCHANGE,
};

enum TH135STATE {
	TH135STATE_NOTFOUND,
	TH135STATE_WAITFORNETBATTLE,
	TH135STATE_NETBATTLE
};

enum TH135SCHAR {
	TH135CHAR_REIMU = 0,
	TH135CHAR_MARISA = 1,
	TH135CHAR_ICHIRIN = 2,
	TH135CHAR_LIMIT = 10,
};

enum TH135PARAM {
	TH135PARAM_BATTLESTATE,
	TH135PARAM_ISNETCLIENT,
	TH135PARAM_P1CHAR,
	TH135PARAM_P2CHAR,
	TH135PARAM_P1WIN,
	TH135PARAM_P2WIN,
	TH135PARAM_TOADDR,
	TH135PARAM_MAX,
	TH135PARAM_P1NAME,
	TH135PARAM_P2NAME,
};

typedef void (__cdecl *TH135ADDRCALLBACKPROC)(int, int, int, void *);

typedef struct {
	PCTSTR full;
	PCTSTR abbr;
} TH135CHARNAME;

int TH135AddrInit(HWND, int);
int TH135AddrFinish();
DWORD_PTR TH135AddrGetParam(int);
TH135STATE TH135AddrGetState();
const TH135CHARNAME * const TH135AddrGetCharName(int index);
int TH135AddrGetCharCount();


#ifdef __cplusplus
}
#endif

#endif /* TH135ADDRDEF_H_INCLUDED */
