﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;

namespace NetVision {

    /// <summary>
    /// 手札コントローラ
    /// </summary>
    public class HandControl : AreaControl {


        /// <summary>
        /// カードの追加
        /// </summary>
        public override void Add(CardBox card) {
            card.Area = AreaType.Hands;
            card.FaceSide = false;
            card.Active = true;
            Cards.Add(card);
            card.Public = false;
            Controls.Add(card);
            card.BringToFront();
            card.Redraw();
            RedrawCards();
        }


        /// <summary>
        /// カードの除外
        /// </summary>
        /// <param name="card"></param>
        public override void Remove( CardBox card ) {
            Cards.Remove(card);
            card.CoverColor = Color.FromKnownColor(KnownColor.Transparent);
            Controls.Remove(card);
            RedrawCards();
        }

        /// <summary>
        /// カードの整列
        /// </summary>
        public override void RedrawCards() {
            CaptionLabel.Text = "手札（" + Count.ToString() + "）";
            int top_margin = Player.IsUpSide ? 0 : 11;
            int left_margin = 3;
            if (Count <= 0) { return; }

            if (this[0].Width * (Count + 1) <= this.Width) {
                for (int i = 0; i < Count; i++) {
                    this[i].Location = new Point(i * (this[i].Width + 5) + left_margin, top_margin);
                }
            }
            else {
                for (int i = 0; i < Count; i++) {
                    this[i].Location = new Point((Width - this[i].Width / 2) * i / Count + left_margin, top_margin);
                }
            }
            int node = Player.Nodes.Count;
            if (Properties.Settings.Default.NodeAssist && Player.Type == PlayerType.Control) {
                foreach (CardBox card in Cards) {
                    if (Player.State != PlayerState.MyTurn &&
                        ( card.Info.Type == CardType.Spell || card.Info.Type == CardType.Character && !card.Info.Skill.Contains("奇襲") )) {
                        card.CoverColor = Color.FromArgb(72, Color.Blue); 
                    }
                    else if (card.Info.Type == CardType.Character && Player.SummonChar.Checked
                        && !card.Info.Skill.Contains("奇襲") && !card.Info.Skill.Contains("人形")
                        || Player.SummonDoll.Checked && card.Info.Skill.Contains("人形")) {
                        card.CoverColor = Color.FromArgb(72, Color.Blue);
                    }
                    else if (card.Info.Type == CardType.Command
                        && (card.Info.Skill.Contains("相手ターン") && Player.State == PlayerState.MyTurn
                        || card.Info.Skill.Contains("自分ターン") && Player.State == PlayerState.YourTurn)) {
                        card.CoverColor = Color.FromArgb(72, Color.Blue);
                    }
                    else if (card.Info.NodeNum <= node && card.Info.Node != "-"
                        || card.Info.Type == CardType.Spell && card.FaceSide && Player.BattleField.IsCasterExist(card.Info.User)) {
                        card.CoverColor = Color.FromKnownColor(KnownColor.Transparent);
                    }
                    else { card.CoverColor = Color.FromArgb(72, Color.Blue); }
                }
            }
            Refresh();
        }

    }
}
