﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace NetVision {
    /// <summary>
    /// 冥界コントローラ
    /// </summary>
    public class GraveControl : AreaControl {


        /// <summary>
        /// 一番上のカード
        /// </summary>
        public CardBox First {
            get {
                if (Count == 0) { return null; }
                return Cards[0];
            }
        }

        /// <summary>
        /// カードの追加
        /// </summary>
        /// <param name="card">追加するカード</param>
        public override void Add( CardBox card ) {
            Cards.Insert(0, card);
            Controls.Add(card);
            card.Area = this.Type;
            card.Location = new Point(( Width - Properties.Settings.Default.CardSize.Width ) / 2, Player.IsUpSide ? 0 : 11);
            card.FaceSide = true;
            card.Active = true;
            card.Public = true;
            card.Redraw();
            RedrawCards();
        }

        /// <summary>
        /// カードの削除
        /// </summary>
        /// <param name="card">抜き出すカード</param>
        public override void Remove( CardBox card ) {
            Cards.Remove(card);
            Controls.Remove(card);
            RedrawCards();
        }

        /// <summary>
        /// 再描画
        /// </summary>
        public override void RedrawCards() {
            CaptionLabel.Text = "冥界（" + Count.ToString() + "）";
            if (Count > 1) {
                First.BringToFront();
            }
            CaptionLabel.BringToFront();
            ToolLink.BringToFront();
        }

    
    
    }
}
