﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetVision {

    /// <summary>
    /// カードの種類
    /// </summary>
    public enum CardType {

        /// <summary>
        /// 未定義
        /// </summary>
        Undef,
        
        /// <summary>
        /// キャラクター
        /// </summary>
        Character,

        /// <summary>
        /// スペルカード
        /// </summary>
        Spell,

        /// <summary>
        /// コマンドカード
        /// </summary>
        Command,


    }

    /// <summary>
    /// プレイヤーの状態
    /// </summary>
    public enum PlayerState {

        /// <summary>
        /// まだロードされていない
        /// </summary>
        UnLoad,

        /// <summary>
        /// これからゲーム開始
        /// </summary>
        UnStart,

        /// <summary>
        /// 自分のターン
        /// </summary>
        MyTurn,

        /// <summary>
        /// 自分のターンでない
        /// </summary>
        YourTurn,

        /// <summary>
        /// ゲームが終わっている
        /// </summary>
        GameEnded,

    }

    /// <summary>
    /// プレイヤーのタイプ
    /// </summary>
    public enum PlayerType {

        /// <summary>
        /// 未定義
        /// </summary>
        Undef,

        /// <summary>
        /// 自分がコントロール
        /// </summary>
        Control,

        /// <summary>
        /// リモートプレイヤー
        /// </summary>
        Network,

        /// <summary>
        /// リプレイ
        /// </summary>
        Replay,

        /// <summary>
        /// 観戦モード
        /// </summary>
        Watch,

    }

    
    /// <summary>
    /// エリアフィールドのタイプ
    /// </summary>
    public enum AreaType {

        /// <summary>
        /// 未定義
        /// </summary>
        Undef,

        /// <summary>
        /// 場
        /// </summary>
        Field,

        /// <summary>
        /// 手札
        /// </summary>
        Hands,

        /// <summary>
        /// 山札
        /// </summary>
        Deck,

        /// <summary>
        /// 山札の下
        /// </summary>
        UnderDeck,

        /// <summary>
        /// ノード
        /// </summary>
        Nodes,

        /// <summary>
        /// 冥界
        /// </summary>
        Grave,

        /// <summary>
        /// 除外領域
        /// </summary>
        Removed,

        /// <summary>
        /// サイドボード
        /// </summary>
        SideBord,

        /// <summary>
        /// プレイエリア
        /// </summary>
        PlayArea,
        
    }

    /// <summary>
    /// 場に出るカードのタイプ
    /// </summary>
    public enum PlayingType {

        /// <summary>
        /// 未定義
        /// </summary>
        Undef,

        /// <summary>
        /// キャラクター
        /// </summary>
        Character,

        /// <summary>
        /// 幻想生物
        /// </summary>
        Phantasmal,

        /// <summary>
        /// 装備/場
        /// </summary>
        Equip,

        /// <summary>
        /// 呪符
        /// </summary>
        Amulet,

        /// <summary>
        /// 装備/場
        /// </summary>
        FieldsEquip,

        /// <summary>
        /// 世界呪符
        /// </summary>
        WorldsAmulet,

        /// <summary>
        /// 裏向き
        /// </summary>
        Reverse,

        /// <summary>
        /// 瞬間
        /// </summary>
        Moment,

    }


    /// <summary>
    /// コマンドタイプ
    /// </summary>
    public enum CommandType {

        /// <summary>
        /// 何もしない
        /// </summary>
        Undef,

        /// <summary>
        /// 接続
        /// </summary>
        Connect,

        /// <summary>
        /// デッキをロード
        /// </summary>
        DeckLoad,

        /// <summary>
        /// 場の内容を全て送る 
        /// </summary>
        UpdateAll,

        /// <summary>
        /// チャット会話
        /// </summary>
        Talk,

        /// <summary>
        /// カード座標の移動
        /// </summary>
        Move,

        /// <summary>
        /// 別の領域への移動
        /// </summary>
        Jump,

        /// <summary>
        /// カード状態の変更
        /// </summary>
        Change,

        /// <summary>
        /// カードをドロー
        /// </summary>
        Draw,

        /// <summary>
        /// ゲーム開始
        /// </summary>
        GameStart,

        /// <summary>
        /// ターン開始
        /// </summary>
        TurnStart,

        /// <summary>
        /// ターンエンド
        /// </summary>
        TurnEnd,

        /// <summary>
        /// プレイ
        /// </summary>
        Play,

        /// <summary>
        /// マナチャージ
        /// </summary>
        ManaCharge,

        /// <summary>
        /// アタック
        /// </summary>
        Attack,

        /// <summary>
        /// 防御
        /// </summary>
        Defend,

        /// <summary>
        /// 起動効果の使用
        /// </summary>
        StartEffect,

        /// <summary>
        /// 自動効果の発動
        /// </summary>
        AutoEffect,

        /// <summary>
        /// ライフの変更
        /// </summary>
        Life,

        /// <summary>
        /// 場のクリア
        /// </summary>
        Clear,

        /// <summary>
        /// コストの支払い
        /// </summary>
        PayCost,

        /// <summary>
        /// 山札のシャッフル
        /// </summary>
        Shuffle,

        /// <summary>
        /// シャッフルされた結果
        /// </summary>
        Shuffled,

        /// <summary>
        /// 敵をシャッフル
        /// </summary>
        ShuffleEnemy,

        /// <summary>
        /// 山札を見る
        /// </summary>
        ViewDeck,

        /// <summary>
        /// 山札を見るのをやめる
        /// </summary>
        UnViewDeck,

        /// <summary>
        /// 裏向きカード名の定義
        /// </summary>
        BackNameDefine,

        /// <summary>
        /// 表示順序の変更
        /// </summary>
        LayerChange,

        /// <summary>
        /// 相手の場へ移動
        /// </summary>
        MoveToEnemy,

        /// <summary>
        /// 乱数を発生
        /// </summary>
        Rand,




    }

}
