﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NetVision {
    public partial class CardListView : UserControl {
        public CardListView() {
            InitializeComponent();
        }

        /// <summary>
        /// リストが閉じられるか、移動するときに発生
        /// </summary>
        public event EventHandler ListClose;
        protected void OnListClose( object sender, EventArgs e ) {
            if (ListClose != null) { ListClose(sender, e); }
        }

        /// <summary>
        /// エリア
        /// </summary>
        public AreaType Area { get; private set; }

        /// <summary>
        /// カード群の表示
        /// </summary>
        /// <param name="area">表示するエリア</param>
        public void ShowCards(AreaControl area){
            ShowCards(area, -1);
        }

        /// <summary>
        /// 上からX枚見る
        /// </summary>
        /// <param name="area">表示するエリア</param>
        /// <param name="num">枚数</param>
        public void ShowCards( AreaControl area, int num ) {
            if (Visible) { OnListClose(this, new EventArgs()); }

            Area = area.Type;
            labelListCaption.Text = area.CaptionLabel.Text;
            List.Items.Clear();

            int count = 0;
            foreach (CardBox card in area.Cards) {
                if (num >= 0 && count == num) { break; }
                count++;
                ListViewItem it = new ListViewItem(card.Name);
                it.ToolTipText = card.Info.GetBreakedText(20);
                it.SubItems.Add(card.Info.Node);
                it.SubItems.Add(card.Info.Cost);
                it.Tag = card;
                List.Items.Add(it);
            }

            this.Visible = true;
        }



        /// <summary>
        /// 非表示
        /// </summary>
        private void button1_Click( object sender, EventArgs e ) {
            this.Visible = false;
        }

        /// <summary>
        /// 情報表示
        /// </summary>
        private void List_ItemMouseHover( object sender, ListViewItemMouseHoverEventArgs e ) {
            ListViewItem it = e.Item;
            CardBox card = (CardBox)it.Tag;
            card.Owner.CardInfo.ShowInfo(card.Info);
        }


        /// <summary>
        /// 移動メニューをクリック
        /// </summary>
        private void ToolStripMenuItemJumps_Click( object sender, EventArgs e ) {
            string title = ( (ToolStripItem)sender ).Text;
            Command com = new Command { Type = CommandType.Jump };
            switch (title) {
                case "場":
                    com.ToArea = AreaType.Field;
                    com.Active = true;
                    com.FaceSide = true;
                    break;
                case "場[S]":
                    com.ToArea = AreaType.Field;
                    com.Active = false;
                    com.FaceSide = true;
                    break;
                case "場[裏向き]":
                    com.ToArea = AreaType.Field;
                    com.Active = true;
                    com.FaceSide = false;
                    break;
                case "場[裏向き,S]":
                    com.ToArea = AreaType.Field;
                    com.Active = false;
                    com.FaceSide = false;
                    break;
                case "ノード":
                    com.ToArea = AreaType.Nodes;
                    com.Active = true;
                    break;
                case "ノード[S]":
                    com.ToArea = AreaType.Nodes;
                    com.Active = false;
                    break;
                case "手札":
                    com.ToArea = AreaType.Hands;
                    break;
                case "冥界":
                    com.ToArea = AreaType.Grave;
                    break;
                case "山札":
                    com.ToArea = AreaType.Deck;
                    break;
                case "山札の下":
                    com.ToArea = AreaType.UnderDeck;
                    break;
                case "除外":
                    com.ToArea = AreaType.Removed;
                    break;
                case "サイドボード":
                    com.ToArea = AreaType.SideBord;
                    break;
                default:
                    com.Type = CommandType.Undef;
                    break;
            }

            if (List.CheckedItems.Count == 0) {
                foreach (ListViewItem it in List.SelectedItems) {
                    CardBox card = (CardBox)it.Tag;
                    com.Card = card;
                    card.Player.SendCommand(com);
                    it.Remove();
                }
            }
            else {
                foreach (ListViewItem it in List.CheckedItems) {
                    CardBox card = (CardBox)it.Tag;
                    com.Card = card;
                    card.Player.SendCommand(com);
                    it.Remove();
                }
            }

        }

        private void CardListView_VisibleChanged( object sender, EventArgs e ) {
            if (!Visible) { OnListClose(this, new EventArgs()); }
        }

        private void 相手の場ToolStripMenuItem1_Click( object sender, EventArgs e ) {
            Command com = new Command { Type = CommandType.MoveToEnemy, ToArea = (AreaType)( (ToolStripMenuItem)sender ).Tag };
            if (List.CheckedItems.Count == 0) {
                foreach (ListViewItem it in List.SelectedItems) {
                    CardBox card = (CardBox)it.Tag;
                    com.Card = card;
                    com.Location = card.VirtualPoint;
                    card.Player.SendCommand(com);
                    it.Remove();
                }
            }
            else {
                foreach (ListViewItem it in List.CheckedItems) {
                    CardBox card = (CardBox)it.Tag;
                    com.Card = card;
                    com.Location = card.VirtualPoint;
                    card.Player.SendCommand(com);
                    it.Remove();
                }
            }
        }
/*
        private void List_ItemDrag( object sender, ItemDragEventArgs e ) {
            ListViewItem it = (ListViewItem)e.Item;
            CardBox card = (CardBox)it.Tag;
            Controls.Add(card);
//            card.BringToFront();
            card.FaceSide = true;
            card.Active = true;
            card.Location = it.Position;
            card.Redraw();
//            card.Visible = true;
            card.Player.CardCursor.Area = card.Area;
            card.Player.CardCursor.BaseLocation = it.Position;
            card.Player.CardCursor.CaptureCard(card); // カーソルでキャプチャ

        }
*/


    }
}
