﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;

namespace NetVision {

    /// <summary>
    /// サイドボード・除外エリアコントローラ
    /// </summary>
    public class SideControl : AreaControl {


        /// <summary>
        /// カードの追加
        /// </summary>
        /// <param name="card"></param>
        public override void Add( CardBox card ) {
            Cards.Add(card);
            Controls.Add(card);
            card.Area = Type;
            card.Public = Type == AreaType.Removed;
            card.Visible = false;
            RedrawCards();
        }

        /// <summary>
        /// カードの削除
        /// </summary>
        /// <param name="card"></param>
        public override void Remove( CardBox card ) {
            Cards.Remove(card);
            Controls.Remove(card);
            card.Visible = true;
            RedrawCards();
        }

        /// <summary>
        /// コントロールの再描画
        /// </summary>
        public override void RedrawCards() {
            CaptionLabel.Text = this.Text + "（" + Count.ToString() + "）" ;
        }



    }
}
