﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace NetVision {
    public partial class Player : System.Windows.Forms.Panel {



        #region 処理の分岐

        /// <summary>
        /// ダブルクリック時の処理
        /// </summary>
        /// <param name="card"></param>
        public void ExecDoubleClick( CardBox card ) {
            Command com = card.Command();
            switch (card.Area) {
                case AreaType.Hands:
                    SendCommand(new Command { Type = CommandType.Play, Card = card, Location = card.GetVirtualPoint(BattleField.EmptyLocation(card.Info.PlayingType), BattleField.Size) });
                    break;
                case AreaType.Deck:
                    SendCommand(new Command { Type = CommandType.Draw, Card = card, Value = 1, ToArea = AreaType.Hands });
                    break;
                case AreaType.Nodes:
                    SendCommand(new Command { Type = CommandType.PayCost, Card = card, Active = card.Active });
                    break;
                case AreaType.Field:
                    if (card.Active) {
                        if (State == PlayerState.MyTurn) { SendCommand(new Command { Type = CommandType.Attack, Card = card }); }
                        else if (State == PlayerState.YourTurn) { SendCommand(new Command { Type = CommandType.Defend, Card = card }); }
                    }
                    break;
                case AreaType.Grave:
                    SendCommand(new Command { Type = CommandType.Jump, Card = card, ToArea = AreaType.Hands });
                    break;
            }


        }

        /// <summary>
        /// ホイールクリック時の処理
        /// </summary>
        /// <param name="card">カード</param>
        public void ExecWheelClick( CardBox card ) {
            switch(card.Area){
                case AreaType.Hands:
                    SendCommand(new Command { Type = CommandType.Jump, Card = card, ToArea = AreaType.Nodes, Active = true, Location = Nodes.GetEmptyLocation(card) });
                    break;
                case AreaType.Nodes:
                    SendCommand(new Command { Type = CommandType.Change, Card = card, Active = !card.Active, FaceSide = false });
                    break;
                case AreaType.Deck:
                    SendCommand(new Command { Type = CommandType.Jump, ToArea = AreaType.Nodes, Card = card, Active = false, FaceSide = false, Location = Nodes.GetEmptyLocation(card) });
                    break;
                case AreaType.Field:
                    SendCommand(new Command { Type = CommandType.Change, Card = card, Active = !card.Active, FaceSide = card.FaceSide, Transformed = card.Transformed });
                    break;
                case AreaType.Grave:
                    SendCommand(new Command { Type = CommandType.Jump, Card = card, ToArea = AreaType.Field, Active = false, FaceSide = false, Transformed = false });
                    break;
            }

        }

        #endregion

        #region その他のコントロール

        /// <summary>
        /// ツールリンクをクリック
        /// </summary>
        void ToolLink_Click( object sender, EventArgs e ) {
            LinkLabel label = (LinkLabel)sender;
            AreaControl area = (AreaControl)label.Parent;
            if (area.Player.Type != PlayerType.Control && area.Type == AreaType.SideBord) { return; }

            if (area.Type == AreaType.Deck) {
                if (CardListViews.Visible && CardListViews.Area == area.Type) {
                    CardListViews.Visible = false;
                }
                else {
                    DialogResult rs = MessageBox.Show("山札全てを見ますか？", "山札を開く", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                    if (rs != DialogResult.Yes) { return; }
                    CardListViews.ShowCards(area);
                    CardListViews.BringToFront();
                    SendCommand(new Command { Type = CommandType.ViewDeck });
                }
            }
            else {
                if (CardListViews.Visible && CardListViews.Area == area.Type) { CardListViews.Visible = false; }
                else { CardListViews.ShowCards(area); CardListViews.BringToFront(); }
            }
        }

        /// <summary>
        /// リストビューが閉じるとき
        /// </summary>
        void CardListViews_ListClose( object sender, EventArgs e ) {
            CardListView list = (CardListView)sender;
            if (list.Area == AreaType.Deck) {
                SendCommand(new Command { Type = CommandType.UnViewDeck });
                DialogResult rs = MessageBox.Show("山札をシャッフルしますか？", "山札のシャッフル", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
                if (rs == DialogResult.Yes) {
                    if (Type == PlayerType.Network) {
                        Enemy.SendCommand(new Command { Type = CommandType.ShuffleEnemy });
                    }
                    else { SendCommand(new Command { Type = CommandType.Shuffle }); }
                }
            }
        }

        /// <summary>
        /// ライフの変更
        /// </summary>
        void Life_LifeChange( object sender, LifeEventArgs e ) {
            SendCommand(new Command { Type = CommandType.Life, Value = e.Value });
        }

        /// <summary>
        /// スタートボタン
        /// </summary>
        void StartButton_Click( object sender, EventArgs e ) {
            Button bt = (Button)sender;
            switch(bt.Text){
                case "ターン開始":
                    SendCommand(new Command { Type = CommandType.TurnStart });
                    bt.Text = "ターン終了";
                    break;
                case "ターン終了":
                    SendCommand(new Command { Type = CommandType.TurnEnd });
                    bt.Text = "ターン開始";
                    break;
                case "ゲーム開始":
                    SendCommand(new Command { Type = CommandType.GameStart });
                    SendCommand(new Command { Type = CommandType.Shuffle });
                    SendCommand(new Command { Type = CommandType.Draw, Value = 7, Cards = Deck.Cards.GetRange(0, 7), ToArea = AreaType.Hands });
                    bt.Text = "ターン開始";
                    break;
            }

        }

        /// <summary>
        /// カードにホバーしたイベント
        /// </summary>
        public event EventHandler<MessageEventArgs> CardHover;
        protected void OnCardHover( object sender, MessageEventArgs e ) {
            if (CardHover != null) { CardHover(this, e); }
        }
        /// <summary>
        /// カードにホバー
        /// </summary>
        /// <param name="card"></param>
        public void CardHovering(CardBox card) {
            string dtext = "";
            string htext = "";
            if (card != null) {
                switch (card.Area) {
                    case AreaType.Hands:
                        dtext = "プレイする"; htext = "ノードに加える";
                        break;
                    case AreaType.Deck:
                        dtext = "ドローする"; htext = "ノードに加える";
                        break;
                    case AreaType.Nodes:
                        dtext = "コスト支払い"; htext = (!card.Active ? "アクティブ" : "スリープ") + "にする";
                        break;
                    case AreaType.Grave:
                        dtext = "手札に加える"; htext = "裏向きで場に出す";
                        break;
                    case AreaType.Field:
/*                        if (card.FaceSide) {
                            if(card.Info.PlayingType == PlayingType.Equip || card.Info.PlayingType == PlayingType.Amulet){
                            }
                            else if(card.Info.PlayingType == PlayingType.WorldsAmulet || card.Info.PlayingType == PlayingType.FieldsEquip){
                                if(card.Info.Ability.Contains())
                            }
                            else if (card.Info.PlayingType == PlayingType.Character || card.Info.PlayingType == PlayingType.Phantasmal || ) {
                            }
                        }
                        if (card.FaceSide && card.Info.Toughness != "-"
                            || !card.FaceSide && card.BackCardInfo.Type == CardType.Character) {
*/                            if (card.Active) { dtext = ( State == PlayerState.MyTurn ? "攻撃する" : "防御する" ); htext = "スリープにする"; }
                            else { dtext = ""; htext = "アクティブにする"; }
//                        }
                            
                        break;
                }
            }

            string message = dtext.PadRight(6, '　') + "|" + htext.PadRight(8, '　');
            OnCardHover(this, new MessageEventArgs(message));
        }


        #endregion

    }


}