﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace NetVision {

    /// <summary>
    /// ログメッセージに関するイベント引数
    /// </summary>
    public class LogMessageArgs : EventArgs {

        /// <summary>
        /// 表示するメッセージ
        /// </summary>
        public string Message { get; set; }

        /// <summary>
        /// 再生するサウンド
        /// </summary>
        public string Sound { get; set; }

        /// <summary>
        /// フォント
        /// </summary>
        public Font Font { get; set; }

        /// <summary>
        /// 色
        /// </summary>
        public Color Color { get; set; }

        /// <summary>
        /// カード名
        /// </summary>
        public string Card { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="message">表示するメッセージ</param>
        public LogMessageArgs( string message ) {
            Message = message;
        }

        public LogMessageArgs( string message, Color color ) : this(message){
            this.Color = color;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="message">表示するメッセージ</param>
        /// <param name="font">フォント</param>
        /// <param name="sound">サウンド</param>
        public LogMessageArgs( string message, Color color, string sound ) : this(message, color) {
            this.Sound = sound;
        }

    }
}
