﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NetVision {

    /// <summary>
    /// 接続画面ダイアログ
    /// </summary>
    public partial class FormConnect : Form {
        public FormConnect() {
            InitializeComponent();
        }

        /// <summary>
        /// IPアドレス
        /// </summary>
        public string IpAddr { get; set; }

        /// <summary>
        /// ポート番号
        /// </summary>
        public int Port { get; set; }

        /// <summary>
        /// プレイヤー名
        /// </summary>
        public string PlayerName { get; set; }

        /// <summary>
        /// 接続タイプ
        /// </summary>
        public ServerType ConnectionType { get; set; }

        /// <summary>
        /// 親フォーム
        /// </summary>
        private FormMain ParentWindow { get { return (FormMain)ParentForm; } }


        /// <summary>
        /// サーバ側
        /// </summary>
        private void radioButtonHost_CheckedChanged( object sender, EventArgs e ) {
            textBoxIpAddr.Enabled = !radioButtonHost.Checked;
            textBoxClientPort.Enabled = !radioButtonHost.Checked;
            textBoxServerPort.Enabled = radioButtonHost.Checked;
            buttonIpCheck.Enabled = radioButtonHost.Checked;
        }

        /// <summary>
        /// クライアント側
        /// </summary>
        private void radioButtonClient_CheckedChanged( object sender, EventArgs e ) {
            textBoxServerPort.Enabled = !radioButtonClient.Checked;
            textBoxClientPort.Enabled = radioButtonClient.Checked;
            textBoxIpAddr.Enabled = radioButtonClient.Checked;
        }

        /// <summary>
        /// OKボタン
        /// </summary>
        private void buttonOK_Click( object sender, EventArgs e ) {
            int port = 0;
            if (radioButtonHost.Checked) {
                if (!int.TryParse(textBoxServerPort.Text, out port)) { MessageBox.Show("ポート番号が不正です"); return; }
                ConnectionType = ServerType.Server;
            }
            else if (radioButtonClient.Checked) {
                if (!int.TryParse(textBoxClientPort.Text, out port)) { MessageBox.Show("ポート番号が不正です"); return; }
                IpAddr = textBoxIpAddr.Text;
                ConnectionType = ServerType.Client;
            }
            else { return; }

            Port = port;
            PlayerName = textBoxName.Text != "" ? textBoxName.Text : "名無し";

            Close();
        }

        /// <summary>
        /// キャンセルボタン
        /// </summary>
        private void buttonCancel_Click( object sender, EventArgs e ) {
            Close();
        }

        /// <summary>
        /// ダイアログ開くとき
        /// </summary>
        private void FormConnect_Load( object sender, EventArgs e ) {
            
            textBoxName.Text = Properties.Settings.Default.PlayerName;
            textBoxIpAddr.Text = Properties.Settings.Default.IpAddr;
            textBoxClientPort.Text = Properties.Settings.Default.Port.ToString();
            textBoxServerPort.Text = Properties.Settings.Default.Port.ToString();

        }

        /// <summary>
        /// IPアドレスのチェック
        /// </summary>
        private void buttonIpCheck_Click( object sender, EventArgs e ) {
            webBrowserIp.Url = new Uri( Properties.Settings.Default.IpCheckURL );
        }

        


    }
}
