﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace NetVision {
    public partial class FormConfig : Form {
        public FormConfig() {
            InitializeComponent();
        }

        /// <summary>
        /// 画面更新の必要があるか
        /// </summary>
        public bool DisplayChanged { get; set; }

        /// <summary>
        /// ロードイベント
        /// </summary>
        private void FromConfig_Load( object sender, EventArgs e ) {

            textBoxDeckEdit.Text = Properties.Settings.Default.DeckEditerPath;
            textBoxCardImage.Text = Properties.Settings.Default.ImagePath;
            textBoxIpAddr.Text = Properties.Settings.Default.IpCheckURL;
            checkBoxCardLabel.Checked = Properties.Settings.Default.AlwaysCardLabel;
            checkBoxVisualMode.Checked = Properties.Settings.Default.VisualMode;
            checkBoxNodeAssist.Checked = Properties.Settings.Default.NodeAssist;
            checkBoxSound.Checked = Properties.Settings.Default.IsSound;

            checkBoxUseToolTip.Checked = Properties.Settings.Default.UseToolTip;
            checkBoxFadeToolTip.Checked = Properties.Settings.Default.FadeToolTip;
            checkBoxBaloonTip.Checked = Properties.Settings.Default.BaloonTip;

            textBoxChatUseful1.Text = Properties.Settings.Default.ChatUseful1;
            textBoxChatUseful2.Text = Properties.Settings.Default.ChatUseful2;
            textBoxChatUseful3.Text = Properties.Settings.Default.ChatUseful3;

            Size card_size = Properties.Settings.Default.CardSize;
            if(card_size == (Size)radioButtonCardSizeA.Tag){ radioButtonCardSizeA.Checked = true; }
            else if (card_size == (Size)radioButtonCardSizeB.Tag) { radioButtonCardSizeB.Checked = true; }
            else if (card_size == (Size)radioButtonCardSizeC.Tag) { radioButtonCardSizeC.Checked = true; }
            else { radioButtonCardSizeD.Checked = true; numericUpDownCardSizeX.Value = card_size.Width; numericUpDownCardSizeY.Value = card_size.Height; }
            Size win_size = Properties.Settings.Default.WindowSize;
            if (win_size == (Size)radioButtonWinSizeA.Tag) { radioButtonWinSizeA.Checked = true; }
            else if (win_size == (Size)radioButtonWinSizeB.Tag) { radioButtonWinSizeB.Checked = true; }
            else if (win_size == (Size)radioButtonWinSizeC.Tag) { radioButtonWinSizeC.Checked = true; }
            else { radioButtonWinSizeD.Checked = true; numericUpDownWinSizeX.Value = win_size.Width; numericUpDownWinSizeY.Value = win_size.Height; }

            int font_size = Properties.Settings.Default.CardFontSize;
            if (font_size >= (int)radioButtonFontSize3.Tag) { radioButtonFontSize3.Checked = true; }
            else if (font_size >= (int)radioButtonFontSize2.Tag) { radioButtonFontSize2.Checked = true; }
            else{ radioButtonFontSize1.Checked = true; }

            trackBarDouble.Value = ( Properties.Settings.Default.DobleClickInterval - 200 ) / 40;


        }

        /// <summary>
        /// OK
        /// </summary>
        private void buttonOK_Click( object sender, EventArgs e ) {
            Properties.Settings.Default.DeckEditerPath = textBoxDeckEdit.Text;
            Properties.Settings.Default.ImagePath = textBoxCardImage.Text;
            Properties.Settings.Default.IpCheckURL = textBoxIpAddr.Text;
            Properties.Settings.Default.AlwaysCardLabel = checkBoxCardLabel.Checked;
            Properties.Settings.Default.VisualMode = checkBoxVisualMode.Checked;
            Properties.Settings.Default.IsSound = checkBoxSound.Checked;
            Properties.Settings.Default.NodeAssist = checkBoxNodeAssist.Checked;
            Properties.Settings.Default.ChatUseful1 = textBoxChatUseful1.Text;
            Properties.Settings.Default.ChatUseful2 = textBoxChatUseful2.Text;
            Properties.Settings.Default.ChatUseful3 = textBoxChatUseful3.Text;
            Properties.Settings.Default.WindowSize = new Size((int)numericUpDownWinSizeX.Value, (int)numericUpDownWinSizeY.Value);
            Properties.Settings.Default.DobleClickInterval = trackBarDouble.Value * 40 + 200;
            Properties.Settings.Default.FadeToolTip = checkBoxFadeToolTip.Checked;
            Properties.Settings.Default.UseToolTip = checkBoxUseToolTip.Checked;
            Properties.Settings.Default.BaloonTip = checkBoxBaloonTip.Checked;

            Size card_size = new Size((int)numericUpDownCardSizeX.Value, (int)numericUpDownCardSizeY.Value);
            if (card_size != Properties.Settings.Default.CardSize) {
                Properties.Settings.Default.CardSize = card_size;
                DisplayChanged = true;
            }
            if (radioButtonFontSize1.Checked) { Properties.Settings.Default.CardFontSize = (int)radioButtonFontSize1.Tag; }
            if (radioButtonFontSize2.Checked) { Properties.Settings.Default.CardFontSize = (int)radioButtonFontSize2.Tag; }
            if (radioButtonFontSize3.Checked) { Properties.Settings.Default.CardFontSize = (int)radioButtonFontSize3.Tag; }

            Close();
        }

        /// <summary>
        /// デッキエディタ選択
        /// </summary>
        private void buttonDeckEdit_Click( object sender, EventArgs e ) {
            openFileDialogDeckEdit.FileName = textBoxDeckEdit.Text;
            openFileDialogDeckEdit.Filter = "実行ファイル|*.exe|すべてのファイル|*.*";
            if (openFileDialogDeckEdit.ShowDialog() != DialogResult.OK) { return; }
            textBoxDeckEdit.Text = openFileDialogDeckEdit.FileName;
        }

        /// <summary>
        /// カード画像フォルダ選択
        /// </summary>
        private void buttonCardImage_Click( object sender, EventArgs e ) {
            folderBrowserDialogDeck.SelectedPath = textBoxCardImage.Text;
            if (folderBrowserDialogDeck.ShowDialog() != DialogResult.OK) { return; }
            textBoxCardImage.Text = folderBrowserDialogDeck.SelectedPath;
        }


        /// <summary>
        /// キャンセル
        /// </summary>
        private void buttonCancel_Click( object sender, EventArgs e ) {
            Close();
        }

        #region 更新チェック

        /// <summary>
        /// 画面更新を伴う変更
        /// </summary>
        private void display_changed( object sender, EventArgs e ) {
            DisplayChanged = true;
        }

        #endregion

        /// <summary>
        /// カードサイズの変更
        /// </summary>
        private void radioButtonCardSizeA_CheckedChanged( object sender, EventArgs e ) {
            RadioButton radio = (RadioButton)sender;
            if (radio.Checked) {
                Size size = (Size)radio.Tag;
                numericUpDownCardSizeX.Value = size.Width;
                numericUpDownCardSizeY.Value = size.Height;
            }
        }

        /// <summary>
        /// ウインドウサイズの変更
        /// </summary>
        private void radioButtonWinSizeA_CheckedChanged( object sender, EventArgs e ) {
            RadioButton radio = (RadioButton)sender;
            if (radio.Checked) {
                Size size = (Size)radio.Tag;
                numericUpDownWinSizeX.Value = size.Width;
                numericUpDownWinSizeY.Value = size.Height;
            }
        }

        private void checkBoxVisualMode_CheckedChanged( object sender, EventArgs e ) {

        }


    }
}
