﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace NetVision {
    public class FieldControl : AreaControl {

        /// <summary>
        /// プレイされてきた
        /// </summary>
        private bool play_into;

        /// <summary>
        /// カードのプレイ
        /// </summary>
        public void PlayInto(CardBox card) {
            CardInfo info = card.Info;
            play_into = true;
            if (info.Type == CardType.Character || info.Type == CardType.Spell && info.PlayingType == PlayingType.Phantasmal) {
                if (info.Skill.Contains("速攻")) { Add(card, true, true); }
                else { Add(card, false, true); }
            }
            else { Add(card, true, true); }
        }

        /// <summary>
        /// カードを追加
        /// </summary>
        /// <param name="card">場に出すカード</param>
        public override void Add( CardBox card ) {
            card.Area = Type;
            Controls.Add(card);
            PlayingType ptype = card.Info.PlayingType;
            if (!card.FaceSide) { ptype = PlayingType.Reverse; }
            else if (!play_into) { ptype = PlayingType.Character; }
            card.Location = EmptyLocation(ptype); // 配置
            card.VirtualPoint = card.GetVirtualPoint(card.Location, Size);
            card.Public = card.FaceSide;
            card.BackCardInfo = card.Player.BackList["000"];
            Cards.Add(card);
            card.Redraw();
            play_into = false;

            if (ptype == PlayingType.Equip || ptype == PlayingType.Amulet || ptype == PlayingType.Reverse) { card.SendToBack(); }
            else { card.BringToFront(); }
        }

        /// <summary>
        /// アクティブなどを指定してカードを追加
        /// </summary>
        /// <param name="card">場に出すカード</param>
        /// <param name="active">アクティブ状態</param>
        /// <param name="face_side">裏表</param>
        public void Add( CardBox card, bool active, bool face_side ) {
            card.Active = active;
            card.FaceSide = face_side;
            Add(card);
        }


        /// <summary>
        /// カードの退去
        /// </summary>
        /// <param name="card">退去するカード</param>
        public override void Remove( CardBox card ) {
            if (!Cards.Contains(card)) { return; }
            card.BackCardInfo = card.Player.BackList["000"];
            Cards.Remove(card);
            Controls.Remove(card);
        }


        /// <summary>
        /// カードの再描画
        /// </summary>
        public override void RedrawCards() {
            foreach (CardBox card in Cards) {
                card.MoveVirtualPoint(card.VirtualPoint);
            }
        }

        /// <summary>
        /// 開いている場所を探す
        /// </summary>
        /// <param name="playing">プレイングタイプ</param>
        /// <returns>空き地の座標</returns>
        public Point EmptyLocation(PlayingType playing) {
            Size base_size = Properties.Settings.Default.CardSize;
            Size personal = new Size(base_size.Height + 5, base_size.Height + 5);
            Point location = new Point(5, 12); // 余白
            Rectangle rect = new Rectangle();

            // 配置を試みる
            if (playing == PlayingType.Character || playing == PlayingType.Phantasmal || playing == PlayingType.FieldsEquip || playing == PlayingType.WorldsAmulet || playing == PlayingType.Reverse) {
                int i = 0;
                if (playing == PlayingType.WorldsAmulet || playing == PlayingType.FieldsEquip) { i++; } // 世界呪符と装備/場は2段目に
                for (; i < 3; i++) {
                    for (int j = 0; j < 20; j++) {
                        rect = new Rectangle(location.X + personal.Width * j, location.Y + personal.Height * i, personal.Width, personal.Height);
                        if (Player.IsUpSide) { rect = new Rectangle(rect.Left, Height - rect.Top - rect.Height, rect.Width, rect.Height); }
                        if (rect.Right > this.Width - personal.Width) { break; }
                        if (!isCross(rect)) { return rect.Location; } // 空き地発見
                    }
                    if (rect.Top > this.Height) { break; }
                }
                return location; // 空き地はない。諦めよう
            }
            else {
                for (int i = 0; i < 3; i++) {
                    rect = new Rectangle(this.Width - personal.Width, location.Y + personal.Height * i, personal.Width, personal.Height);
                    if (rect.Top > this.Height) { break; }
                    if (!isCross(rect)) { return rect.Location; }
                }
                return new Point(this.Width - personal.Width, location.Y);
            }
        }


        /// <summary>
        /// コントロールの当たり判定
        /// </summary>
        /// <param name="rect">試みる矩形</param>
        /// <returns>空いてるかどうか。重なってたらtrue</returns>
        private bool isCross(Rectangle rect) {
            foreach (CardBox card in Cards) {
                Rectangle rect2 = new Rectangle(card.Location, card.Size);
                if (rect.IntersectsWith(rect2)) { return true; }
            }
            return false;
        }

        /// <summary>
        /// 術者がいるか
        /// </summary>
        /// <param name="name">術者名</param>
        /// <returns>いたらtrue</returns>
        public bool IsCasterExist(string name) {
            foreach (CardBox card in Cards) {
                if (card.NickName.Contains(name)) { return true; }
                if (card.Info.Skill.Contains("Union") && card.Info.Ability.Contains(name)) {
                    return true;
                }
            }
            return false;
        }


    }
}
