﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing;
using System.IO;

namespace NetVision {
    public class CardInfoControl : Panel {


        #region コントロール群

        /// <summary>
        /// カード名
        /// </summary>
        [Category("コントロール")]
        public Label CardName { get; set; }

        /// <summary>
        /// 攻撃力
        /// </summary>
        [Category("コントロール")]
        public Label Attack { get; set; }

        /// <summary>
        /// 耐久
        /// </summary>
        [Category("コントロール")]
        public Label Toughness { get; set; }

        /// <summary>
        /// グレイズ
        /// </summary>
        [Category("コントロール")]
        public Label Glaze { get; set; }

        /// <summary>
        /// ノード
        /// </summary>
        [Category("コントロール")]
        public Label Node { get; set; }


        /// <summary>
        /// コスト
        /// </summary>
        [Category("コントロール")]
        public Label Cost { get; set; }

        /// <summary>
        /// 維持コスト
        /// </summary>
        [Category("コントロール")]
        public Label Upkeep { get; set; }

        /// <summary>
        /// 種族/術者
        /// </summary>
        [Category("コントロール")]
        public Label User { get; set; }

        /// <summary>
        /// 能力
        /// </summary>
        [Category("コントロール")]
        public TextBox Ability { get; set; }

        /// <summary>
        /// スキル
        /// </summary>
        [Category("コントロール")]
        public Label Skill { get; set; }

        /// <summary>
        /// フレーバー
        /// </summary>
        [Category("コントロール")]
        public Label Flavor { get; set; }

        /// <summary>
        /// Glazeラベル
        /// </summary>
        [Category("コントロール")]
        public Label GlazeLabel { get; set; }

        /// <summary>
        /// 維持コストラベル
        /// </summary>
        [Category("コントロール")]
        public Label UpkeepLabel { get; set; }

        /// <summary>
        /// 維持コストラベル
        /// </summary>
        [Category("コントロール")]
        public Label CardId { get; set; }

        /// <summary>
        /// カード画像
        /// </summary>
        [Category("コントロール")]
        public PictureBox CardImage { get; set; }

        /// <summary>
        /// 術者 or 種族
        /// </summary>
        [Category("コントロール")]
        public Label UserOrClass { get; set; }


        /// <summary>
        /// 術者 or 種族
        /// </summary>
        [Category("コントロール")]
        public Label CardTypeName { get; set; }


        #endregion

        #region 表示・非表示

        /// <summary>
        /// カード情報の表示
        /// </summary>
        /// <param name="card">表示するカード</param>
        public void ShowInfo( CardInfo info ) {

            CardName.Text = info.Name;
            CardTypeName.Text = info.Type.ToString();
            CardImage.Image = getImage(info);
            Glaze.Text = info.Glaze;
            CardId.Text = info.No;
            Node.Text = info.Node;
            Cost.Text = info.Cost;
            Skill.Text = info.Skill;
            Upkeep.Text = info.Upkeep;
            UpkeepLabel.Visible = info.Upkeep != "";
            Glaze.Visible = info.Glaze != "-";
            GlazeLabel.Visible = info.Glaze != "-";
            UserOrClass.Text = ( info.Type == CardType.Character ) ? "種族" : ( info.Type == CardType.Spell ) ? "術者" : "";
            User.Text = ( info.Type == CardType.Character ) ? info.Class : info.User;
            Attack.Text = info.Attack;
            Toughness.Text = info.Toughness;
            Ability.Text = info.Ability.Replace(@"\n", "\r\n\r\n");
            Flavor.Text = info.Text.Replace(@"\n", "\n");
            Ability.Font = new System.Drawing.Font("ＭＳ ゴシック", ( info.Ability.Length > 330 ) ? 6 : ( info.Ability.Length > 260 ) ? 7 : ( info.Ability.Length > 210 ) ? 8 : ( info.Ability.Length > 180 ) ? 9 : 10);

            Visible = true;
        }

        /// <summary>
        /// カード情報を隠す
        /// </summary>
        public void HideInfo() {
            Visible = false;
        }


        #endregion

        #region 画像関係

        /// <summary>
        /// 画像の基準フォルダ
        /// </summary>
        public string ImagePath { get; set; }

        /// <summary>
        /// 画像キャッシュ
        /// </summary>
        private Dictionary<string, Image> imageCache = new Dictionary<string, Image>();

        /// <summary>
        /// カード画像を開く
        /// </summary>
        /// <param name="card"></param>
        /// <returns></returns>
        private Image getImage( CardInfo card ) {
            if (!imageCache.ContainsKey(card.No)) {
                if (File.Exists(Application.StartupPath + ImagePath + card.FileName)) {
                    imageCache[card.No] = Image.FromFile(Application.StartupPath + ImagePath + card.FileName);
                }
                else {
                    imageCache[card.No] = null;
                }
            }
            return imageCache[card.No];
        }

        #endregion


        /// <summary>
        /// データのクリア
        /// </summary>
        public void Clear() {
            HideInfo();
            // リソースの解放
            foreach (Image im in imageCache.Values) {
                if (im != null) { im.Dispose(); }
            }
            imageCache.Clear();
            Dispose();
        }

    }
}
