﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace NetVision {

    /// <summary>
    /// カードエリアコントローラ
    /// </summary>
    public abstract class AreaControl : Panel {



        /// <summary>
        /// エリアタイプ
        /// </summary>
        public AreaType Type { get; set; }

        /// <summary>
        /// 呼ばれる名前
        /// </summary>
        public string NickName { get; set; }

        /// <summary>
        /// 所属するプレイヤ
        /// </summary>
        public Player Player { get; set; }

        /// <summary>
        /// 公開領域か
        /// </summary>
        public bool IsPublic { get; set; }

        /// <summary>
        /// カード
        /// </summary>
        public List<CardBox> Cards { get; private set; }

        /// <summary>
        /// カード枚数
        /// </summary>
        /// <returns></returns>
        public int Count {
            get { return Cards.Count; }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public AreaControl() : base() {
            Cards = new List<CardBox>();
        }

        /// <summary>
        /// カードの追加
        /// </summary>
        public abstract void Add( CardBox card );


        /// <summary>
        /// カードの除外
        /// </summary>
        /// <param name="card"></param>
        public abstract void Remove( CardBox card );

        /// <summary>
        /// 手札のインデクサ（読み取り専用）
        /// </summary>
        /// <param name="index">手札のインデックス</param>
        /// <returns>手札</returns>
        public CardBox this[int index] {
            get { return Cards[index]; }
            private set { Cards[index] = value; }
        }

        /// <summary>
        /// カードの整列
        /// </summary>
        public abstract void RedrawCards();

        /// <summary>
        /// データのクリア
        /// </summary>
        public void Clear() {
            Cards.Clear();
            RedrawCards();
        }

        /// <summary>
        /// リンクラベル
        /// </summary>
        public LinkLabel ToolLink { get; set; }

        /// <summary>
        /// キャプションラベル
        /// </summary>
        public Label CaptionLabel { get; set; }

        /// <summary>
        /// 通常の背景
        /// </summary>
        public Image BackImageNormal { get; set; }

        /// <summary>
        /// フォーカスされた背景
        /// </summary>
        public Image BackImageFocused { get; set; }

        private bool m_isfocus = false;
        /// <summary>
        /// フォーカス状態
        /// </summary>
        public bool IsFocus { get { return m_isfocus; } set { m_isfocus = value; Redraw(); }  }

        /// <summary>
        /// 再描画
        /// </summary>
        public void Redraw() {
            if (Properties.Settings.Default.VisualMode) {
                BackColor = Color.Transparent;
                BackgroundImage = IsFocus ? this.BackImageFocused : this.BackImageNormal;
                BorderStyle = BorderStyle.None;
            }
            else {
                BackgroundImage = null;
                BackColor = IsFocus ? Color.Pink : Color.FromKnownColor(KnownColor.Transparent);
//                BackColor = IsFocus ? Color.FromArgb(128, Color.Pink) : Color.FromKnownColor(KnownColor.Transparent);
                //                BackColor = IsFocus ? Color.Pink : Color.FromKnownColor(KnownColor.Control);
                BorderStyle = BorderStyle.FixedSingle;
            }
        }


    
    }
}
