﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NetVision {

    /// <summary>
    /// ライフを表示するカウンタ
    /// </summary>
    public partial class LifeManager : UserControl {
        public LifeManager() {
            InitializeComponent();
            Value = 0;
        }

        private bool m_touchable = false;
        /// <summary>
        /// 操作可能か
        /// </summary>
        public bool Touchable { 
            get { return m_touchable; }
            set {
                buttonMyDamage.Visible = value;
                buttonMyRecover.Visible = value;
                numericUpDownMyLife.Visible = value;
                m_touchable = value;
            }
        }

        /// <summary>
        /// ライフが増えたイベント
        /// </summary>
        public event EventHandler<LifeEventArgs> LifeChange;
        protected virtual void OnLifeChange( LifeEventArgs e ) {
            if (LifeChange != null) { LifeChange(this, e); }
        }

        private int m_life = 0;
        /// <summary>
        /// ライフの現在値
        /// </summary>
        public int Value {
            get { return m_life; }
            set {
                m_life = value;
                labelMyLife.Text = value.ToString();
                if (value >= 25) { labelMyLife.ForeColor = Color.Blue; }
                else if (value > 10) { labelMyLife.ForeColor = Color.Green; }
                else if (value > 5) { labelMyLife.ForeColor = Color.Orange; }
                else if (value <= 0) { labelMyLife.ForeColor = Color.Red; }
            }
        }

        /// <summary>
        /// プラスボタンがクリック
        /// </summary>
        private void buttonMyRecover_Click( object sender, EventArgs e ) {
            Value += (int)numericUpDownMyLife.Value;
            OnLifeChange(new LifeEventArgs((int)numericUpDownMyLife.Value));
            numericUpDownMyLife.Value = 0;
        }

        /// <summary>
        /// マイナスボタンがクリック
        /// </summary>
        private void buttonMyDamage_Click( object sender, EventArgs e ) {
            Value -= (int)numericUpDownMyLife.Value;
            OnLifeChange(new LifeEventArgs(-(int)numericUpDownMyLife.Value));
            numericUpDownMyLife.Value = 0;
        }





    }

    /// <summary>
    /// ライフ増減イベント引数
    /// </summary>
    public class LifeEventArgs : EventArgs {

        /// <summary>
        /// 増減した数値
        /// </summary>
        public int Value { get; set; }

        /// <summary>
        /// ライフ増減イベント引数のコンストラクタ
        /// </summary>
        /// <param name="num">増減した数値</param>
        public LifeEventArgs( int num ) {
            Value = num;
        }
    }


}
