﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace NetVision {

    /// <summary>
    /// デッキコントローラ
    /// </summary>
    public class DeckControl : AreaControl {


        /// <summary>
        /// 山札の一番上を取得/追加
        /// </summary>
        public CardBox First {
            get {
                if (Cards.Count == 0) { return null; }
                return Cards[0];
            }
            set {
                if (value == null) { return; }
                Cards.Insert(0, value);
                value.Area = Type;
                value.Public = false;
                value.Active = true;
                value.FaceSide = false;
                Controls.Add(value);
                value.Location = new Point((Width - Properties.Settings.Default.CardSize.Width) / 2, Player.IsUpSide ? 0 : 11);
                value.Redraw();
                value.Visible = true;
                RedrawCards();
            }
        }

        /// <summary>
        /// 山札の底を取得/追加
        /// </summary>
        public CardBox Last {
            get {
                if (Cards.Count == 0) { return null; }
                return Cards[Cards.Count - 1];
            }
            set {
                if (value == null) { return; }
                Cards.Add(value);
                value.Area = Type;
                value.Active = true;
                value.Public = false;
                value.Visible = true;
                value.FaceSide = false;
                Controls.Add(value);
                value.Location = new Point(( Width - value.Width ) / 2, Player.IsUpSide ? 0 : 11);
                value.Redraw();
                RedrawCards(); 
            }

        }


        /// <summary>
        /// 山札の一番上に追加
        /// </summary>
        /// <param name="card"></param>
        public override void Add( CardBox card ) {
            First = card;
        }


        /// <summary>
        /// カードを山札から取り除く
        /// </summary>
        /// <param name="card"></param>
        public override void Remove( CardBox card ) {
            Cards.Remove(card);
            Controls.Remove(card);
            RedrawCards();
        }

        /// <summary>
        /// 再描画
        /// </summary>
        public override void RedrawCards() {
            if (Count > 0) {
                First.BringToFront();
            }
            CaptionLabel.Text = "山札（" + Count.ToString() + "）";
            CaptionLabel.BringToFront();
            ToolLink.BringToFront();
//            System.Windows.Forms.Application.DoEvents();
        }

        /// <summary>
        /// デッキをシャッフル
        /// </summary>
        public void Shuffle() {
            Random rand = new Random();
            for (int i = 0; i < Cards.Count * 3; i++) {
                int key = rand.Next(Cards.Count);
                CardBox card = Cards[key];
                Cards.RemoveAt(key);
                Cards.Insert(rand.Next(Cards.Count - 1), card);
            }
            RedrawCards();

        }


    }

}
