﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace NetVision {
    public class Cursor : PictureBox {

        /// <summary>
        /// 基準座標
        /// </summary>
        public Point BaseLocation { get; set; }

        /// <summary>
        /// スクリーン上の矩形座標
        /// </summary>
        public Rectangle ScreenRect {
            get { return new Rectangle(PointToScreen(new Point(0, 0)), Size); }
        }

        /// <summary>
        /// 現在いるエリア
        /// </summary>
        public AreaType Area { get; set; }

        /// <summary>
        /// 現在のプレイヤー
        /// </summary>
        public Player Player { get; set; }

        /// <summary>
        /// カードを捉えた
        /// </summary>
        /// <param name="?"></param>
        public void CaptureCard(CardBox card){
            Area = card.Area;
            Size = card.Size;
            Image = card.pictureBox.BackgroundImage;
            Location = Parent.PointToClient(card.PointToScreen(new Point(0, 0)));
            Visible = true;
            BringToFront();
        }

        /// <summary>
        /// カードを手放した
        /// </summary>
        public void ReleseCard(CardBox card) {
        }


    }
}
