#include "pch.hpp"
#include "DlgCommon.hpp"
#include "ScoreLineQIBFilterDlg.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

TCHAR  g_fltP2Name[SWRS_ADDR_PROFSIZE + 1];
time_t g_fltDateBegin;
time_t g_fltDateEnd;

bool   g_fltP2NameEnabled;
bool   g_fltP2NameLikeEnabled;
bool   g_fltDateBeginEnabled;
bool   g_fltDateEndEnabled;

static BOOL ScoreLineQIBFilterDlg_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	::SendDlgItemMessage(hDlg, IDC_EDIT_P2NAME, EM_SETLIMITTEXT, 16, 0);
	return TRUE;
}

static void ScoreLineQIBFilterDlg_OnOK(HWND hDlg)
{
	SYSTEMTIME sysTime;

	g_fltP2NameEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_fltP2NameLikeEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME_LIKE, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_fltDateBeginEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_DATEBEG, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_fltDateEndEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_DATEEND, BM_GETCHECK, 0, 0) == BST_CHECKED);
	
	if (g_fltDateBeginEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEBEG, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour =
		sysTime.wMinute =
		sysTime.wSecond =
		sysTime.wMilliseconds = 0;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_fltDateBegin);
	}

	if (g_fltDateEndEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEEND, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour = 23;
		sysTime.wMinute = 59;
		sysTime.wSecond = 59;
		sysTime.wMilliseconds = 999;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_fltDateEnd);

		if (g_fltDateBeginEnabled && g_fltDateBegin > g_fltDateEnd) {
			::MessageBox(hDlg, _T("n_͏I_OɂĂ"), NULL, MB_OK | MB_ICONEXCLAMATION);
			return;
		}
	}

	if (g_fltP2NameEnabled) {
		::GetDlgItemText(hDlg, IDC_EDIT_P2NAME, g_fltP2Name, SWRS_ADDR_PROFSIZE);
	}

	::EndDialog(hDlg, IDOK);
}

static void ScoreLineQIBFilterDlg_OnCancel(HWND hDlg)
{
	::EndDialog(hDlg, IDCANCEL);
}

static void ScoreLineQIBFilterDlg_OnCheckP2Name(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_P2NAME,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_EDIT_P2NAME), oldState == BST_UNCHECKED);
	::EnableWindow(GetDlgItem(hDlg, IDC_CHECK_P2NAME_LIKE), oldState == BST_UNCHECKED);
}

static void ScoreLineQIBFilterDlg_OnCheckDateBegin(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_DATEBEG, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_DATEBEG,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_DTP_DATEBEG), oldState == BST_UNCHECKED);
}

static void ScoreLineQIBFilterDlg_OnCheckDateEnd(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_DATEEND, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_DATEEND,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_DTP_DATEEND), oldState == BST_UNCHECKED);
}

static void ScoreLineQIBFilterDlg_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id) {
	case IDOK: ScoreLineQIBFilterDlg_OnOK(hDlg); break;
	case IDCANCEL: ScoreLineQIBFilterDlg_OnCancel(hDlg); break;
	case IDC_CHECK_P2NAME: ScoreLineQIBFilterDlg_OnCheckP2Name(hDlg); break;
	case IDC_CHECK_DATEBEG: ScoreLineQIBFilterDlg_OnCheckDateBegin(hDlg); break;
	case IDC_CHECK_DATEEND: ScoreLineQIBFilterDlg_OnCheckDateEnd(hDlg); break;
	}
}

BOOL CALLBACK ScoreLineQIBFilterDlg_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, ScoreLineQIBFilterDlg_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, ScoreLineQIBFilterDlg_OnCommand);
	}
	return FALSE;
}
