#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define ColNum 5						// 1R[h̗vf(JnAhXAs[gJnoffsetAI_offsetAt@CATvO[g)
#define WavFileNameLen 256				// őt@C
#define BgmTableRecordLen (256 + 45)	// e[ut@C̍s̍ő咷
#define BgmFileName "thbgm.dat"			// ƂȂBGMt@C
#define BgmTable "thbgm.tbl"			// e[ut@C

typedef struct _thbgm {
	unsigned int bgmtable[3];
	char name[WavFileNameLen];
	int smplrate;
} THBGM;

char *trim(char *);
char *fgetcsv(char [][BgmTableRecordLen], int, FILE *, char *);
int readtable(THBGM **);
void makeheader(char *, int, int);

int main(int argc, char *argv[]) {
	FILE *datf, *bgmf;
	int i, j, k, l;
	int rep = 2;
	int length;
	int fade = 0;
	int fadep = 0;
	int ts = 0;
	int te;
	char header[44];
	short buf[44100 * 2];
	int s, e;
	double d;
	THBGM *thbgm = NULL;
	int lastTrack;
	
	te = lastTrack = readtable(&thbgm);
	
	// bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	// ꂼʒuɊZ
	for (i = 0; i < lastTrack; i++) {
		(thbgm + i)->bgmtable[1] += (thbgm + i)->bgmtable[0];
		(thbgm + i)->bgmtable[2] += (thbgm + i)->bgmtable[0];
	}
	
	// argc̃`FbN
	for (i = 1; i < argc; i++) {
		switch (argv[i][0]) {
		case 'f':
			argv[i]++;
			fade = atoi(argv[i]);
			break;
		case 'F':
			argv[i]++;
			fade = -atoi(argv[i]);
			break;
		case 'P':
		case 'p':
			argv[i]++;
			fadep = atoi(argv[i]);
			break;
		case 'T':
		case 't':
			argv[i]++;
			ts = te = atoi(argv[i]);
			break;
		default:
			rep = atoi(argv[i]);
		}
	}
	
	if (rep < 1 || rep > 10) {
		printf("repeat must be 1-10\n");
		exit(EXIT_FAILURE);
	}
	if (fade < -30 || fade > 30) {
		printf("fade must be 0-30\n");
		exit(EXIT_FAILURE);
	}
	if (fadep < 0 || fadep > 3) {
		printf("fade pattern must be 0-3\n");
		exit(EXIT_FAILURE);
	}
	if (ts < 0 || te > lastTrack) {
		printf("track number must be 1-%d\n", lastTrack);
		exit(EXIT_FAILURE);
	}
	
	if (ts) {
		ts--;
	}
	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n", ts + 1, te, rep, fade, fadep);
	
	datf = fopen(BgmFileName, "rb");
	if (datf == NULL) {
		printf("%s was not opened.", BgmFileName);
		exit(EXIT_FAILURE);
	}
	
	// Jn
	for (i = ts; i < te; i++) {
		printf("Create %s ...\n", (thbgm + i)->name);
		bgmf = fopen((thbgm + i)->name, "wb");
		if (bgmf == NULL) {
			printf("%s was not opened.", (thbgm + i)->name);
			exit(EXIT_FAILURE);
		}
		length = ((thbgm + i)->bgmtable[2] - (thbgm + i)->bgmtable[0]) + ((thbgm + i)->bgmtable[2] - (thbgm + i)->bgmtable[1]) * (rep-1);
		if (fade < 0) {
			length += (-fade) * (thbgm + i)->smplrate * 4;
		}
		makeheader(header, length, (thbgm + i)->smplrate);
		fwrite(header, 1,44, bgmf);
		
		// [v
		for (k = 0; k < rep; k++) {
			// [
			s = (thbgm + i)->bgmtable[1];
			if (k == 0) {
				s = (thbgm + i)->bgmtable[0];
			}
			
			// I[
			e = (thbgm + i)->bgmtable[2];
			if (k == rep-1 && fade > 0) {
				e = (thbgm + i)->bgmtable[2] - fade * (thbgm + i)->smplrate * 4;
			}
			
			for (j = s; j < e; j += (thbgm + i)->smplrate * 4) {
				if (j + (thbgm + i)->smplrate * 4 > e) {
					l = e - j;
				} else {
					l = (thbgm + i)->smplrate * 4;
				}
				
				fseek(datf, j, SEEK_SET);
				fread(buf, 1, l, datf);
				fwrite(buf, 1, l, bgmf);
			}
		}
		
		// tF[hAEg
		if (fade > 0) {
			// [vI[
			s = (thbgm + i)->bgmtable[2] - fade * (thbgm + i)->smplrate * 4;
			e = (thbgm + i)->bgmtable[2];
		} else if (fade < 0) {
			// [v[
			s = (thbgm + i)->bgmtable[1];
			e = s - fade * (thbgm + i)->smplrate * 4;
		} else {
			s = e = 0;
		}
			
		for (j = s; j < e; j += (thbgm + i)->smplrate * 4) {
			if (j + (thbgm + i)->smplrate * 4 > e) {
				l = e - j;
			} else {
				l = (thbgm + i)->smplrate * 4;
			}
			
			fseek(datf, j, SEEK_SET);
			fread(buf, 1, l, datf);
			for (k = 0; k < l / 4; k++) {
				switch (fadep) {
				case 0:
					d = (float)((j - s) / 4 + k) / (abs(fade) * (thbgm + i)->smplrate);
					d = pow(0.001, d);
					break;
				case 1:
					d = 1 - (float)((j - s) / 4 + k) / (abs(fade) * (thbgm + i)->smplrate);
					break;
				case 2:
					d = (float)((j - s) / 4 + k) / (abs(fade) * (thbgm + i)->smplrate);
					d = (pow(0.001, d) + (1 - d)) / 2;
					break;
				case 3:
					d = (cos(3.1415926535 * (float)((j - s) / 4 + k) / (abs(fade) * (thbgm + i)->smplrate)) + 1) / 2;
					break;
				}
				
				buf[2 * k] = (short)(buf[2 * k] * d);
				buf[2 * k + 1] = (short)(buf[2 * k + 1] * d);
			}
			fwrite(buf, 1, l, bgmf);
		}
		
		fclose(bgmf);
	}
	fclose(datf);
	
	free(thbgm);
	
	return 0;
}

// ֐: trim
// @\: ̐擪іɂzCgXy[X菜
// : 
//		s:	`O̕ւ̃|C^
// ߂l: 
//		펞:		`̕ւ̃|C^
//		NULL:	NULL
char *trim(char *s) {
	int i;
	int len;
	char *str;
	
	// |C^͏I
	if (s == NULL) {
		return NULL;
	}
	
	// 񒷂擾
	len = strlen(s);
	
	// ̂߂̃m
	str = (char *)malloc(len + 1);
	if (str == NULL) {
		printf("memory allocate error!!\n");
		exit(EXIT_FAILURE);
	}
	
	// ̃Rs[
	strncpy(str, s, len);
	str[len] = '\0';
	
	// 珇ɋ󔒂łȂʒuT
	for (i = strlen(str) - 1; i >= 0; i--) {
		switch (str[i]) {
		case ' ':
		case '\t':
		case '\v':
		case '\n':
		case '\r':
			str[i] = '\0';
			break;
		default:
			goto NOBLANKTOP;
		}
	}
  NOBLANKTOP:
	
	// 擪珇ɋ󔒂łȂʒuT
	len = strlen(str);
	for (i = 0; i <= len - 1; i++) {
		switch (str[i]) {
		case ' ':
		case '\t':
		case '\v':
		case '\n':
		case '\r':
			break;
		default:
			goto NOBLANKBOTTOM;
		}
	}
  NOBLANKBOTTOM:

	// ̃Rs[
	strncpy(s, &str[i], len - i + 1);
	
	free(str);
	
	return s;
}

// ֐: fgetcsv
// @\: t@C|C^sǂݍ݁ACSVtB[h
// : 
//		string:		CSṼf[^i[z
//		length:		t@CxɎ擾oCgA(sl)CSVt@C̍Œ̍s傫Kv
//		handle:		I[vς݂̃t@C|C^
//		delimiter:	tB[h̋؂蕶ւ̃|C^
// ߂l: 
//		펞:		CSV̔zւ̃|C^
//		NULL:	NULL
char *fgetcsv(char string[][BgmTableRecordLen], int length, FILE *handle, char *delimiter) {
	int i;
	char *str;
	char *p;
	
	// |C^͏I
	if (string == NULL || handle == NULL || delimiter == NULL) {
		return NULL;
	}
	
	// ̂߂̃m
	str = (char *)malloc(length);
	if (str == NULL) {
		printf("memory allocate error!!\n");
		exit(EXIT_FAILURE);
	}
	
	// sǂݍ
	if (fgets(str, length, handle) != NULL) {
		// sȂ̓G[
		if (strchr(str, '\n') == NULL) {
			printf("table format error!!\n");
			exit(EXIT_FAILURE);
		}
		
		// CSV
		p = strtok(str, delimiter);
		if (p != NULL) {
			strcpy(string[0], p);
		} else {
			free(str);
			return NULL;
		}
		for (i = 1; i < ColNum; i++) {
			p = strtok(NULL, delimiter);
			if (p != NULL) {
				strcpy(string[i], p);
			} else {
				string[i][0] = '\0';
			}
		}
		
		free(str);
		
		return string[0];
	} else {
		free(str);
		
		return NULL;
	}
}

// ֐: readtable
// @\: BGMf[^̃e[ut@Cǂݍݍ쐬
// : 
//		thbgmpt:	e[uf[^ւ̃|C^
// ߂l: R[h(słȐ)
int readtable(THBGM **thbgmpt) {
	int i;
	int cnt;
	int smpl;
	FILE *fp;
	char s[BgmTableRecordLen];
	char buf[ColNum][BgmTableRecordLen];
	char *e;
	char *token = ",";
	THBGM *thbgm = NULL;
	memset(s, 0, sizeof(s));
	
	// t@CI[v
	if ((fp = fopen(BgmTable, "r")) == NULL) {
		printf("file open error!!\n");
		exit(EXIT_FAILURE);
	}
	
	// sǂݍ
	for (cnt = 0; fgetcsv(buf, BgmTableRecordLen, fp, token) != NULL; cnt++) {
		// m
		thbgm = (THBGM *)realloc(thbgm, sizeof(THBGM) * (cnt + 1));
		if (thbgm == NULL) {
			printf("memory allocate error!!\n");
			exit(EXIT_FAILURE);
		}
		
		// `č\̂Ɋi[
		for (i = 0; i < ColNum; i++) {
			trim(buf[i]);
			switch (i) {
			case 0:
			case 1:
			case 2:
				(thbgm + cnt)->bgmtable[i] = strtol(buf[i], &e, 0);
				break;
			case 3:
				strcpy((thbgm + cnt)->name, buf[i]);
				break;
			case 4:
				smpl = strtol(buf[i], &e, 0);
				switch (smpl) {
				case 22050:
				case 44100:
					(thbgm + cnt)->smplrate = smpl;
					break;
				default:
					(thbgm + cnt)->smplrate = 44100;
					break;
				}
				break;
			default:
				printf("fatal error!!\n");
				exit(EXIT_FAILURE);
			}
		}
	}
	
	fclose(fp);
	
	*thbgmpt = thbgm;
	
	return cnt;
}

// ֐: makeheader
// @\: RIFF`WAVt@Cwb_쐬
// : 
//		header:		wb_i[ւ̃|C^
//		datasize:	g`f[^̃oCg
//		srate:		TvO[g
// ߂l: Ȃ
void makeheader(char *header, int datasize, int srate) {
	int i;
	short s;
	memcpy(header, "RIFF", 4);
	i = datasize + 36;
	memcpy(header + 4, &i, 4);
	memcpy(header + 8, "WAVEfmt ", 8);
	i = 16;
	memcpy(header + 16, &i, 4);
	s = 1;
	memcpy(header + 20, &s, 2);
	s = 2;
	memcpy(header + 22, &s, 2);
	i = srate;
	memcpy(header + 24, &i, 4);
	i = srate * 2 * 2;
	memcpy(header + 28, &i, 4);
	s = 4;
	memcpy(header + 32, &s, 2);
	s = 16;
	memcpy(header + 34, &s, 2);
	memcpy(header + 36, "data", 4);
	i = datasize;
	memcpy(header + 40, &i, 4);
}

