/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Application;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.dip.th075altlobby.imo.Application.ConnectedUsers;
import jp.dip.th075altlobby.imo.Application.Data.MemoryStoredInstantMessage;
import jp.dip.th075altlobby.imo.Application.Data.StoredInstantMessage;
import jp.dip.th075altlobby.imo.Application.Settings.ServerSettings;
import jp.dip.th075altlobby.imo.Data.IPConverter.IPConverter;
import jp.dip.th075altlobby.imo.Data.communication.AbstractInputThread;
import jp.dip.th075altlobby.imo.Data.communication.AbstractOutputThread;
import jp.dip.th075altlobby.imo.Data.communication.ClientInfo;
import jp.dip.th075altlobby.imo.Data.communication.ClientToClientCommand;
import jp.dip.th075altlobby.imo.Data.communication.DataSplitter;
import jp.dip.th075altlobby.imo.Data.communication.DataWrapper;
import jp.dip.th075altlobby.imo.Data.communication.InstantMessage;
import jp.dip.th075altlobby.imo.Data.communication.UserInfo;
import jp.dip.th075altlobby.imo.Data.communication.WrappedData;
import jp.dip.th075altlobby.imo.Exception.InvalidDataLengthException;
import jp.dip.th075altlobby.imo.security.Encrypter;

public class LobbyServerMain {
    private static final Logger logger = Logger.getLogger("jp.dip.th075altlobby.imo.Application");
    private static final short PROTOCOL_VERSION = 2;
    private static final short SERVER_VERSION = 2;
    private static final String publicIMUID = "f1d3ff8443297732862df21dc4e57262";
    private ServerSocket s1 = null;
    private ServerSocket s2 = null;
    private ConnectedUsers users = new ConnectedUsers();
    private final StoredInstantMessage storedIM;
    private final ServerSettings settings = new ServerSettings();

    public LobbyServerMain() {
        this.storedIM = new MemoryStoredInstantMessage(this.settings.getInstantMessageStoreLimit());
    }

    private void loadInstantMessages() {
        try {
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(new File(this.settings.getInstantMessagesPath())));
            ArrayDeque q = (ArrayDeque)in.readObject();
            for (InstantMessage m : q) {
                this.storedIM.add(m);
            }
            logger.info("\u4fdd\u7ba1\u3055\u308c\u305fIM\u3092\u5fa9\u5143\u3057\u307e\u3057\u305f\u3002");
        }
        catch (IOException e) {
            logger.info("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081IM\u306e\u8aad\u307f\u53d6\u308a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
        catch (ClassNotFoundException e) {
            logger.info("Class\u304c\u898b\u3064\u304b\u3089\u306a\u304b\u3063\u305f\u305f\u3081\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public static void main(String[] args) {
        LobbyServerMain prog = new LobbyServerMain();
        prog.run();
    }

    private void run() {
        ExecutorService exs;
        block6: {
            this.printSettingValues();
            this.loadInstantMessages();
            exs = Executors.newCachedThreadPool();
            try {
                int server_port = this.settings.getSeverPort();
                int server_max_connection = this.settings.getMaxConnection();
                int server_command_port = this.settings.getServerCommandPort();
                this.s1 = new ServerSocket(server_port, server_max_connection);
                this.s2 = new ServerSocket(server_command_port, 24);
                exs.submit(new ServerThread(this.s1));
                exs.submit(new ServerCommandThread(this.s2));
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "\u30b5\u30fc\u30d0\u30fc\u30bd\u30b1\u30c3\u30c8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u304a\u305d\u3089\u304f\u65e2\u306b\u30dd\u30fc\u30c8\u304c\u4f7f\u7528\u3055\u308c\u3066\u3044\u307e\u3059\u3002", e);
                if (this.s1 == null) break block6;
                try {
                    this.s1.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "\u30bd\u30b1\u30c3\u30c8\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
        try {
            exs.shutdown();
            exs.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            logger.log(Level.INFO, "\u7d42\u4e86\u30d6\u30ed\u30c3\u30af\u304c\u30a4\u30f3\u30bf\u30e9\u30d7\u30c8\u3055\u308c\u307e\u3057\u305f\u3002");
        }
        System.out.println("\u30b5\u30fc\u30d0\u30fc\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
    }

    private void printSettingValues() {
        StringBuffer settingValues = new StringBuffer();
        settingValues.append("\r\nWaiting Port:" + this.settings.getSeverPort() + "\r\n" + "Client MaxConnection:" + this.settings.getClientMaxConnection() + "\r\n" + "InstantMessage StoreLimit:" + this.settings.getInstantMessageStoreLimit());
        if (!this.settings.getFromAddress().equals(this.settings.getToAddress())) {
            settingValues.append("\r\nAT:" + this.settings.getFromAddress() + "->" + this.settings.getToAddress());
        }
        settingValues.append("\r\nIMPath:" + this.settings.getInstantMessagesPath());
        logger.info(settingValues.toString());
    }

    private void shutdown() {
        WrappedData[] dataArray = new WrappedData[]{new WrappedData((byte)66, new byte[0]), new WrappedData((byte)0, new byte[0])};
        this.putWrappedDataForAllConnectedUsers(dataArray);
        try {
            this.s1.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "\u30bd\u30b1\u30c3\u30c8\u3092\u9589\u3058\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
        }
        try {
            this.s2.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "\u30bd\u30b1\u30c3\u30c8\u3092\u9589\u3058\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
        }
    }

    private void storeInstantMessages() {
        ArrayDeque<InstantMessage> q = new ArrayDeque<InstantMessage>(this.storedIM.getStoredIMClone());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.settings.getInstantMessagesPath()))));
            oos.writeObject(q);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            logger.info("IO\u4f8b\u5916\u304c\u767a\u751f\u3057\u305f\u305f\u3081IM\u306e\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWrappedDataForUser(String UID, WrappedData data) {
        ConnectedUsers connectedUsers = this.users;
        synchronized (connectedUsers) {
            ClientInfo current;
            Map<Socket, ClientInfo> usersClone = this.users.getConnectedUsersClone();
            ArrayDeque<ClientInfo> userinfos = new ArrayDeque<ClientInfo>(usersClone.values());
            while ((current = userinfos.poll()) != null) {
                UserInfo uinfo = current.getUserInfo();
                if (uinfo == null || !uinfo.getUID().equals(UID)) continue;
                System.out.println(uinfo.getUID());
                AbstractOutputThread out = current.getOutputThread();
                out.put(data);
                break;
            }
        }
    }

    private void putWrappedDataForAllConnectedUsers(WrappedData data) {
        WrappedData[] dataArray = new WrappedData[]{data};
        this.putWrappedDataForAllConnectedUsers(dataArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWrappedDataForAllConnectedUsers(WrappedData[] dataArray) {
        ConnectedUsers connectedUsers = this.users;
        synchronized (connectedUsers) {
            Map<Socket, ClientInfo> usersMap = this.users.getConnectedUsersClone();
            for (ClientInfo info : usersMap.values()) {
                AbstractOutputThread out = info.getOutputThread();
                int i = 0;
                while (i < dataArray.length) {
                    WrappedData data = dataArray[i];
                    if (data != null) {
                        out.put(data);
                    }
                    ++i;
                }
            }
        }
    }

    class ServerCommandThread
    implements Runnable {
        private final ServerSocket sSock;

        public ServerCommandThread(ServerSocket sock) {
            this.sSock = sock;
        }

        @Override
        public void run() {
            ExecutorService exs = Executors.newCachedThreadPool();
            try {
                while (true) {
                    Socket s = this.sSock.accept();
                    exs.submit(new CommandThread(s));
                }
            }
            catch (IOException e) {
                logger.log(Level.INFO, "\u5165\u51fa\u529b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                exs.shutdown();
                return;
            }
        }

        class CommandThread
        implements Runnable {
            private final Socket s;

            public CommandThread(Socket s) {
                this.s = s;
            }

            @Override
            public void run() {
                try {
                    InputStream in = this.s.getInputStream();
                    int command = in.read();
                    switch (command) {
                        case 0: {
                            logger.log(Level.INFO, "\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u30b7\u30b0\u30ca\u30eb\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002");
                            LobbyServerMain.this.shutdown();
                            break;
                        }
                        case 1: {
                            logger.log(Level.INFO, "IM\u4fdd\u5b58\u30b7\u30b0\u30ca\u30eb\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002");
                            LobbyServerMain.this.storeInstantMessages();
                        }
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "\u5165\u51fa\u529b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                }
            }
        }
    }

    class ServerThread
    implements Runnable {
        private final ServerSocket sSock;

        public ServerThread(ServerSocket sock) {
            this.sSock = sock;
        }

        @Override
        public void run() {
            System.out.println("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u63a5\u7d9a\u3092\u5f85\u3061\u307e\u3059\u3002");
            while (true) {
                Socket s;
                try {
                    s = this.sSock.accept();
                }
                catch (IOException e) {
                    logger.info("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u5f85\u3061\u30eb\u30fc\u30d7\u3067IO\u4f8b\u5916\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002");
                    break;
                }
                if (LobbyServerMain.this.users.getConnectionCounter(s) < LobbyServerMain.this.settings.getClientMaxConnection()) {
                    try {
                        logger.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u3092\u958b\u304d\u307e\u3059\u3002[" + IPConverter.toString(s.getInetAddress().getAddress()) + "]");
                        this.Connect(s);
                    }
                    catch (IOException e) {
                        logger.log(Level.INFO, "IO\u4f8b\u5916\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", e);
                        try {
                            s.close();
                        }
                        catch (IOException ex) {
                            logger.log(Level.WARNING, "\u30bd\u30b1\u30c3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", ex);
                        }
                    }
                    continue;
                }
                logger.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6570\u5236\u9650\u306b\u3088\u308a\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u304c\u5207\u65ad\u3055\u308c\u307e\u3057\u305f\u3002[" + IPConverter.toString(s.getInetAddress().getAddress()) + "]");
                try {
                    s.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "\u30bd\u30b1\u30c3\u30c8\u3092\u30af\u30ed\u30fc\u30ba\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e);
                }
            }
        }

        private void Connect(Socket s) throws IOException {
            ExecutorService exs = Executors.newCachedThreadPool();
            exs.execute(new IOThread(s));
            exs.shutdown();
        }

        class IOThread
        implements Runnable {
            private final Socket sock;
            private final AbstractInputThread inThread;
            private final AbstractOutputThread outThread;

            public IOThread(Socket s) throws IOException {
                OutputThread out = new OutputThread(s.getOutputStream());
                InputThread in = new InputThread(s, s.getInputStream(), out);
                LobbyServerMain.this.users.put(s, in, out);
                this.sock = s;
                this.inThread = in;
                this.outThread = out;
            }

            @Override
            public void run() {
                ExecutorService exs = Executors.newCachedThreadPool();
                exs.submit(this.inThread);
                exs.submit(this.outThread);
                exs.shutdown();
                try {
                    exs.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    this.sock.close();
                }
                catch (IOException e) {
                    logger.warning("Socket\u3092\u9589\u3058\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                }
                System.out.println("IOThread\u3092\u7d42\u4e86\u3055\u305b\u307e\u3059\u3002");
            }

            class InputThread
            extends AbstractInputThread {
                private boolean exitFlag;
                private final String cachedUID;

                public InputThread(Socket s, InputStream in, AbstractOutputThread out) {
                    super(s, in, out);
                    this.exitFlag = false;
                    this.cachedUID = Encrypter.getHash(this.getIPByteArray(), "MD5");
                    System.out.println(this.cachedUID);
                }

                private byte[] getIPByteArray() {
                    Socket s = this.getSocket();
                    byte[] address = s.getInetAddress().getAddress();
                    if (IPConverter.toString(address).equals(LobbyServerMain.this.settings.getFromAddress())) {
                        String addressString = LobbyServerMain.this.settings.getToAddress();
                        String[] splited = addressString.split("\\.");
                        address[0] = (byte)Integer.parseInt(splited[0]);
                        address[1] = (byte)Integer.parseInt(splited[1]);
                        address[2] = (byte)Integer.parseInt(splited[2]);
                        address[3] = (byte)Integer.parseInt(splited[3]);
                    }
                    return address;
                }

                @Override
                public void run() {
                    try {
                        do {
                            WrappedData data = this.getDataIn().recieve();
                            this.consume(data);
                        } while (!this.exitFlag);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "InputThread\u3067IO\u4f8b\u5916\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", e);
                        if (e instanceof InvalidDataLengthException) {
                            try {
                                IOThread.this.sock.close();
                            }
                            catch (IOException e1) {
                                logger.warning("Socket\u304c\u9589\u3058\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                            }
                        }
                        try {
                            this.bye();
                        }
                        catch (IOException e1) {
                            logger.log(Level.SEVERE, "\u30b9\u30c8\u30ea\u30fc\u30e0\u3092\u9589\u3058\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002", e1);
                        }
                    }
                    System.out.println("InputThread\u3092\u7d42\u4e86\u3055\u305b\u307e\u3059\u3002");
                }

                private void consume(WrappedData data) throws IOException {
                    Byte command = data.getCommand();
                    byte[] rawData = data.getRawData();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String dateString = "[" + sdf.format(new Date()) + "]";
                    String ipString = IPConverter.toString(this.getIPByteArray());
                    System.out.print(String.valueOf(dateString) + " " + ipString + ":");
                    switch (command) {
                        case 1: {
                            System.out.println("Recieved checkVersion Signal.");
                            this.checkVersion();
                            break;
                        }
                        case 2: {
                            System.out.println("Recieved newConnect Signal.");
                            this.newConnect(rawData);
                            break;
                        }
                        case 4: {
                            System.out.println("Recieved requestUserlist Signal.");
                            this.requestUserlist();
                            break;
                        }
                        case 5: {
                            System.out.println("Recieved State Modified Signal.");
                            this.modifyUserState(rawData);
                            break;
                        }
                        case 6: {
                            System.out.println("Recieved Post InstantMessage Signal.");
                            this.postInstantMessage(rawData);
                            break;
                        }
                        case 7: {
                            System.out.println("Recieved requestStoredInstantMessage Signal.");
                            this.requestStoredInstantMessage(rawData);
                            break;
                        }
                        case 8: {
                            System.out.println("Recieved postClientToClientCommand Signal.");
                            this.forwardClientToClientCommand(rawData);
                            break;
                        }
                        case 3: {
                            System.out.println("Reieved bye Signal.");
                            this.bye();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void forwardClientToClientCommand(byte[] rawData) throws IOException {
                    ClientToClientCommand ccc = DataSplitter.toPostedClientToClientCommand(rawData, this.getCachedUID());
                    byte[] b = DataWrapper.wrapClientToClientCommand(ccc);
                    InputThread inputThread = this;
                    synchronized (inputThread) {
                        LobbyServerMain.this.putWrappedDataForUser(ccc.getToUID(), new WrappedData((byte)84, b));
                    }
                }

                private void requestStoredInstantMessage(byte[] rawData) throws IOException {
                    byte requestLimit = DataSplitter.toByte(rawData);
                    Queue<InstantMessage> storedIMClone = LobbyServerMain.this.storedIM.getStoredIMClone();
                    byte[] r_rawData = null;
                    if (storedIMClone.size() == 0) {
                        r_rawData = DataWrapper.wrapResponseStoredInstantMessages((byte)3, null);
                    } else if (requestLimit <= 0) {
                        r_rawData = DataWrapper.wrapResponseStoredInstantMessages((byte)2, null);
                    } else {
                        if (requestLimit < storedIMClone.size()) {
                            int removeC = storedIMClone.size() - requestLimit;
                            int i = 0;
                            while (i < removeC) {
                                storedIMClone.remove();
                                ++i;
                            }
                        }
                        r_rawData = DataWrapper.wrapResponseStoredInstantMessages((byte)1, storedIMClone);
                    }
                    WrappedData data = new WrappedData((byte)70, r_rawData);
                    this.getOutputThread().put(data);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void postInstantMessage(byte[] rawData) throws IOException {
                    String UID = this.getCachedUID();
                    InstantMessage postedIM = DataSplitter.toPostedInstantMessage(rawData, UID);
                    boolean isWhole = false;
                    String toName = null;
                    String fromName = null;
                    if (postedIM.getTo().equals(LobbyServerMain.publicIMUID)) {
                        toName = "all";
                        isWhole = true;
                    }
                    Collection<ClientInfo> usersList = LobbyServerMain.this.users.getConnectedUsersClone().values();
                    for (ClientInfo cinfo : usersList) {
                        UserInfo uinfo = cinfo.getUserInfo();
                        if (uinfo == null) continue;
                        if (uinfo.getUID().equals(postedIM.getTo())) {
                            toName = String.valueOf(uinfo.getPublicName()) + "@" + uinfo.getUID().substring(0, 3);
                            if (fromName != null) break;
                        }
                        if (!uinfo.getUID().equals(postedIM.getFrom())) continue;
                        fromName = String.valueOf(uinfo.getPublicName()) + "@" + uinfo.getUID().substring(0, 3);
                        if (isWhole || toName != null) break;
                    }
                    if (fromName != null) {
                        if (toName == null) {
                            toName = "*";
                        }
                        InstantMessage dIM = new InstantMessage(fromName, toName, postedIM.getMessage(), postedIM.getTime(), postedIM.getColor());
                        WrappedData data = new WrappedData((byte)83, DataWrapper.wrapDistributedIM(dIM));
                        InputThread inputThread = this;
                        synchronized (inputThread) {
                            if (postedIM.getTo().equals(LobbyServerMain.publicIMUID)) {
                                LobbyServerMain.this.putWrappedDataForAllConnectedUsers(data);
                                LobbyServerMain.this.storedIM.add(dIM);
                            } else {
                                this.getOutputThread().put(data);
                                if (!postedIM.getTo().equals(this.getCachedUID())) {
                                    LobbyServerMain.this.putWrappedDataForUser(postedIM.getTo(), data);
                                }
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void modifyUserState(byte[] rawData) throws IOException {
                    String UID = this.getCachedUID();
                    ConnectedUsers connectedUsers = LobbyServerMain.this.users;
                    synchronized (connectedUsers) {
                        byte state = DataSplitter.toUserState(rawData);
                        LobbyServerMain.this.users.modifyUserState(this.getSocket(), state);
                        WrappedData data = new WrappedData((byte)69, DataWrapper.wrapByte(state));
                        this.getOutputThread().put(data);
                        byte[] bytes = DataWrapper.wrapStateModified(UID, state);
                        WrappedData[] dataArray = new WrappedData[]{new WrappedData((byte)82, bytes)};
                        LobbyServerMain.this.putWrappedDataForAllConnectedUsers(dataArray);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void requestUserlist() throws IOException {
                    InputThread inputThread = this;
                    synchronized (inputThread) {
                        byte[] bytes = DataWrapper.wrapResponseUserlist(LobbyServerMain.this.users.getConnectedUsersClone());
                        WrappedData data = new WrappedData((byte)67, bytes);
                        this.getOutputThread().put(data);
                    }
                }

                private void checkVersion() throws IOException {
                    byte[] bytes = DataWrapper.wrapResponseVersion((short)2, (short)2);
                    WrappedData data = new WrappedData(bytes.length, (byte)64, bytes);
                    this.getOutputThread().put(data);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void newConnect(byte[] rawData) throws IOException {
                    byte[] myIP = this.getIPByteArray();
                    String UID = this.getCachedUID();
                    ConnectedUsers connectedUsers = LobbyServerMain.this.users;
                    synchronized (connectedUsers) {
                        UserInfo info = DataSplitter.toUserInfo(rawData, myIP, UID);
                        System.out.println(info);
                        WrappedData data = new WrappedData((byte)65, DataWrapper.wrapByte((byte)1));
                        this.getOutputThread().put(data);
                        LobbyServerMain.this.users.setUserInfo(this.getSocket(), info);
                        byte[] connectedUserData = DataWrapper.wrapNewConnected(info);
                        WrappedData[] dataArray = new WrappedData[]{new WrappedData((byte)80, connectedUserData)};
                        LobbyServerMain.this.putWrappedDataForAllConnectedUsers(dataArray);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void bye() throws IOException {
                    WrappedData data = new WrappedData((byte)66, new byte[0]);
                    this.getOutputThread().put(data);
                    data = new WrappedData((byte)0, new byte[0]);
                    WrappedData leave = new WrappedData((byte)81, DataWrapper.wrapString(this.getCachedUID()));
                    ConnectedUsers connectedUsers = LobbyServerMain.this.users;
                    synchronized (connectedUsers) {
                        this.getOutputThread().put(data);
                        LobbyServerMain.this.users.remove(this.getSocket());
                        LobbyServerMain.this.putWrappedDataForAllConnectedUsers(leave);
                    }
                    this.exitFlag = true;
                }

                private String getCachedUID() {
                    return this.cachedUID;
                }
            }

            class OutputThread
            extends AbstractOutputThread {
                public OutputThread(OutputStream out) {
                    super(out);
                }

                @Override
                public void run() {
                    try {
                        while (true) {
                            WrappedData data;
                            if ((data = (WrappedData)this.queue.take()).getCommand() == 0) {
                                logger.log(Level.INFO, "\u7d42\u4e86\u30b7\u30b0\u30ca\u30eb\u3092\u53d7\u3051\u53d6\u308a\u307e\u3057\u305f\u3002\u30b9\u30ec\u30c3\u30c9\u3092\u7d42\u4e86\u3057\u307e\u3059\u3002");
                                break;
                            }
                            this.out.send(data);
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.WARNING, "IO\u4f8b\u5916\u3092\u30ad\u30e3\u30c3\u30c1\u3057\u307e\u3057\u305f\u3002", e);
                        try {
                            this.out.close();
                        }
                        catch (IOException e1) {
                            logger.log(Level.WARNING, "\u51fa\u529b\u30b9\u30c8\u30ea\u30fc\u30e0\u306e\u30af\u30ed\u30fc\u30ba\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e1);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.INFO, "\u30b9\u30ec\u30c3\u30c9\u304c\u30a4\u30f3\u30bf\u30e9\u30d7\u30c8\u3055\u308c\u307e\u3057\u305f\u3002");
                        Thread.currentThread().interrupt();
                    }
                    System.out.println("OutputThread\u3092\u7d42\u4e86\u3055\u305b\u307e\u3059\u3002");
                }
            }
        }
    }
}

