/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Data.communication;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class UserInfo {
    private final String publicName;
    private final String UID;
    private final byte[] ipAddress;
    private final Short casterPort;
    private AtomicInteger state;
    private final Byte IMPolicy;
    private final Byte IPHideFlag;
    private final String publicMessage;
    private final String publicShortMessage;
    public static final byte WAITING = 0;
    public static final byte GATHERING = 1;
    public static final byte SETTING = 2;
    public static final byte FIGHTING = 3;
    public static final byte WATCHING = 4;
    public static final byte LEAVING = 5;
    public static final byte ACCEPT = 0;
    public static final byte REFUSE_IF_FIGHTING = 1;
    public static final byte REFUSE = 2;
    private static final Map<String, String> STATE_STR = new HashMap<String, String>();
    private static final Map<String, String> IM_STR = new HashMap<String, String>();

    static {
        STATE_STR.put("0", "\u5f85\u6a5f\u4e2d");
        STATE_STR.put("1", "\u52df\u96c6\u4e2d");
        STATE_STR.put("2", "\u8a2d\u5b9a\u4e2d");
        STATE_STR.put("3", "\u5bfe\u6226\u4e2d");
        STATE_STR.put("4", "\u89b3\u6226\u4e2d");
        STATE_STR.put("5", "\u9000\u5e2d\u4e2d");
        STATE_STR.put("\u5f85\u6a5f\u4e2d", "0");
        STATE_STR.put("\u52df\u96c6\u4e2d", "1");
        STATE_STR.put("\u8a2d\u5b9a\u4e2d", "2");
        STATE_STR.put("\u5bfe\u6226\u4e2d", "3");
        STATE_STR.put("\u89b3\u6226\u4e2d", "4");
        STATE_STR.put("\u9000\u5e2d\u4e2d", "5");
        IM_STR.put("0", "\u53ef");
        IM_STR.put("1", "\u5bfe\u6226\u4e2d\u62d2\u5426");
        IM_STR.put("2", "\u62d2\u5426");
        IM_STR.put("\u53ef", "0");
        IM_STR.put("\u5bfe\u6226\u4e2d\u62d2\u5426", "1");
        IM_STR.put("\u62d2\u5426", "2");
    }

    public UserInfo(String publicName, String UID, byte[] myIP, Short casterPort, Byte state, Byte IMPolicy, Byte IPHideFlag, String publicMessage, String publicShortMessage) {
        this.publicName = publicName;
        this.UID = UID;
        this.ipAddress = myIP;
        this.casterPort = casterPort;
        this.state = new AtomicInteger(state.byteValue());
        this.IMPolicy = IMPolicy;
        this.IPHideFlag = IPHideFlag;
        this.publicMessage = publicMessage;
        this.publicShortMessage = publicShortMessage;
    }

    public String getPublicName() {
        return this.publicName;
    }

    public String getUID() {
        return this.UID;
    }

    public byte[] getIpAddress() {
        return this.ipAddress;
    }

    public int getCasterPort() {
        int ret = this.casterPort.shortValue();
        if (ret < 0) {
            ret += 65536;
        }
        return ret;
    }

    public Byte getIMPolicy() {
        return this.IMPolicy;
    }

    public String getPublicMessage() {
        return this.publicMessage;
    }

    public String getPublicShortMessage() {
        return this.publicShortMessage;
    }

    public String toString() {
        String ipString = String.valueOf(this.ipAddress[0]) + "." + this.ipAddress[1] + "." + this.ipAddress[2] + "." + this.ipAddress[3];
        return "[publicName/UID/ipAddress/IMPolicy/IPHideFlag/publicMessage/publicShortMessage] " + this.publicName + "/" + this.UID + "/" + ipString + "/" + this.IMPolicy + "/" + this.IPHideFlag + "/" + this.publicMessage + "/" + this.publicShortMessage;
    }

    public Byte getIPHideFlag() {
        return this.IPHideFlag;
    }

    public void setState(Byte state) {
        this.state.set(state.intValue());
    }

    public Byte getState() {
        return this.state.byteValue();
    }

    public static String getIMPolicyString(int i) {
        return IM_STR.get(String.valueOf(i));
    }

    public static String getIMPolicyString(String key) {
        return IM_STR.get(key);
    }

    public static String getStateString(int i) {
        return STATE_STR.get(String.valueOf(i));
    }

    public static String getStateString(String key) {
        return STATE_STR.get(key);
    }
}

