/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Data.communication;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import jp.dip.th075altlobby.imo.Data.communication.ClientInfo;
import jp.dip.th075altlobby.imo.Data.communication.ClientToClientCommand;
import jp.dip.th075altlobby.imo.Data.communication.InstantMessage;
import jp.dip.th075altlobby.imo.Data.communication.UserInfo;

public class DataWrapper {
    public static byte[] wrapRequestUserlistModified(int lastID) throws IOException {
        return DataWrapper.wrapInteger(lastID);
    }

    public static byte[] wrapRequestInstantMessageModified(int lastID) throws IOException {
        return DataWrapper.wrapInteger(lastID);
    }

    public static byte[] wrapString(String s) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(s);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapPostInstantMessage(String to, String message, byte color) throws UTFDataFormatException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(to);
        dos.writeUTF(message);
        dos.writeByte(color);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapInteger(int i) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(i);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapByte(byte b) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(b);
        byte[] bA = baos.toByteArray();
        dos.close();
        return bA;
    }

    public static byte[] wrapResponseVersion(short protocolVersion, short serverVersion) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(protocolVersion);
        dos.writeShort(serverVersion);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapNewConnect(String publicName, String publicMessage, String publicShortMessage, Short port, Byte IMPolicy, Byte IPHideFlag) throws UTFDataFormatException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(publicName);
        dos.writeUTF(publicMessage);
        dos.writeUTF(publicShortMessage);
        dos.writeShort(port.shortValue());
        dos.writeByte(IMPolicy.byteValue());
        dos.writeByte(IPHideFlag.byteValue());
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapNewConnected(UserInfo info) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(info.getPublicName());
        dos.writeUTF(info.getUID());
        dos.write(info.getIpAddress(), 0, 4);
        dos.writeShort(info.getCasterPort());
        dos.writeByte(info.getIMPolicy().byteValue());
        dos.writeByte(info.getIPHideFlag().byteValue());
        dos.writeUTF(info.getPublicMessage());
        dos.writeUTF(info.getPublicShortMessage());
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapResponseUserlist(Map<Socket, ClientInfo> connectedUsers) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        DataOutputStream dos2 = new DataOutputStream(baos2);
        int counter = 0;
        for (ClientInfo clientInfo : connectedUsers.values()) {
            UserInfo info = clientInfo.getUserInfo();
            if (info == null) continue;
            dos.writeUTF(info.getPublicName());
            dos.writeUTF(info.getUID());
            dos.write(info.getIpAddress(), 0, 4);
            dos.writeShort(info.getCasterPort());
            dos.writeByte(info.getState().byteValue());
            dos.writeByte(info.getIMPolicy().byteValue());
            dos.writeByte(info.getIPHideFlag().byteValue());
            dos.writeUTF(info.getPublicMessage());
            dos.writeUTF(info.getPublicShortMessage());
            ++counter;
        }
        dos.close();
        dos2.writeInt(counter);
        dos2.write(baos.toByteArray());
        byte[] b = baos2.toByteArray();
        dos2.close();
        return b;
    }

    public static byte[] wrapModifyUserState(byte state) throws IOException {
        return DataWrapper.wrapByte(state);
    }

    public static byte[] wrapStateModified(String UID, byte state) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(UID);
        dos.writeByte(state);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapDistributedIM(InstantMessage dIM) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(dIM.getFrom());
        dos.writeUTF(dIM.getTo());
        dos.writeUTF(dIM.getMessage());
        dos.writeLong(dIM.getTime());
        dos.writeByte(dIM.getColor().byteValue());
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapResponseStoredInstantMessages(byte responseCode, Collection<InstantMessage> InstantMessages) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(responseCode);
        if (InstantMessages == null) {
            dos.writeByte(0);
        } else {
            int collectionSize = InstantMessages.size();
            if (collectionSize == 0) {
                dos.writeByte(0);
            } else {
                dos.writeByte(collectionSize);
                ArrayDeque<InstantMessage> IMQueue = new ArrayDeque<InstantMessage>(InstantMessages);
                while (!IMQueue.isEmpty()) {
                    InstantMessage current = (InstantMessage)IMQueue.poll();
                    dos.writeUTF(current.getFrom());
                    dos.writeUTF(current.getTo());
                    dos.writeUTF(current.getMessage());
                    dos.writeLong(current.getTime());
                    dos.writeByte(current.getColor().byteValue());
                }
            }
        }
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapPostClientToClientCommand(String toUID, byte command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(toUID);
        dos.writeByte(command);
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }

    public static byte[] wrapClientToClientCommand(ClientToClientCommand c) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(c.getFromUID());
        dos.writeUTF(c.getToUID());
        dos.writeByte(c.getCommand());
        byte[] b = baos.toByteArray();
        dos.close();
        return b;
    }
}

