/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Data.communication;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.LinkedList;
import jp.dip.th075altlobby.imo.Data.communication.ClientToClientCommand;
import jp.dip.th075altlobby.imo.Data.communication.InstantMessage;
import jp.dip.th075altlobby.imo.Data.communication.ResponseStoredInstantMessages;
import jp.dip.th075altlobby.imo.Data.communication.StateModifiedInfo;
import jp.dip.th075altlobby.imo.Data.communication.UserInfo;
import jp.dip.th075altlobby.imo.Data.communication.VersionResponse;

public class DataSplitter {
    public static Integer toInteger(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        Integer i = dis.readInt();
        dis.close();
        return i;
    }

    public static Byte toByte(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        Byte bb = dis.readByte();
        dis.close();
        return bb;
    }

    public static InstantMessage toPostedInstantMessage(byte[] b, String myUID) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String toUID = dis.readUTF();
        String message = dis.readUTF();
        Byte color = dis.readByte();
        dis.close();
        return new InstantMessage(myUID, toUID, message, System.currentTimeMillis(), color);
    }

    public static VersionResponse toVersionResponse(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        Short protocol_ver = dis.readShort();
        Short server_ver = dis.readShort();
        dis.close();
        return new VersionResponse(protocol_ver, server_ver);
    }

    public static UserInfo toUserInfo(byte[] b, byte[] myIP, String myUID) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String publicName = dis.readUTF();
        String publicMessage = dis.readUTF();
        String publicShortMessage = dis.readUTF();
        Short port = dis.readShort();
        Byte IMPolicy = dis.readByte();
        Byte IPHideFlag = dis.readByte();
        Byte state = 0;
        dis.close();
        return new UserInfo(publicName, myUID, myIP, port, state, IMPolicy, IPHideFlag, publicMessage, publicShortMessage);
    }

    public static UserInfo toNewConnectedUserInfo(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        byte[] ipAddress = new byte[4];
        String publicName = dis.readUTF();
        String UID = dis.readUTF();
        dis.read(ipAddress, 0, 4);
        Short port = dis.readShort();
        Byte IMPolicy = dis.readByte();
        Byte IPHideFlag = dis.readByte();
        String publicMessage = dis.readUTF();
        String publicShortMessage = dis.readUTF();
        Byte state = 0;
        dis.close();
        return new UserInfo(publicName, UID, ipAddress, port, state, IMPolicy, IPHideFlag, publicMessage, publicShortMessage);
    }

    public static UserInfo[] toConnectedUsersInfo(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        Integer counter = dis.readInt();
        LinkedList<UserInfo> connectedUsersInfo = new LinkedList<UserInfo>();
        int i = 0;
        while (i < counter) {
            String publicName = dis.readUTF();
            String UID = dis.readUTF();
            byte[] ipAddress = new byte[4];
            int readSize = dis.read(ipAddress, 0, 4);
            if (readSize != 4) {
                System.out.println("ERROR SIZE");
            }
            Short port = dis.readShort();
            Byte state = dis.readByte();
            Byte IMPolicy = dis.readByte();
            Byte IPHideFlag = dis.readByte();
            String publicMessage = dis.readUTF();
            String publicShortMessage = dis.readUTF();
            connectedUsersInfo.add(new UserInfo(publicName, UID, ipAddress, port, state, IMPolicy, IPHideFlag, publicMessage, publicShortMessage));
            ++i;
        }
        return connectedUsersInfo.toArray(new UserInfo[connectedUsersInfo.size()]);
    }

    public static Byte toUserState(byte[] b) throws IOException {
        return DataSplitter.toByte(b);
    }

    public static StateModifiedInfo toStateModifiedInfo(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String UID = dis.readUTF();
        Byte state = dis.readByte();
        dis.close();
        return new StateModifiedInfo(UID, state);
    }

    public static InstantMessage toDistributedIM(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String from = dis.readUTF();
        String to = dis.readUTF();
        String message = dis.readUTF();
        Long time = dis.readLong();
        Byte color = dis.readByte();
        dis.close();
        return new InstantMessage(from, to, message, time, color);
    }

    public static ResponseStoredInstantMessages toResponseStoredInstantMessages(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        byte responseCode = dis.readByte();
        int size = dis.readByte();
        ArrayDeque<InstantMessage> ims = new ArrayDeque<InstantMessage>();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                String from = dis.readUTF();
                String to = dis.readUTF();
                String message = dis.readUTF();
                Long time = dis.readLong();
                Byte color = dis.readByte();
                ims.add(new InstantMessage(from, to, message, time, color));
                ++i;
            }
        }
        dis.close();
        return new ResponseStoredInstantMessages(responseCode, ims);
    }

    public static ClientToClientCommand toPostedClientToClientCommand(byte[] b, String fromUID) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String toUID = dis.readUTF();
        Byte command = dis.readByte();
        dis.close();
        return new ClientToClientCommand(fromUID, toUID, command);
    }

    public static ClientToClientCommand toDistributedClientToClientCommand(byte[] b) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(b));
        String fromUID = dis.readUTF();
        String toUID = dis.readUTF();
        Byte command = dis.readByte();
        dis.close();
        return new ClientToClientCommand(fromUID, toUID, command);
    }

    public static String toString(byte[] rawData) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(rawData));
        String str = dis.readUTF();
        dis.close();
        return str;
    }
}

