/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Application.Settings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class ServerSettings {
    private static final Logger logger = Logger.getLogger("jp.dip.th075altlobby.imo.Application.Settings");
    private final Properties settings = new Properties();

    public ServerSettings() {
        try {
            this.settings.load(new BufferedReader(new FileReader("alt_lobby_server_config.ini")));
        }
        catch (FileNotFoundException e) {
            try {
                this.settings.put("IM_limit", "30");
                this.settings.put("command_port", "9556");
                this.settings.put("client_max_connection", "1");
                this.settings.put("max_connection", "256");
                this.settings.put("port", "9555");
                this.settings.put("address_translation", "127.0.0.1->127.0.0.1");
                this.settings.put("instant_messages_filepath", "instant_messages.log");
                this.settings.store(new BufferedWriter(new FileWriter("alt_lobby_server_config.ini")), "alt_lobby_server");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8a2d\u5b9a\u3092\u9069\u5fdc\u3057\u307e\u3059\u3002");
        }
        catch (IOException e) {
            logger.info("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u8a2d\u5b9a\u3092\u9069\u5fdc\u3057\u307e\u3059\u3002");
        }
    }

    public String getInstantMessagesPath() {
        String path = this.settings.getProperty("instant_messages_filepath");
        if (path == null) {
            logger.info("IM\u4fdd\u7ba1\u5148\u30d5\u30a1\u30a4\u30eb\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[instant_messages.log]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            path = "instant_messages.log";
        }
        return path;
    }

    public String getToAddress() {
        String address_translation = this.settings.getProperty("address_translation");
        if (address_translation == null) {
            logger.info("\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        int pos = address_translation.indexOf("->");
        if (pos == -1) {
            logger.info("\u5909\u63db\u5143\u30a2\u30c9\u30ec\u30b9\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        String to_address_string = address_translation.substring(pos + 2);
        if (!to_address_string.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
            logger.info("\u5909\u63db\u5143\u30a2\u30c9\u30ec\u30b9\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        return to_address_string;
    }

    public String getFromAddress() {
        String address_translation = this.settings.getProperty("address_translation");
        if (address_translation == null) {
            logger.info("\u30a2\u30c9\u30ec\u30b9\u5909\u63db\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        int pos = address_translation.indexOf("->");
        if (pos == -1) {
            logger.info("\u5909\u63db\u5143\u30a2\u30c9\u30ec\u30b9\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        String from_address_string = address_translation.substring(0, pos);
        if (!from_address_string.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$")) {
            logger.info("\u5909\u63db\u5143\u30a2\u30c9\u30ec\u30b9\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[127.0.0.1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return "127.0.0.1";
        }
        return from_address_string;
    }

    public int getInstantMessageStoreLimit() {
        int im_limit;
        String im_limit_string = this.settings.getProperty("IM_limit");
        if (im_limit_string == null) {
            logger.info("\u30b3\u30de\u30f3\u30c9\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[30]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return 30;
        }
        try {
            im_limit = Integer.parseInt(im_limit_string);
        }
        catch (NumberFormatException e) {
            logger.info("\u30b3\u30de\u30f3\u30c9\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[30]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            im_limit = 30;
        }
        return im_limit;
    }

    public int getServerCommandPort() {
        int server_port;
        String server_port_string = this.settings.getProperty("command_port");
        if (server_port_string == null) {
            logger.info("\u30b3\u30de\u30f3\u30c9\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[9556]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return 9556;
        }
        try {
            server_port = Integer.parseInt(server_port_string);
        }
        catch (NumberFormatException e) {
            logger.info("\u30b3\u30de\u30f3\u30c9\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[9556]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            server_port = 9556;
        }
        return server_port;
    }

    public int getClientMaxConnection() {
        int server_client_max_connection;
        String server_client_max_connection_string = this.settings.getProperty("client_max_connection");
        if (server_client_max_connection_string == null) {
            logger.info("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6570\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return 1;
        }
        try {
            server_client_max_connection = Integer.parseInt(server_client_max_connection_string);
        }
        catch (NumberFormatException e) {
            logger.info("\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6570\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[1]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            server_client_max_connection = 1;
        }
        return server_client_max_connection;
    }

    public int getMaxConnection() {
        int server_max_connection;
        String server_max_connection_string = this.settings.getProperty("max_connection");
        if (server_max_connection_string == null) {
            logger.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6570\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[256]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return 256;
        }
        try {
            server_max_connection = Integer.parseInt(server_max_connection_string);
        }
        catch (NumberFormatException e) {
            logger.info("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u6570\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[256]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            server_max_connection = 256;
        }
        return server_max_connection;
    }

    public int getSeverPort() {
        int server_port;
        String server_port_string = this.settings.getProperty("port");
        if (server_port_string == null) {
            logger.info("\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u305b\u3093\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[9555]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            return 9555;
        }
        try {
            server_port = Integer.parseInt(server_port_string);
        }
        catch (NumberFormatException e) {
            logger.info("\u30dd\u30fc\u30c8\u756a\u53f7\u306e\u8a2d\u5b9a\u306b\u8aa4\u308a\u304c\u3042\u308a\u307e\u3059\u3002\u30c7\u30d5\u30a9\u30eb\u30c8\u5024[9555]\u3092\u4f7f\u7528\u3057\u307e\u3059\u3002");
            server_port = 9555;
        }
        return server_port;
    }
}

