/*
 * Decompiled with CFR 0.152.
 */
package jp.dip.th075altlobby.imo.Application;

import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import jp.dip.th075altlobby.imo.Data.IPConverter.IPConverter;
import jp.dip.th075altlobby.imo.Data.communication.AbstractInputThread;
import jp.dip.th075altlobby.imo.Data.communication.AbstractOutputThread;
import jp.dip.th075altlobby.imo.Data.communication.ClientInfo;
import jp.dip.th075altlobby.imo.Data.communication.UserInfo;

public class ConnectedUsers {
    private final ConcurrentMap<Socket, ClientInfo> connectedUsers = new ConcurrentHashMap<Socket, ClientInfo>();
    private final ConcurrentMap<Integer, AtomicInteger> connectedCounterMap = new ConcurrentHashMap<Integer, AtomicInteger>();

    public AbstractOutputThread getOutputThread(Socket s) {
        ClientInfo c = (ClientInfo)this.connectedUsers.get(s);
        if (c == null) {
            return null;
        }
        return c.getOutputThread();
    }

    public void put(Socket s, AbstractInputThread in, AbstractOutputThread out) {
        ClientInfo client = new ClientInfo(in, out);
        this.connectedUsers.put(s, client);
        Integer ipInteger = IPConverter.toInt(s.getInetAddress().getAddress());
        AtomicInteger counter = (AtomicInteger)this.connectedCounterMap.get(ipInteger);
        if (counter == null) {
            this.connectedCounterMap.putIfAbsent(ipInteger, new AtomicInteger(1));
        } else {
            counter.getAndIncrement();
        }
    }

    public void remove(Socket s) {
        this.connectedUsers.remove(s);
        Integer ipInteger = IPConverter.toInt(s.getInetAddress().getAddress());
        AtomicInteger counter = (AtomicInteger)this.connectedCounterMap.get(ipInteger);
        if (counter != null) {
            counter.getAndDecrement();
        }
    }

    public int getConnectionCounter(Socket s) {
        Integer ipInteger = IPConverter.toInt(s.getInetAddress().getAddress());
        AtomicInteger counter = (AtomicInteger)this.connectedCounterMap.get(ipInteger);
        if (counter != null) {
            return counter.get();
        }
        return 0;
    }

    public Map<Socket, ClientInfo> getConnectedUsersClone() {
        ConcurrentHashMap<Socket, ClientInfo> map = new ConcurrentHashMap<Socket, ClientInfo>();
        map.putAll(this.connectedUsers);
        return map;
    }

    public synchronized void setUserInfo(Socket s, UserInfo info) {
        ClientInfo cinfo = (ClientInfo)this.connectedUsers.get(s);
        if (cinfo == null) {
            throw new NullPointerException("\u30ad\u30fc\u306b\u5bfe\u5fdc\u3059\u308b\u8981\u7d20\u304cNull\u3067\u3059\u3002");
        }
        cinfo.setUserInfo(info);
    }

    public synchronized void modifyUserState(Socket s, byte state) {
        ClientInfo cinfo = (ClientInfo)this.connectedUsers.get(s);
        if (cinfo == null) {
            throw new NullPointerException("\u30ad\u30fc\u306b\u5bfe\u5fdc\u3059\u308b\u8981\u7d20\u304cnull\u3067\u3059\u3002");
        }
        UserInfo uinfo = cinfo.getUserInfo();
        if (uinfo == null) {
            throw new NullPointerException("\u5185\u90e8\u306eUserInfo\u304cnull\u3067\u3059\u3002");
        }
        uinfo.setState(state);
    }
}

