#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define BGM_FILE	"thbgm_tr.dat"
#define MAX_BGM		14

int bgmtable[MAX_BGM][3]={
	{0x00000010, 0x003ACD80, 0x00A4FE00},
	{0x00A4FE10, 0x002E72A8, 0x01248B70},
	{0x01C98980, 0x00173954, 0x009245B8},
	{0x025BCF38, 0x000AED00, 0x00E38900},
	{0x033F5838, 0x00057680, 0x0071C480},
	{0x03B11CB8, 0x00061580, 0x011FE640},
	{0x04D102F8, 0x00030AC0, 0x008FF320},
	{0x0560F618, 0x00053D00, 0x00C202C0},
	{0x0622F8D8, 0x00029E80, 0x00610160},
	{0x0683FA38, 0x00297B20, 0x01771E00},
	{0x07FB1838, 0x0014BD90, 0x00BB8F00},
	{0x08B6A738, 0x000ACD40, 0x00D04A80},
	{0x0986F1B8, 0x000566A0, 0x00682540},
	{0x09EF16F8, 0x001CACC8, 0x0066DCC0}
};

int SamplingRate;

char bgmfile[MAX_BGM][50]={
	"01 ~[썰.wav",
	"02 ̖.wav",
	"03 ̖iEgXj.wav",
	"04 S[Xg[h.wav",
	"05 S[Xg[hiEgXj.wav",
	"06 dւ悤.wav",
	"07 dւ悤iEgXj.wav",
	"08 O̗d.wav",
	"09 O̗diEgXj.wav",
	"10 fGȕŕ邵܂.wav",
	"11 fGȕŕ邵܂iEgXj.wav",
	"12 Wbhp_CX.wav",
	"13 Wbhp_CXiEgXj.wav",
	"14 vC[YXRA.wav"
};

void makeheader(char *header,int datasize){
	int i;
	short s;
	memcpy(header,"RIFF",4);
	i = datasize + 36;
	memcpy(header+4,&i,4);
	memcpy(header+8,"WAVEfmt ",8);
	i = 16;
	memcpy(header+16,&i,4);
	s = 1;
	memcpy(header+20,&s,2);
	s = 2;
	memcpy(header+22,&s,2);
	i = SamplingRate;
	memcpy(header+24,&i,4);
	i = SamplingRate * 2 * 2;
	memcpy(header+28,&i,4);
	s = 2 * 2;
	memcpy(header+32,&s,2);
	s = 16;
	memcpy(header+34,&s,2);
	memcpy(header+36,"data",4);
	i = datasize;
	memcpy(header+40,&i,4);

}

int main(int argc,char *argv[]){
	FILE *datf,*bgmf;
	int i,j,l,k;
	int rep=2;
	int length;
	int fade=0;
	int fadep=0;
	int ts=0;
	int te=MAX_BGM;
	char header[44];
	short buf[44100*2];
	int s,e;
	double d;


	//bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	//ꂼʒuɊZ
	for(i=0;i<MAX_BGM;i++){
		bgmtable[i][1]+=bgmtable[i][0];
		bgmtable[i][2]+=bgmtable[i][0];
	}

	//argc̃`FbN
	for(i=1;i<argc;i++){
		switch(argv[i][0]){
		case 'f' :
			argv[i]++; fade=atoi(argv[i]); break;
		case 'F' :
			argv[i]++; fade=-atoi(argv[i]); break;
		case 'P' :
		case 'p' :
			argv[i]++; fadep=atoi(argv[i]); break;
		case 'T' :
		case 't' :
			argv[i]++; ts=te=atoi(argv[i]); break;
		default:
			rep=atoi(argv[i]);
		}
	}

	if(rep<1 || rep>10){
		printf("repeat must be 1-10\n");
		return 0;
	}
	if(fade<-30 || fade>30){
		printf("fade must be 0-30\n");
		return 0;
	}
	if(fadep<0 || fadep>3){
		printf("fade pattern must be 0-3\n");
		return 0;
	}
	if(ts<0 || te>MAX_BGM){
		printf("track number must be 1-%d\n", MAX_BGM);
		return 0;
	}


	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n",ts+1,te,rep,fade,fadep);
	if(ts) ts--;

	datf=fopen(BGM_FILE,"rb");
	if(datf==NULL){
		printf("%s not found.", BGM_FILE);
		return 0;
	}

	//Jn
	for(i=ts;i<te;i++){

		printf("Create %s ...\n",bgmfile[i]);
		if(strstr(bgmfile[i],"iEgXj")!=0){
			SamplingRate = 22050;
		}else{
			SamplingRate = 44100;
		}
		bgmf=fopen(bgmfile[i],"wb");
		length=(bgmtable[i][2]-bgmtable[i][0])+(bgmtable[i][2]-bgmtable[i][1])*(rep-1);
		if(fade<0) length+=(-fade)*SamplingRate*4;
		makeheader(header,length);
		fwrite(header,1,44,bgmf);

		//[v
		for(k=0;k<rep;k++){
			//[
			s=bgmtable[i][1];
			if(k==0) s=bgmtable[i][0];

			//I[
			e=bgmtable[i][2];
			if(k==rep-1 && fade>0) e=bgmtable[i][2]-fade*SamplingRate*4;

			for(j=s;j<e;j+=SamplingRate*4){
				if(j+SamplingRate*4>e) l=e-j;
				else l=SamplingRate*4;

				fseek(datf,j,SEEK_SET);
				fread(buf,1,l,datf);
				fwrite(buf,1,l,bgmf);
			}
		}

		//tF[hAEg
		if(fade>0){
			//[vI[
			s=bgmtable[i][2]-fade*SamplingRate*4;
			e=bgmtable[i][2];
		}
		else if(fade<0){
			//[v[
			s=bgmtable[i][1];
			e=s-fade*SamplingRate*4;
		}
		else{
			s=e=0;
		}

		for(j=s;j<e;j+=SamplingRate*4){
			if(j+SamplingRate*4>e) l=e-j;
			else l=SamplingRate*4;

			fseek(datf,j,SEEK_SET);
			fread(buf,1,l,datf);
			for(k=0;k<l/4;k++){
				switch (fadep) {
				case 0 :
					d=(float)((j-s)/4+k)/(abs(fade)*SamplingRate);
					d=pow(0.001,d);
					break;
				case 1 :
					d=1-(float)((j-s)/4+k)/(abs(fade)*SamplingRate);
					break;
				case 2 :
					d=(float)((j-s)/4+k)/(abs(fade)*SamplingRate);
					d=(pow(0.001,d)+(1-d))/2;
					break;
				case 3 :
					d=(cos(3.1415926535*(float)((j-s)/4+k)/(abs(fade)*SamplingRate))+1)/2;
					break;
				}

				buf[2*k]=(short)(buf[2*k]*d);
				buf[2*k+1]=(short)(buf[2*k+1]*d);
			}
			fwrite(buf,1,l,bgmf);
		}

		fclose(bgmf);
	}
	fclose(datf);

	return 0;
}
