#include <windows.h>
#include <commctrl.h>

extern "C"
int * __errno() { return _errno(); }

extern bool MainWindow_RegisterClass(HINSTANCE);
extern bool MainWindow_Show(HINSTANCE);
extern UINT_PTR MainWindow_Run();

int APIENTRY WinMain(
  HINSTANCE hInstance,
  HINSTANCE hPrevInstance,
  LPSTR     lpCmdLine,
  int       nCmdShow )
{
  HWND hMainWnd;
  INITCOMMONCONTROLSEX initctrl;
  
  initctrl.dwSize = sizeof( INITCOMMONCONTROLSEX );
  initctrl.dwICC = ICC_WIN95_CLASSES;// 0?
  if(FALSE == InitCommonControlsEx(&initctrl)) {
  	MessageBox(NULL, "InitCommonControlsEx() is failed", "Brightmoon", MB_OK | MB_ICONSTOP );
    return -1;
  }
  /*
  You *must* initialize COM using CoInitializeEx with the COINIT_APARTMENTTHREADED flag
  set in the dwCoInit parameter prior to calling SHBrowseForFolder. You can alse use CoInitialize or OleInitialize,
  which always use apartment threading.
  */
  if(S_OK != CoInitializeEx(NULL, COINIT_APARTMENTTHREADED)) {
  	MessageBox(NULL, "CoInitializeEx() is failed", "Brightmoon", MB_OK | MB_ICONSTOP );
    return -1;
  }
  if(
  !MainWindow_RegisterClass(hInstance) ||
  !MainWindow_Show(hInstance)) {
    MessageBox(NULL, "Failed to initialize", "Brightmoon", MB_OK | MB_ICONSTOP);
    return -1;
  }

  UINT_PTR retcode;
  retcode = MainWindow_Run();
  CoUninitialize();
  return retcode;
}
