#include <windows.h>
#include <stdio.h>

struct DATINFO {
	char name[128];
	DWORD offset;
	DWORD size;
};

void base_mask (int mask[0x270], int s);
void update_mask (int mask[0x270]);
char get_mask (int mask[0x270], int n);

void get_datinfo (DATINFO *datinfo, char *header, int num);
void decoding (char *buf, DATINFO datinfo);

void MakeDir(char* dir);

int main (int argc, char *argv[])
{
	if (argc < 2) {
		printf ("usage: 6kinodat <dat file>\n");
		return 0;
	}

	FILE *dat = fopen (argv[1], "rb");
	if (dat == NULL) {
		printf ("%s open failed.\n", argv[1]);
		return 0;
	}

	short num;
	int size;
	fread (&num, 2, 1, dat);
	fread (&size, 4, 1, dat);

	char *header = new char[size];
	fread (header, 1, size, dat);

	// x[XƂȂ}XNe[u쐬
	int mask[0x270];
	base_mask (mask, size);

	unsigned char c1 = 0xC5, c2 = 0x89;

	for (int i = 0; i < size; i++) {
		if (i % 0x270 == 0) update_mask (mask);	// }XNe[uXV
		header[i] ^= get_mask (mask, i);		// iiKځj
		header[i] ^= c1;				// iiKځj
		c1 += c2;
		c2 += 0x49;
	}

	// t@C擾
	DATINFO *datinfo = new DATINFO[num];
	get_datinfo (datinfo, header, num);

	delete [] header;

	for (int i = 0; i < num; i++) {
		printf ("(%4d/%4d) %s -> ", i+1, num, datinfo[i].name);

		// tH_쐬
		char dir[128], *file;
		strcpy (dir, datinfo[i].name);
		if (file = strrchr (dir, '/')) {
			*file = '\0';
			MakeDir (dir);
		}

		// f[^擾
		fseek (dat, datinfo[i].offset, SEEK_SET);
		char *buf = new char[datinfo[i].size];
		fread (buf, 1, datinfo[i].size, dat);

		// f[^̕
		decoding (buf, datinfo[i]);

		// t@C֏o
		FILE *out = fopen (datinfo[i].name, "wb");
		if (out) {
			fwrite (buf, 1, datinfo[i].size, out);
			fclose (out);
			printf ("OK\n");
		} else {
			printf ("file write error.\n");
		}

		delete [] buf;
	}

	delete [] datinfo;
	fclose (dat);

	return 0;
}


// x[X}XNe[u쐬
void base_mask (int mask[0x270], int s)
{
	mask[0] = (s += 6);

	for (int i = 1; i < 0x270; i++) {
		unsigned int m = mask[i-1];
		m >>= 0x1E;
		m ^= mask[i-1];
		m *= 0x6C078965;
		m += i;
		mask[i] = m;
	}
}


// }XNe[uXV
void update_mask (int mask[0x270])
{
	for (int i = 0; i < 0xE3; i++) {
		unsigned int m = mask[i+1];
		m ^= mask[i];
		m &= 0x7FFFFFFF;
		m ^= mask[i];
		int p = m;
		m >>= 1;
		p &= 1;
		m ^= ((p) ? 0x9908B0DF : 0);
		m ^= mask[0x18C+i+1];
		mask[i] = m;
	}

	for (int i = 0xE3; i < 0x26F; i++) {
		unsigned int m = mask[i];
		m ^= mask[i+1];
		m &= 0x7FFFFFFF;
		m ^= mask[i];
		int p = m;
		p &= 1;
		p = ((p) ? 0x9908B0DF : 0);
		p ^= mask[i-0xE3];
		m >>= 1;
		p ^= m;
		mask[i] = p;
	}

	int p = mask[0x26F];
	unsigned int m = mask[0];
	m ^= p;
	m &= 0x7FFFFFFF;
	m ^= p;
	p = m;
	m >>= 1;
	p &= 1;
	m ^= ((p) ? 0x9908B0DF : 0);
	m ^= mask[0x18C];
	mask[0x26F] = m;
}


// }XNlԂ
char get_mask (int mask[0x270], int n)
{
	int m = mask[n % 0x270];
	unsigned int p = m;
	p >>= 0xB;
	m ^= p;
	unsigned int s = m;
	s &= 0xFF3A58AD;
	s <<= 7;
	m ^= s;
	p = m;
	p &= 0xFFFFDF8C;
	p <<= 0xF;
	m ^= p;
	s = m;
	s >>= 0x12;
	s ^= m;

	return (char)s;
}


// A[JCũt@C擾
void get_datinfo (DATINFO *datinfo, char *header, int num)
{
	for (int i = 0; i < num; i++) {
		datinfo[i].offset = *(DWORD*)header;
		datinfo[i].size = *(DWORD*)(header += 4);
		char len = *(header += 4);
		strncpy (datinfo[i].name, ++header, len);
		datinfo[i].name[len] = '\0';
		header += len;
	}
}


// f[^𕜍
void decoding (char *buf, DATINFO datinfo)
{
	int size = datinfo.size;
	int offset = datinfo.offset;
	offset >>= 1;
	char mask = (char)offset;
	mask |= 0x23;

	for (int i = 0; i < size; i++)
		*(buf++) ^= mask;
}


// fBNg쐬(r̃pXS⊮)
void MakeDir(char* dir)
{
	DWORD ret = GetFileAttributes(dir);
	if((ret != 0xFFFFFFFF) && (ret & FILE_ATTRIBUTE_DIRECTORY)!=0);
	else if(CreateDirectory(dir, NULL)==0){
		char  ss[MAX_PATH], *end;
		char* p1 = strrchr(dir,'\\');
		char* p2 = strrchr(dir,'/');
		if(p1>p2)	end = p1;
		else		end = p2;
		int length = end-dir;
		if(length>0){
			ZeroMemory(ss, sizeof(ss));
			memcpy(ss, dir, length);
			MakeDir(ss);
			MakeDir(dir);
		}
	}
}
