#include "pch.hpp"
#include "GlobalSettings.hpp"
#include "DlgCommon.hpp"
#include "RankProfDlg.hpp"
#include "TrackRecordFilterDlg.hpp"
#include "TrackRecordDlg.hpp"
#include "ColoredRecordView.hpp"
#include "SortListView.hpp"
#include "ScoreLine.hpp"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define UC_REFLESH 0xEE00


SLVCOLUMN s_listColumns[] = {
	{ LVCFMT_LEFT,  100, _T(""),	SLVSORT_STRING },
	{ LVCFMT_RIGHT,  55, _T("ΐ퐔"),	SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),		SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),		SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),	SLVSORT_INTEGER }
};

static void RankProfDialog_QueryCallback(SCORELINE_ITEM *item, void *user)
{
	HWND listWnd = reinterpret_cast<HWND>(user);

	TCHAR text[256];
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.iItem = 0;
	lvitem.iSubItem = 0;
	lvitem.pszText = text;
	::lstrcpyn(text, MinimalA2T(item->p2name), _countof(text));
	ListView_InsertItem(listWnd, &lvitem);

	lvitem.iSubItem = 1;
	::wsprintf(text, _T("%d"), item->p1win + item->p2win);
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 2;
	::wsprintf(text, _T("%d"), item->p1win);
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 3;
	::wsprintf(text, _T("%d"), item->p2win);
	ListView_SetItem(listWnd, &lvitem);

	// 
	int sum = item->p1win + item->p2win;
	int winningRate = ::MulDiv(item->p1win, g_winningRatePrecision, sum ? sum : 1);
	lvitem.iSubItem = 4;
	::wsprintf(text, (g_highPrecisionRateEnabled ? _T("%d.%01d%%") : _T("%d%%")), winningRate / g_winningRateFp, winningRate % g_winningRateFp);
	ListView_SetItem(listWnd, &lvitem);

	// p[^̏tB[hXV
	lvitem.mask = LVIF_PARAM;
	lvitem.iSubItem = 0;
	ListView_GetItem(listWnd, &lvitem);
	LVPARAMFIELD(lvitem.lParam).winningRate = winningRate - g_winningRatePrecision / 2;
	ListView_SetItem(listWnd, &lvitem);
}

static void SysMenu_OnClose(HWND hDlg, int x, int y)
{
	::DestroyWindow(hDlg);
}

static void SysMenu_OnReflesh(HWND hDlg, int x, int y)
{
	HWND listWnd = ::GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	ListView_DeleteAllItems(listWnd);
	SCORELINE_FILTER_DESC filterDesc;
	filterDesc.mask = 0;
	ScoreLine_QueryProfileRank(filterDesc, RankProfDialog_QueryCallback, (void*)listWnd);
}

static LRESULT RankProfView_OnDoubleClick(HWND hwndParent, HWND hwnd)
{
	int index = ListView_GetSelectionMark(hwnd);
	if (index >= 0) {
		LVITEM item;
		item.mask = LVIF_TEXT;
		item.iItem = index;
		item.iSubItem = 0;
		item.cchTextMax = _countof(g_trfltP2Name);
		item.pszText = g_trfltP2Name;
		ListView_GetItem(hwnd, &item);

		g_trfltP2NameEnabled = true;

		TrackRecordDialog_ShowModeless(GetParent(hwndParent), NULL);
	}
	return FALSE;
}

static void RankProfDialog_OnSysCommand(HWND hDlg, UINT nID, int x, int y)
{
	if (nID == SC_CLOSE) {
		SysMenu_OnClose(hDlg, x, y);
	} else if (nID == UC_REFLESH) {
		SysMenu_OnReflesh(hDlg, x, y);
	}
}

static LRESULT RankProfDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_SCORELINE:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return ColoredRecordView_OnCustomDrawWithRateColorization(hDlg, reinterpret_cast<LPNMLVCUSTOMDRAW>(pNMHdr));
		case NM_DBLCLK:
			return RankProfView_OnDoubleClick(hDlg, pNMHdr->hwndFrom);
		case LVN_COLUMNCLICK:
			return SortListView_OnColumnClick(hDlg, reinterpret_cast<LPNMLISTVIEW>(pNMHdr));
		}
		break;
	}
	return FALSE;
}

static BOOL RankProfDialog_InitSysMenu(HWND hDlg)
{
	HMENU hSysMenu = ::GetSystemMenu(hDlg, FALSE);
	int itemIndex = 0;
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REFLESH, _T("ŐV̏ɍXV"));
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	return TRUE;
}

static BOOL RankProfDialog_InitListView(HWND hDlg)
{
	HWND hwndListView = ::GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	SortListView_Initialize(hwndListView, s_listColumns, _countof(s_listColumns));

	SCORELINE_FILTER_DESC filterDesc;
	filterDesc.mask = 0;
	ScoreLine_QueryProfileRank(filterDesc, RankProfDialog_QueryCallback, reinterpret_cast<void*>(hwndListView));

	return TRUE;
}

static BOOL RankProfDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	::SetWindowText(hDlg, _T("vt@C"));
	RankProfDialog_InitSysMenu(hDlg);
	RankProfDialog_InitListView(hDlg);
	return TRUE;
}

BOOL CALLBACK RankProfDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, RankProfDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_SYSCOMMAND, RankProfDialog_OnSysCommand);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, RankProfDialog_OnNotify);
	}
	return FALSE;
}
