#include <windows.h>
#include <shlwapi.h>

#define SWRS_USES_HASH
#include "../include/swrs.h"

class CFileReader : public IFileReader {
public:
	CFileReader(LPCSTR lpFileName) {
		m_dwReadLength = 0;
		m_hFile = CreateFile(lpFileName, GENERIC_READ, FILE_SHARE_READ,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
		if(m_hFile == INVALID_HANDLE_VALUE) {
			m_hFile = NULL;
		}
	}
	virtual ~CFileReader() {
		if(m_hFile != NULL) {
			CloseHandle(m_hFile);
		}
	}

public:
	virtual bool Read(LPVOID lpBuffer, DWORD nNumberOfBytesToRead) {
		return ReadFile(m_hFile, lpBuffer, nNumberOfBytesToRead, &m_dwReadLength, NULL) != 0;
	}
	virtual DWORD GetReadLength() { 
		return m_dwReadLength;
	}
	virtual LONG Seek(LONG lDistanceToMove, DWORD dwMoveMethod) {
		return SetFilePointer(m_hFile, lDistanceToMove, NULL, dwMoveMethod);
	}
	virtual DWORD GetLength() { 
		return GetFileSize(m_hFile, NULL);
	}

public:
	HANDLE m_hFile;
	DWORD  m_dwReadLength;
};

struct CFakeSFLReader : IFileReader {
private:
	struct FakeSFL {
		DWORD cue;
		DWORD adtl;
		DWORD _padding[2];
		DWORD dwIntroSamples;
		DWORD dwLoopSamples;
	};

public:
	CFakeSFLReader(DWORD dwIntroSamples, DWORD dwLoopSamples) :
		m_dwIntroSamples(dwIntroSamples), m_dwLoopSamples(dwLoopSamples) {}
	virtual ~CFakeSFLReader() {}

public:
	virtual bool Read(LPVOID lpBuffer, DWORD nNumberOfBytesToRead) {
		FakeSFL *fake = (FakeSFL *)lpBuffer;
		fake->cue  = MAKEFOURCC('c','u','e',' ');
		fake->adtl = MAKEFOURCC('a','d','t','l');
		fake->_padding[0] = fake->_padding[1] = 0;
		fake->dwIntroSamples = m_dwIntroSamples;
		fake->dwLoopSamples  = m_dwLoopSamples;
		return true;
	}
	virtual DWORD GetReadLength() { 
		return sizeof(FakeSFL);
	}
	virtual LONG Seek(LONG lDistanceToMove, DWORD dwMoveMethod) {
		return 0;
	}
	virtual DWORD GetLength() {
		return sizeof(FakeSFL);
	}

private:
	DWORD m_dwIntroSamples;
	DWORD m_dwLoopSamples;
};

struct CFileReaderPtr {
	CFileReader *m_pReader;
};

static struct {
	LPCSTR lpName;
	DWORD dwIntroSamples;
	DWORD dwLoopSamples;
	LPSTR lpCustomPath;
} s_entries[] = {
	"sr", 0, 0, NULL,
	"sr2", 0, 0, NULL,
	"op", 0, 0, NULL,
	"op2", 0, 0, NULL,
	"select", 0, 0, NULL,
	"room", 0, 0, NULL,
	"st00", 0, 0, NULL,
	"st01", 0, 0, NULL,
	"st02", 0, 0, NULL,
	"st03", 0, 0, NULL,
	"st04", 0, 0, NULL,
	"st05", 0, 0, NULL,
	"st06", 0, 0, NULL,
	"st07", 0, 0, NULL,
	"st08", 0, 0, NULL,
	"st09", 0, 0, NULL,
	"st10", 0, 0, NULL,
	"st11", 0, 0, NULL,
	"st12", 0, 0, NULL,
	"st13", 0, 0, NULL,
	"st14", 0, 0, NULL,
	"st15", 0, 0, NULL,
	"st16", 0, 0, NULL,
	"st17", 0, 0, NULL,
	"st18", 0, 0, NULL,
	"st19", 0, 0, NULL,
	"st20", 0, 0, NULL,
	"st21", 0, 0, NULL,
	"st22", 0, 0, NULL,
	"st30", 0, 0, NULL,
	"st31", 0, 0, NULL,
	"st32", 0, 0, NULL,
	"st33", 0, 0, NULL,
	"st34", 0, 0, NULL,
	"st35", 0, 0, NULL,
	"st36", 0, 0, NULL,
	"st40", 0, 0, NULL,
	"st41", 0, 0, NULL,
	"st42", 0, 0, NULL,
	"st43", 0, 0, NULL,
	"st99", 0, 0, NULL,
	"ta00", 0, 0, NULL,
	"ta01", 0, 0, NULL,
	"ta02", 0, 0, NULL,
	"ta03", 0, 0, NULL,
	"ta04", 0, 0, NULL,
	"ta05", 0, 0, NULL,
	"ta06", 0, 0, NULL,
	"ta07", 0, 0, NULL,
	"ta08", 0, 0, NULL,
	"ta20", 0, 0, NULL,
	"ta21", 0, 0, NULL,
	"ta22", 0, 0, NULL,
};

static bool (__fastcall *GetPackagedBGM)(IFileReader **pp, int, LPCSTR lpEntryName);
static bool (__fastcall *GetPackagedSFL)(IFileReader **pp, int, LPCSTR lpEntryName);

void * operator new(size_t _Size) { return SWRS_new(_Size); }
void operator delete(void *_Buf) { SWRS_delete(_Buf); }

int GetEntryIndex(LPCSTR lpEntryName)
{
	for(int i = 0; i < _countof(s_entries); ++i) {
		if(s_entries[i].lpCustomPath[0] != '\0' &&
		   StrStr(lpEntryName, s_entries[i].lpName)) {
			return i;
		}
	}
	return -1;
}

bool __fastcall OnGetPackagedBGM(IFileReader **pp, int, LPCSTR lpEntryName)
{
	int nEntryIndex = GetEntryIndex(lpEntryName);
	if(nEntryIndex < 0) {
		return GetPackagedBGM(pp, 0, lpEntryName);
	}

	if(*pp != NULL) {
		delete *pp;
		*pp = NULL;
	}
	*pp = new CFileReader(s_entries[nEntryIndex].lpCustomPath);

	if(*pp == NULL) {
		return GetPackagedBGM(pp, 0, s_entries[nEntryIndex].lpCustomPath);
	} else {
		return true;
	}
}

bool __fastcall OnGetPackagedSFL(IFileReader **pp, int, LPCSTR lpEntryName)
{
	int nEntryIndex = GetEntryIndex(lpEntryName);
	if(nEntryIndex < 0) {
		return GetPackagedSFL(pp, 0, lpEntryName);
	}

	if(*pp != NULL) {
		delete *pp;
		*pp = NULL;
	}
	*pp = new CFakeSFLReader(
			s_entries[nEntryIndex].dwIntroSamples,
			s_entries[nEntryIndex].dwLoopSamples);
	return true;
}

extern "C"
__declspec(dllexport) bool CheckVersion(const BYTE hash[16])
{
	return ::memcmp(TARGET_HASH, hash, sizeof TARGET_HASH) == 0;
}

extern "C"
__declspec(dllexport) bool Initialize(HMODULE hMyModule, HMODULE hParentModule)
{
	char szProfilePath[1024 + MAX_PATH];
	::GetModuleFileName(hMyModule, szProfilePath, 1024);
	::PathRemoveFileSpec(szProfilePath);
	::PathAppend(szProfilePath, "BGMChanger.ini");

	HANDLE hHeap = ::GetProcessHeap();
	for(int i = 0; i < _countof(s_entries); ++i) {
		s_entries[i].lpCustomPath = (LPSTR)::HeapAlloc(hHeap, 0, 1024);
		if (!s_entries[i].lpCustomPath) return FALSE;

		::GetPrivateProfileString(s_entries[i].lpName, "Path", "",
			s_entries[i].lpCustomPath, 1024, szProfilePath);
		s_entries[i].dwIntroSamples =
			::GetPrivateProfileInt(s_entries[i].lpName, "Intro", 0, szProfilePath);
		s_entries[i].dwLoopSamples =
			::GetPrivateProfileInt(s_entries[i].lpName, "Loop", 0, szProfilePath);
	}

	DWORD dwOldProtect;
	::VirtualProtect((PVOID)text_Offset, text_Size, PAGE_EXECUTE_WRITECOPY, &dwOldProtect);
	*(DWORD*)&GetPackagedBGM = TamperNearJmpOpr(0x00418791, (DWORD)OnGetPackagedBGM);
	*(DWORD*)&GetPackagedSFL = TamperNearJmpOpr(0x00418AF1, (DWORD)OnGetPackagedSFL);
	::VirtualProtect((PVOID)text_Offset, text_Size, dwOldProtect, &dwOldProtect);

	return TRUE;
}

extern "C"
int APIENTRY DllMain(HMODULE hModule, DWORD fdwReason, LPVOID lpReserved)
{
	return TRUE;
}
