=begin
$s	ݒ
=end


$negfile = []

require 'fileutils'

require "hk/default_setting"
require 'hk/hktable'

def check_order(name)
  a = []
  b = []
  for i in 0..9
    c = name + "order" + i.to_s
    if $s[c]
      $s[c] = 16 if a[$s[c]]
      a[$s[c]] = true
    else
      $s[c] = 16
    end
    c = name + "eorder" + i.to_s
    if $s[c]
      $s[c] = 16 if b[$s[c]]
      b[$s[c]] = true
    else
      $s[c] = 16
    end
  end
end

def conv_filename(name)
  return if $s[name] == nil
  $s[name].gsub!(/\\/, '/')
end

def conv_onoff(name)
  return if $s[name] == nil
  $s[name] = ($s[name] == "on") if String === $s[name]
end

def conv_int(name, flag=false)
  if flag
      $s[name] = 16 if $s[name] == nil
  else
    return if $s[name] == nil
  end
  $s[name] = $s[name].to_i
end

def conv_order(name, flag=false)
  flag2 = flag && $s[name]
  for i in 0..15
    conv_int(name + "order" + (i.to_s), flag2)
  end
  for i in 0..15
    conv_int(name + "eorder" + (i.to_s), flag2)
  end
end

def conv_custom(name)
  conv_onoff(name)
  conv_int(name + "sheetparam")
  $difftype_list.each {|item|
    conv_onoff(name + item)
  }
  conv_order(name)
end

def read_settingfile(filename)
  if File.file?(filename) then
    settingfile = open(filename, "r")
    
    while line = settingfile.gets
      next if /^#.*/ =~ line
      /(.*)\s*=\s*(.*)/s =~ line
      next unless $1 and $2
      $s[$1] = $2.chomp
    end
    settingfile.close
  end
  
  
  FileUtils.mkdir_p(File.dirname("output_filename0"))
  
  conv_filename('logfile')
  conv_filename('logfile2')
  conv_filename('savefile')
  for i in 0..9
    conv_filename('output_filename' + i.to_s)
  end
  conv_filename('replay_folder')
  conv_filename('replay_auto_save_folder')
  conv_onoff('copy_new_replay')
  conv_int('copy_new_replay_max')
  conv_int('copy_new_replay_pos')
  $s['replay_folder'] = '' unless File.exist?($s['replay_folder'])
  $s['replay_auto_save_folder'] = '' unless File.exist?($s['replay_auto_save_folder'])
  $s['copy_new_replay'] = false unless ($s['replay_folder'] != '' && $s['replay_auto_save_folder'] != '')
  $s['copy_new_replay_max'] = 99 if $s['copy_new_replay_max'] > 99
  $s['copy_new_replay_pos'] = 0 if $s['copy_new_replay_pos'] > $s['copy_new_replay_max'] || $s['copy_new_replay_pos'] < 0
  
  conv_onoff("total_recent")
  conv_int("total_limit")
  $s["total_recent"] = false if $s["total_limit"] < 1
  
  if ! $sheet_table0.find {|item| item[0] == $s["sheet"]}
    if ! $sheet_table1.find {|item| item[0] == $s["sheet"]}
      $s["sheet"] = $sheet_table0[0][0]
    end
  end
  conv_onoff("sort")
  conv_int("sheet_param")
  conv_int("border")
  
  conv_int("mainx")
  conv_int("mainy")
  conv_int("logx")
  conv_int("logy")
  conv_onoff("logshow")
  conv_int("selectx")
  conv_int("selecty")
  conv_onoff("selectshow")
  
  conv_custom("")
  
  conv_onoff("add_date")
  
  for i in 0..9
    negfile = $s["neglectprofile" + i.to_s]
    if negfile then
      $negfile.push(negfile)
    end
  end
  
  #JX^I[_[̕ϊ
  
  for i in 1..9
    name = "auto" + i.to_s
    conv_custom(name)
    if $s[name]
      FileUtils.mkdir_p(File.dirname($s["output_filename" + i.to_s]))
    end
  end
  
  for i in 0..9
    conv_custom("custom" + i.to_s)
  end
  
  for i in 0..9
    name = "co" + i.to_s
    conv_onoff(name)
    conv_order(name, true)
  end
end

def write_onoff(file, name)
  return if $s[name] == nil
  file.puts name + "=" + ($s[name] ? "on" : "off")
end

def write_str(file, name)
  return if $s[name] == nil
  file.puts name + "=" + $s[name].to_s
end

def write_custom(file, name)
  write_onoff(file, name)
  write_str(file, name + "caption")
  write_str(file, name + "sheet")
  write_str(file, name + "sheet_param")
  $difftype_list.each {|item|
    write_onoff(file, name + item)
  }
  for i in 0..15
    write_str(file, name + "name" + (i.to_s))
  end
  for i in 0..15
    write_str(file, name + "ename" + (i.to_s))
  end
  for i in 0..15
    write_str(file, name + "order" + (i.to_s))
  end
  for i in 0..15
    write_str(file, name + "eorder" + (i.to_s))
  end
end

def write_settingfile(filename = "hk/setting.txt")
  begin
    file = open(filename, "w")
  rescue
    return nil
  end
  
  file.puts "#logfile:Ԃ̋LOAlogfile2:ΐǉOAsavefile:Wvʂۑt@CAoutput_filename0:\̏o̓t@C"
  file.puts "logfile=" + $s["logfile"]
  file.puts "logfile2=" + $s["logfile2"]
  write_str(file, "savefile")
  file.puts "output_filename0=" + $s["output_filename0"]
  file.puts 
  file.puts "#VKvCvCtH_ɓKɃl[ĔzuBőXX"
  write_str(file,'replay_folder')
  write_str(file,'replay_auto_save_folder')
  write_onoff(file,'copy_new_replay')
  write_str(file,'copy_new_replay_name')
  write_str(file,'copy_new_replay_max')
  write_str(file,'copy_new_replay_pos')
  file.puts 
  file.puts "#total_recent:on ɂƑтōŐVm܂ŏWvBj[ύX"
  file.puts "#total_limit:ŐVm̂mB0ɂƑSWvBWv̏ꍇ΂bnl͖܂B܂Wvʂ̕ۑgƕۑɂĂ͏Wv܂"
  file.puts "total_recent=" + ($s["total_recent"] ? "on" : "off")
  file.puts "total_limit=" + $s["total_limit"].to_s
  file.puts "#ΐ퐔⏟Ȃǂ̕\őɃ\[g邩ۂ"
  file.puts "sort=" + ($s["sort"] ? "on" : "off")
  file.puts 
  file.puts "#sheet:\̎ށB\j[ɂ镶ł"
  file.puts "#sheet_param:̏gp"
  file.puts "#border:ς鎞i̓Iɂ͏ƕϑΐ펞ԁjAf[^̒lȉ̍ڂ̓f[^Ƃ݂Ȃ܂"
  file.puts "sheet=" + $s["sheet"]
  file.puts "sheet_param=" + $s["sheet_param"].to_s
  file.puts "border=" + $s["border"].to_s
  file.puts 
  file.puts "#EBhEʒuƂ"
  file.puts "mainx=" + $s["mainx"].to_s
  file.puts "mainy=" + $s["mainy"].to_s
  file.puts "logx=" + $s["logx"].to_s
  file.puts "logy=" + $s["logy"].to_s
  file.puts "logshow=" + ($s["logshow"] ? "on" : "off")
  file.puts "selectx=" + $s["selectx"].to_s
  file.puts "selecty=" + $s["selecty"].to_s
  file.puts "selectshow=" + ($s["selectshow"] ? "on" : "off")
  file.puts 
  file.puts "#ՓxAΐlA΂bnl̂nm^nee"
  $difftype_list.each {|item|
    write_onoff(file, item)
  }
  file.puts 
  file.puts "#L̕\"
  file.puts "#LƐƂ̑Ή͂Ă"
  for i in 0..15
    file.puts "name" + i.to_s + "=" + $s["name"+(i.to_s)]
  end
  file.puts 
  for i in 0..15
    file.puts "ename" + i.to_s + "=" + $s["ename"+(i.to_s)]
  end
  file.puts 
  file.puts '#L̕\iForder0=1 œԖڂɗ얲Aorde0=16 ŗ얲Wv珜O)'
  for i in 0..15
    file.puts "order" + i.to_s + "=" + $s["order"+(i.to_s)].to_s
  end
  file.puts 
  for i in 0..15
    file.puts "eorder" + i.to_s + "=" + $s["eorder"+(i.to_s)].to_s
  end
  file.puts 
  file.puts "#ΐ̒ǋL"
  file.puts "add_date=" + ($s["add_date"] ? "on" : "off")
  file.puts 
  file.puts "#Wv珜Ovt@C(0-9)BSv݂̂ł"
  file.puts "#Fneglectprofile0=ϐ.pro"
  $negfile.each_with_index {|name,i|
    file.puts "neglectprofile" + i.to_s + "=" + name
  }
  file.puts 
  file.puts "#óB auto0=on Ƃł낢돑Ă΂̐ݒŏɏo͂Ă͂iʓ|ɂȂ̂ŖeXgj"
  for i in 1..9
    next unless $s["output_filename"+(i.to_s)]
    file.puts "#o" + i.to_s
    write_str(file, "output_filename" + i.to_s)
    write_custom(file, "auto" + i.to_s)
    file.puts 
  end
  file.puts 
  file.puts "#JX^ݒBȗڂ͑IO̐ݒ肪g܂"
  file.puts "#ݒ胁j[xۑĂ݂΂ǂ킩Ǝv܂"
  for i in 0..9
    file.puts "#JX^" + i.to_s
    write_custom(file, "custom" + i.to_s)
    file.puts 
  end
  file.puts 
  file.puts "#JX^\BLבւWv珜Oł܂"
  file.puts "#order_sample.txt ɂRsyoTv܂"
  for j in 0..9
    file.puts "#JX^\" + (j.to_s)
    name = "co"+ (j.to_s)
    write_onoff(file, name)
    write_str(file, name + "caption")
    for i in 0..15
      write_str(file, name + "order" + (i.to_s))
    end
    for i in 0..15
      write_str(file, name + "eorder" + (i.to_s))
    end
  file.puts 
  end
  file.flush
end


#\o͗pp[^ݒ
def set_a_param(name, param)
  return $s[param] if $s[name+param] == nil
  return $s[name+param]
end

def set_difftype(name)
    $difftype_table.each_with_index {|item, i|
    diff,type = item
    $difftype[i] = set_a_param(name, diff) && set_a_param(name, type)
  }
end

def set_order(name)
  for i in 0..15
    $order[i] = set_a_param(name, "order" + (i.to_s))
    $eorder[i] = set_a_param(name, "eorder" + (i.to_s))
  end
  t = correct_order($order)
  t.each_with_index {|chara,i| $name[i] = set_a_param(name, "name" + (chara.to_s))}
  $nchara = t.size
  
  t = correct_order($eorder)
  t.each_with_index {|chara,i| $ename[i] = set_a_param(name, "ename" + (chara.to_s))}
  $nechara = t.size
end

def set_params(name)
  $difftype = []
  $order = []
  $eorder = []
  $name = []
  $ename = []
  
  $sheet = set_a_param(name, "sheet")
  $sheet_param = set_a_param(name, "sheet_param")
  
  set_difftype(name)
  set_order(name)
end

#aבւċtԂBdƂ\
def correct_order(a)
  t = []
  for i in 0..15
    a[i] = 16 if a[i] > 16
    t[a[i]] ? a[i]=16 : t[a[i]]=i
  end
  t[16] = nil
  t.delete_if {|item| !item}
  for i in 0..15
    a[i]=16
  end
  t.each_with_index {|chara,i| a[chara] = i}
  return t
end

#JX^ݒ̓ǂݍ
def change_params(name)
  
  $s["sheet"] = set_a_param(name, "sheet")
  $s["sheet_param"] = set_a_param(name, "sheet_param")
  
  $difftype_list.each_with_index {|item, i|
    $s[item] = set_a_param(name, item)
  }
  
  for i in 0..15
    $s["name" + (i.to_s)] = set_a_param(name, "name" + (i.to_s))
    $s["ename" + (i.to_s)] = set_a_param(name, "ename" + (i.to_s))
    $s["order" + (i.to_s)] = set_a_param(name, "order" + (i.to_s))
    $s["eorder" + (i.to_s)] = set_a_param(name, "eorder" + (i.to_s))
  end
end

#pack_array([[0,1],[2,3]]) => "2,2,2,0,1,2,3"
#He̗vf́Hvf̗񋓂̏
def pack_array(a)
  b = a
  t = []
  while Array === b
    t.push b.size
    b = b[0]
  end
  s = ""
  s += t.size.to_s + ","
  t.each {|i| s += i.to_s + ","}
  a.flatten.each {|i| s += i.to_s + ","}
  return s
end

#
def unpack_array(s)
  t = s.split(/,/)
  t.each_with_index {|item, i| t[i] = item.to_i}
  dim = t[0]
  t.shift
  size = t[0...dim]
  dim.times{t.shift}
  case dim
  when 1
    a = t
  when 3
    a = Array.new(size[0]) {
      Array.new(size[1]) {
        Array.new(size[2],0)
      }
    }
    for i in 0...size[0]
      for j in 0...size[1]
        for k in 0...size[2]
          a[i][j][k] = t[(i*size[1]+j)*size[2]+k]
        end
      end
    end
  when 4
    a = Array.new(size[0]) {
      Array.new(size[1]) {
        Array.new(size[2]) {
          Array.new(size[3],0)
        }
      }
    }
    for i in 0...size[0]
      for j in 0...size[1]
        for k in 0...size[2]
          for l in 0...size[3]
            a[i][j][k][l] = t[((i*size[1]+j)*size[2]+k)*size[3]+l]
          end
        end
      end
    end
  end
  return a
end

#JX^ݒ̓o^
def register_item(name, item)
  $s[name+item] = $s[item]
end

def register_custom(name)
  $s[name] = true
  register_item(name, "sheet")
  register_item(name, "sheet_param")
  $difftype_list.each {|item|
    register_item(name,item)
  }
  for i in 0..15
    register_item(name,"name" + (i.to_s))
    register_item(name,"ename" + (i.to_s))
    register_item(name,"order" + (i.to_s))
    register_item(name,"eorder" + (i.to_s))
  end
end


def sort_chara_down(data)
  rank = []
  for i in 0..15
    rank[$order[i]] = [i, $order[i]]
  end
  rank = rank.slice!(0,$nchara)
  rank = rank.sort {|a,b|
    - ( data[a[1]][$nechara] <=> data[b[1]][$nechara] )
  }
  name = $name
  $name = []
  rank.each_with_index {|item,i|
    $order[item[0]] = i
    $name[i] = name[item[1]]
  }
  
  rank = []
  for i in 0..15
    rank[$eorder[i]] = [i, $eorder[i]]
  end
  rank = rank.slice!(0,$nechara)
  rank = rank.sort {|a,b|
    - ( data[$nchara][a[1]] <=> data[$nchara][b[1]] )
  }
  ename = $ename
  $ename = []
  rank.each_with_index {|item,i|
    $eorder[item[0]] = i
    $ename[i] = ename[item[1]]
  }
end

