﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace IniFileEditor
{
    public partial class MainForm : Form
    {
        private static string configFilePath = "./config.ini";
        private static string configTag = "config";

        public MainForm()
        {
            InitializeComponent();
            init();
        }

        private void setCheckBoxValue(CheckBox checkBox, string name)
        {
            StringBuilder sb = new StringBuilder(1024);

            IniFileHandler.GetPrivateProfileString(configTag, name, "false", sb, (uint)sb.Capacity, configFilePath);
            try
            {
                checkBox.Checked = System.Convert.ToBoolean(sb.ToString());
            }
            catch (FormatException)
            {
                checkBox.Checked = false;
                IniFileHandler.WritePrivateProfileString(configTag, name, checkBox.Checked.ToString().ToLower(), configFilePath);
            }
        }

        private void setComboBox(ComboBox comboBox, string name, int defaultVal)
        {
            int val = (int)IniFileHandler.GetPrivateProfileInt(configTag, name, defaultVal, configFilePath);
            if ((val < 0) || (val >= comboBox.Items.Count))
            {
                val = defaultVal;
                IniFileHandler.WritePrivateProfileString(configTag, name, val.ToString(), configFilePath);
            }
            comboBox.SelectedIndex = val;
        }

        private void setTrackBar(TrackBar trackBar, string name, int defaultVal)
        {
            int val = (int)IniFileHandler.GetPrivateProfileInt(configTag, name, defaultVal, configFilePath);
            if ((val < trackBar.Minimum) || (val > trackBar.Maximum))
            {
                val = defaultVal;
                IniFileHandler.WritePrivateProfileString(configTag, name, val.ToString(), configFilePath);
            }
            trackBar.Value = val;
        }

        private void init()
        {
            setComboBox(statusComboBox, "status", 0);
            setComboBox(positionComboBox, "position", 3);
            setTrackBar(positionTrackBar, "position_slide", 640);
            setComboBox(guardComboBox, "guard", 1);
            setComboBox(counterComboBox, "counter", 1);
            setComboBox(breakFallComboBox, "break_fall", 3);
            setComboBox(getUpComboBox, "get_up", 3);
            setComboBox(reversalComboBox, "reversal", 3);

            setCheckBoxValue(groundStandCheckBox, "reversal_execute['5']");
            setCheckBoxValue(groundSquatCheckBox, "reversal_execute['2']");
            setCheckBoxValue(groundFrontCheckBox, "reversal_execute['6']");
            setCheckBoxValue(groundBackCheckBox, "reversal_execute['4']");
            setCheckBoxValue(jumpUpCheckBox, "reversal_execute['8']");
            setCheckBoxValue(jumpFrontCheckBox, "reversal_execute['9']");
            setCheckBoxValue(jumpBackCheckBox, "reversal_execute['7']");
            setCheckBoxValue(hiJumpUpCheckBox, "reversal_execute['8D']");
            setCheckBoxValue(hiJumpFrontCheckBox, "reversal_execute['9D']");
            setCheckBoxValue(hiJumpBackCheckBox, "reversal_execute['7D']");
            setCheckBoxValue(attackACheckBox, "reversal_execute['A']");
            setCheckBoxValue(attack2ACheckBox, "reversal_execute['2A']");
            setCheckBoxValue(attack3ACheckBox, "reversal_execute['3A']");
            setCheckBoxValue(attack6ACheckBox, "reversal_execute['6A']");
            setCheckBoxValue(attack623BCheckBox, "reversal_execute['623B']");
            setCheckBoxValue(attack623CCheckBox, "reversal_execute['623C']");
            setCheckBoxValue(customCheckBox, "reversal_execute[reversal_execute_custom]");

            StringBuilder sb = new StringBuilder(1024);
            IniFileHandler.GetPrivateProfileString(configTag, "reversal_execute_custom", "", sb, (uint)sb.Capacity, configFilePath);
            customTextBox.Text = sb.ToString();
        }

        private void オプションToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }

        private void statusComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "status", statusComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void positionComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "position", positionComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void positionTrackBar_Scroll(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "position_slide", positionTrackBar.Value.ToString(), configFilePath);
        }

        private void guardComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "guard", guardComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void counterComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "counter", counterComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void breakFallComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "break_fall", breakFallComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void getUpComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "get_up", getUpComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void reversalComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal", reversalComboBox.SelectedIndex.ToString(), configFilePath);
        }

        private void groundStandCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['5']", groundStandCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void groundSquatCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['2']", groundSquatCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void groundFrontCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['6']", groundFrontCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void groundBackCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['4']", groundBackCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void jumpUpCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['8']", jumpUpCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void jumpFrontCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['9']", jumpFrontCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void jumpBackCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['7']", jumpBackCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void hiJumpUpCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['8D']", hiJumpUpCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void hiJumpFrontCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['9D']", hiJumpFrontCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void hiJumpBackCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['7D']", hiJumpBackCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attackACheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['A']", attackACheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attack2ACheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['2A']", attack2ACheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attack3ACheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['3A']", attack3ACheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attack6ACheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['6A']", attack6ACheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attack623BCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['623B']", attack623BCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void attack623CCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute['623C']", attack623CCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void customCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute[reversal_execute_custom]", customCheckBox.Checked.ToString().ToLower(), configFilePath);
        }

        private void customTextBox_TextChanged(object sender, EventArgs e)
        {
            IniFileHandler.WritePrivateProfileString(configTag, "reversal_execute_custom", "\"" + customTextBox.Text + "\"", configFilePath);
        }
    }
}
