#require "pp"
require "csv"
require "hk/outputhtml"
=begin
require "benchmark"
puts Benchmark::CAPTION
puts Benchmark.measure {
}
=end


class CSVEntry
  def initialize(line = nil)
    @entry = {}
    init(line)
  end
  
  def init(line)
    CSV.parse(line).flatten.each_with_index {|elem,i|
      @entry[elem] = i
    }
  end
  
  def [](key)
    @entry[key]
  end
  
  def inspect
    @entry.inspect
  end
end

class HKRecord
  attr_accessor :chara		#0-15, Ԃ̋L̕\Ɠ K{
  attr_accessor :echara		#
  attr_accessor :win			#0:loose, 1:win
  attr_accessor :nround			#2 or 3
  attr_accessor :side			#0:1P, 1:2P
  attr_accessor :playtime		#ΐt[
  attr_accessor :enemyname
  attr_accessor :difftype		#Փx(0-3){̎(0:"Human",4:"COM")
  attr_accessor :profname		#ۑvt@C
  attr_accessor :playtimeR		#Ehʑΐt[̔z
end

def hkparse(entry, csv)		#HKEntryCSVf[^s
  line = CSV.parse(csv).flatten
  record = HKRecord.new
  record.chara = line[entry["L"]].to_i
  record.echara = line[entry["L"]].to_i
  record.win = (line[entry[""]] == "") ? nil : (line[entry[""]].to_i)
  record.nround = (line[entry[""]] == "") ? nil : (line[entry[""]].to_i)
  record.side = (line[entry["쑤"]] == "") ? nil : (line[entry["쑤"]].to_i)
  record.playtime = (line[entry[""]] == "") ? nil : (line[entry[""]].to_i)
  record.difftype = line[entry["Փx"]].to_i
  name = record.enemyname = line[entry["ΐ푊薼"]]
  if (name == "EasyCPU" or name == "NormalCPU" or name == "HardCPU" or name == "LunaCPU") then
    record.difftype += 4
  end
  record.profname = line[entry["ۑvt@C"]]
  record.playtimeR = [0,0,0]
  for i in 0..2
    record.playtimeR[i] = line[entry["(" + (i+1).to_s + "R)"]].to_i
  end
  return record
end




class HKShukei
  attr_accessor :setting
  attr_accessor :_nmatch
  attr_accessor :_win_n
  attr_accessor :_nwin
  attr_accessor :_nwin2
  attr_accessor :_playtime_n
  attr_accessor :_playtimemax
  attr_accessor :_playtimetotal
  attr_accessor :_n1P
  attr_accessor :_n2P
  attr_accessor :_playtimemaxR
  
  attr_accessor :charaname
  
  def save_shukei(filename)
    begin
      file = open(filename, "w")
    rescue
      return nil
    end
    
    file.puts "@nmatch=" + pack_array(@nmatch)
    file.puts "@win_n=" + pack_array(@win_n)
    file.puts "@nwin=" + pack_array(@nwin)
    file.puts "@nwin2=" + pack_array(@nwin2)
    file.puts "@playtime_n=" + pack_array(@playtime_n)
    file.puts "@playtimetotal=" + pack_array(@playtimetotal)
    file.puts "@playtimemax=" + pack_array(@playtimemax)
    file.puts "@playtimemaxR=" + pack_array(@playtimemaxR)
    file.puts "@n1P=" + pack_array(@n1P)
    file.puts "@n2P=" + pack_array(@n2P)
    
    file.close
  end
  
  def load_shukei(filename)
    begin
      file = open(filename, "r")
    rescue
      return nil
    end
    
    while line = file.gets
      /(.*)=(.*)/ =~ line
      t = unpack_array($2.chomp)
      
      case $1
      when "@nmatch"
        @nmatch = t
      when "@win_n"
        @win_n = t
      when "@nwin"
        @nwin = t
      when "@nwin2"
        @nwin2 = t
      when "@playtime_n"
        @playtime_n = t
      when "@playtimetotal"
        @playtimetotal = t
      when "@playtimemax"
        @playtimemax = t
      when "@playtimemaxR"
        @playtimemaxR = t
      when "@n1P"
        @n1P = t
      when "@n2P"
        @n2P = t
      end
    end
    
    file.close
  end
  
  def initialize(logfile)
    @nmatch = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @win_n = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @nwin = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @nwin2 = Array.new(4) {
      Array.new(8) {
        Array.new(16) {
          Array.new(16,0)
        }
      }
    }
    @playtime_n = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @playtimetotal = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @playtimemax = Array.new(8) {
      Array.new(16) {
        Array.new(16,0)
      }
    }
    @n1P = Array.new(8,0)
    @n2P = Array.new(8,0)
    @playtimemaxR = Array.new(4) {
      Array.new(8) {
        Array.new(16) {
          Array.new(16,0)
        }
      }
    }
    
    load_shukei($s["savefile"]) if $s["savefile"]
    
    if $s["total_limit"] > 0
      @recent_data = []
      @recent_count = 0
    end
    
    @hkentry = CSVEntry.new(logfile.gets)
    while line = logfile.gets
      update(line)
    end
  end
  
  def update(line)		#HKRecord
    hkrecord = hkparse(@hkentry, line)
    chara = hkrecord.chara
    echara = hkrecord.echara
    win = hkrecord.win
    nround = hkrecord.nround
    side = hkrecord.side
    playtime = hkrecord.playtime
    enemyname = hkrecord.enemyname
    difftype = hkrecord.difftype
    profname = hkrecord.profname
    playtimeR = hkrecord.playtimeR
    
    if ($s["total_limit"] > 0) && (difftype < 4)
      @recent_data[@recent_count % $s["total_limit"]] = hkrecord
      @recent_count += 1
    end
      
    return if $negfile.include?(profname)
    
    @nmatch[difftype][chara][echara] += 1
    
    if side == 0 then
      @n1P[difftype] += 1
    elsif side == 1 then
      @n2P[difftype] += 1
    end
    
    if win then
      @win_n[difftype][chara][echara] += 1
      if win == 1 then
        @nwin[difftype][chara][echara] += 1
      end
    end
    
    if win and nround then
      if win == 1 and nround == 2 then
        @nwin2[0][difftype][chara][echara] += 1
      elsif win == 1 and nround == 3 then
        @nwin2[1][difftype][chara][echara] += 1
      elsif win == 0 and nround == 3 then
        @nwin2[2][difftype][chara][echara] += 1
      elsif win == 0 and nround == 2 then
        @nwin2[3][difftype][chara][echara] += 1
      end
    end
    
    if playtime then
      @playtime_n[difftype][chara][echara] += nround
      @playtimetotal[difftype][chara][echara] += playtime
      if playtime > @playtimemax[difftype][chara][echara] then
        @playtimemax[difftype][chara][echara] = playtime
      end
    end
    
    if win and nround and playtimeR[0]>0 then
      t = 0
      for i in 0...nround
        if playtimeR[i] > @playtimemaxR[i][difftype][chara][echara] then
          @playtimemaxR[i][difftype][chara][echara] = playtimeR[i]
        end
        if playtimeR[i] > t then
          t = playtimeR[i]
        end
      end
      if t > @playtimemaxR[3][difftype][chara][echara] then
        @playtimemaxR[3][difftype][chara][echara] = t
      end
    end
    
    return hkrecord
  end
  
  def total_sum(a)
    t = 0
    for i in 0..15
      for j in 0..15
        if ($order[i] < 16) && ($eorder[j] < 16)
          t += a[i][j]
        end
      end
    end
    return t
  end
  
  def total_max(a)
    t = 0
    for i in 0..15
      for j in 0..15
        if ($order[i] < 16) && ($eorder[j] < 16)
          t = a[i][j] if a[i][j] > t
        end
      end
    end
    return t
  end
  
  def get_total
    @_nmatch = 0
    @_win_n = 0
    @_nwin = 0
    @_nwin2 = [0,0,0,0]
    @_playtime_n = 0
    @_playtimemax = 0
    @_playtimetotal = 0
    @_n1P = @_n2P = 0
    @_playtimemaxR = [0,0,0,0]
    
    if $s["total_limit"] == 0
      for dt in 0..7
        next unless $difftype[dt]
        @_nmatch += total_sum(@nmatch[dt])
        @_win_n += total_sum(@win_n[dt])
        @_nwin += total_sum(@nwin[dt])
        for i in 0..3
          @_nwin2[i] += total_sum(@nwin2[i][dt])
        end
        @_playtime_n += total_sum(@playtime_n[dt])
        @_playtimetotal += total_sum(@playtimetotal[dt])
        max = total_max(@playtimemax[dt])
        @_playtimemax = max if max > @_playtimemax
        @_n1P += @n1P[dt]
        @_n2P += @n2P[dt]
        for i in 0..2
          max = total_max(@playtimemaxR[i][dt])
          @_playtimemaxR[i] = max if max > @_playtimemaxR[i]
        end
      end
    else
      @recent_data.each {|item|
        next if $negfile.include?(item.profname)
        next unless $s[$diff_table[item.difftype]]
        @_nmatch += 1
        if item.side == 0 then
          @_n1P += 1
        elsif item.side == 1 then
          @_n2P += 1
        end
        if item.win then
          @_win_n += 1
          if item.win == 1 then
            @_nwin += 1
          end
        end
        
        if item.win and item.nround then
          if item.win == 1 and item.nround == 2 then
            @_nwin2[0] += 1
          elsif item.win == 1 and item.nround == 3 then
            @_nwin2[1] += 1
          elsif item.win == 0 and item.nround == 3 then
            @_nwin2[2] += 1
          elsif item.win == 0 and item.nround == 2 then
            @_nwin2[3] += 1
          end
        end
        
        if item.playtime then
          @_playtime_n += item.nround
          @_playtimetotal += item.playtime
          if item.playtime > @_playtimemax then
            @_playtimemax = item.playtime
          end
        end
        
        if item.win and item.nround and item.playtimeR[0]>0 then
          t = 0
          for i in 0...(item.nround)
            if item.playtimeR[i] > @_playtimemaxR[i] then
              @_playtimemaxR[i] = item.playtimeR[i]
            end
            if item.playtimeR[i] > t then
              t = item.playtimeR[i]
            end
          end
          if t > @_playtimemaxR[3] then
            @_playtimemaxR[3] = t
          end
        end
      }
    end
  end
  
  def make_sum(a)
    t = Array.new($nchara+1) {Array.new($nechara+1,0)}
    for i in 0..15
      next unless $order[i] < 16
      for j in 0..15
        next unless $eorder[j] < 16
        for dt in 0..7
          t[$order[i]][$order[j]] += a[dt][i][j] if $difftype[dt]
        end
      end
    end
    for i in 0...$nchara
      for j in 0...$nechara
        t[i][$nechara] += t[i][j]
      end
    end
    for j in 0..$nechara
      for i in 0...$nchara
        t[$nchara][j] += t[i][j]
      end
    end
    return t
  end
  
  def make_max(a)
    t = Array.new($nchara+1) {Array.new($nechara+1,0)}
    for i in 0..15
      next unless $order[i] < 16
      for j in 0..15
        next unless $eorder[j] < 16
        for dt in 0..7
          if $difftype[dt] && (a[dt][i][j] > t[$order[i]][$order[j]])
            t[$order[i]][$order[j]] = a[dt][i][j]
          end
        end
      end
    end
    for i in 0...$nchara
      for j in 0...$nechara
        t[i][$nechara] = t[i][j] if t[i][j] > t[i][$nechara]
      end
    end
    for j in 0..$nechara
      for i in 0...$nchara
        t[$nchara][j] = t[i][j] if t[i][j] > t[$nchara][j]
      end
    end
    return t
  end
  
  def set_name(sheet, first="" , last="v")
    sheet[0][0] = first
    for i in 0...$nchara
      sheet[i+1][0] = $name[i]
    end
    sheet[$nchara+1][0] = last
    for j in 0...$nchara
      sheet[0][j+1] = $ename[j]
    end
    sheet[0][$nechara+1] = last
  end
  
  def nmatch_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = make_sum(@nmatch)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        sheet[i+1][j+1] = (data[i][j]>0) ? data[i][j] : "_"
      end
    end
    
    outputhtml("ΐ", sheet, $outfile)
  end
  
  def nwin_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data0 = make_sum(@nwin)
    data1 = make_sum(@win_n)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        sheet[i+1][j+1] = (data1[i][j]>0) ? data0[i][j] : "_"
      end
    end
    outputhtml("", sheet, $outfile)
  end
  
  def nwinloose_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data0 = make_sum(@nwin)
    data1 = make_sum(@win_n)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        win = data0[i][j]
        n = data1[i][j]
        sheet[i+1][j+1] = n>0 ? (win.to_s + "/" + (n-win).to_s) : "_"
      end
    end
    outputhtml("s", sheet, $outfile)
  end
  
  def nwin2_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0..16
      for j in 0..16
        t = 0
        for k in 0..3
          t += data[k][i][j]
        end
        if t == 0 then
          sheet[i+1][j+1] = "<table><tr><td>_</td></tr><tr><td>_</td></tr></table>"
        else
          s = ""
          s = "<table><tr><td>"
          s += data[0][i][j].to_s + "/" + data[1][i][j].to_s
          s += "</td></tr><tr><td>"
          s += data[2][i][j].to_s + "/" + data[3][i][j].to_s
          s += "</td></tr></table>"
          sheet[i+1][j+1] = s
        end
      end
    end
    outputhtml("s񐔏ڍ", sheet, $outfile)
  end
  
  def winrate_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data0 = make_sum(@nwin)
    data1 = make_sum(@win_n)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        win = data0[i][j]
        n = data1[i][j]
        if n > $s["border"]
          sheet[i+1][j+1] = (win.to_f*100/n).to_s[0,5] + "%"
        else
          sheet[i+1][j+1] = "_"
        end
      end
    end
    outputhtml("", sheet, $outfile)
  end
  
  def playtimemax_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = make_max(@playtimemax)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        if data[i][j] == 0 then
          sheet[i+1][j+1] = "_"
        else
          a = data[i][j]
          a = a / 60
          b = a % 60
          a = a / 60
          sheet[i+1][j+1] = a.to_s + ":"
          sheet[i+1][j+1] += "0" if b < 10
          sheet[i+1][j+1] += b.to_s
          end
      end
    end
    outputhtml("Œΐ펞ԁiꎎj", sheet, $outfile)
  end
  
  def playtimeave_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data0 = make_sum(@playtimetotal)
    data1 = make_sum(@playtime_n)
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        time = data0[i][j]
        n = data1[i][j]
        if n > $s["border"]
          a = time / n
          a = a / 60
          b = a % 60
          a = a / 60
          sheet[i+1][j+1] = a.to_s + ":"
          sheet[i+1][j+1] += "0" if b < 10
          sheet[i+1][j+1] += b.to_s
        else
          sheet[i+1][j+1] = "_"
        end
      end
    end
    outputhtml("ϑΐ펞ԁiEhj", sheet, $outfile)
  end
  
  def playtimemaxR_show(round)
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = make_max(@playtimemaxR[round])
    set_name(sheet)
    for i in 0..$nchara
      for j in 0..$nechara
        if data[i][j] == 0 then
          sheet[i+1][j+1] = "_"
        else
          a = data[i][j]
          a = a / 60
          b = a % 60
          a = a / 60
          sheet[i+1][j+1] = a.to_s + ":"
          sheet[i+1][j+1] += "0" if b < 10
          sheet[i+1][j+1] += b.to_s
          end
      end
    end
    if round < 3 then
      outputhtml("Œΐ펞ԁi" + (round+1).to_s + "Rj", sheet, $outfile)
    else 
      outputhtml("Œΐ펞ԁiEhj", sheet, $outfile)
    end
  end
  
  def ach_make_sum(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        sheet[i+1][$nechara+1] += sheet[i+1][j+1]=="@" ? 1 : 0
      end
    end
    for j in 0...$nechara
      for i in 0...$nchara
        sheet [$nchara+1][j+1] += sheet[i+1][j+1]=="@" ? 1 : 0
      end
    end
    for i in 0...$nchara
      sheet[$nchara+1][$nechara+1] += sheet[i+1][$nechara+1]
    end
  end
  
  def ach_0_2_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        t = 0
        for k in 0..3
          t += data[k][i][j]
        end
        sheet[i+1][j+1] = t > 0 ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml("BFΐ", sheet, $outfile)
  end
  
  def ach_1_2_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        t = 0
        for k in 0..2
          t += data[k][i][j]
        end
        sheet[i+1][j+1] = t > 0 ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml("BF1-2ȏ", sheet, $outfile)
  end
  
  def ach_2_1_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        t = 0
        for k in 0..1
          t += data[k][i][j]
        end
        sheet[i+1][j+1] = t > 0 ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml("BF2-1ȏ", sheet, $outfile)
  end
  
  def ach_2_0_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        sheet[i+1][j+1] = data[0][i][j] > 0 ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml("BF2-0", sheet, $outfile)
  end
  
  def ach_make_sum2(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        case sheet[i+1][j+1]
        when "11"
          sheet[i+1][$nechara+1] += 1
        when "22"
          sheet[i+1][$nechara+1] += 2
        when "3333"
          sheet[i+1][$nechara+1] += 3
        when "4444"
          sheet[i+1][$nechara+1] += 4
        end
      end
    end
    for j in 0...$nechara
      for i in 0...$nchara
        case sheet[i+1][j+1]
        when "11"
          sheet [$nchara+1][j+1] += 1
        when "22"
          sheet [$nchara+1][j+1] += 2
        when "3333"
          sheet [$nchara+1][j+1] += 3
        when "4444"
          sheet [$nchara+1][j+1] += 4
        end
      end
    end
    for i in 0...$nchara
      sheet[$nchara+1][$nechara+1] += sheet[i+1][$nechara+1]
    end
  end
  
  def ach_win_show
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = []
    for k in 0..3
      data[k] = make_sum(@nwin2[k])
    end
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        if data[0][i][j] > 0
          t = "4444"
        elsif data[1][i][j] > 0
          t = "3333"
        elsif data[2][i][j] > 0
          t = "22"
        elsif data[3][i][j] > 0
          t = "11"
        else
          t = "."
        end
        sheet[i+1][j+1] = t
      end
    end
    ach_make_sum2(sheet)
    outputhtml("BF", sheet, $outfile)
  end
  
  def ach_tmax(time, caption="BFŒԁiEhj")
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data = make_max(@playtimemaxR[3])
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        sheet[i+1][j+1] = data[i][j] > time*60 ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml(caption, sheet, $outfile)
  end
  
  def ach_tave(time, caption="BFώԁiEhj")
    sheet = Array.new($nchara+2) {Array.new($nechara+2,0)}
    data0 = make_sum(@playtimetotal)
    data1 = make_sum(@playtime_n)
    set_name(sheet)
    for i in 0...$nchara
      for j in 0...$nechara
        sheet[i+1][j+1] = data0[i][j] > time*60*data1[i][j] ? "@" : "_"
      end
    end
    ach_make_sum(sheet)
    outputhtml(caption, sheet, $outfile)
  end
end
