----------------------------------------------------------------------------------------------------------
-- 
----------------------------------------------------------------------------------------------------------
ActionManager=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:constructor(enable)
		self.running = running;
		self.selectors = {};
		self.interrupters = {};
		self.player = ActionPlayer.new();
		self.interruptPlayer = ActionPlayer.new();
		self.evaluateAverageTable = {};			-- fobOp
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:addSelector(selector, actionSituation)
		table.insert(self.selectors, ActionSelectorHolder.new(selector, actionSituation));
		self.evaluateAverageTable[selector.name] = AverageCalculator.new();
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:addInterrupter(interrupter, interruptSituation)
		table.insert(self.interrupters, ActionSelectorHolder.new(interrupter, interruptSituation));
		self.evaluateAverageTable[interrupter.name] = AverageCalculator.new();
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:action()
		while (not battleFinished())
		do
			self.running = runningAction;
			if (self.running)
			then
				-- I[gK[hȈՎ
				if (recommendGuard(TARGET_MY, 80))
				then
					logger:debug("ActionManager", "I[gK[hI");
					key_off(ACT_DOWNLEFT);
					key_off(ACT_DOWNRIGHT);
					key_off(ACT_UPLEFT);
					key_off(ACT_UPRIGHT);
					key_off(ACT_UP);
					key_off(ACT_DOWN);
					key_off(ACT_A);
					key_off(ACT_B);
					key_off(ACT_C);
					key_off(ACT_D);
					key_off(ACT_AB);
					key_off(ACT_BC);

					key_on(back);

					-- I[gK[hb
					for i = 0, 15
					do
						if (isGuardMotion(tracer[TARGET_MY]:current().act))
						then
							-- E\h~[u
							wait(20);
							break;
						end
						yield();
					end
					self.player:reset();
					self.interruptPlayer:reset();
				else
					self:interrupt();
					self:play();
				end
			else
				-- vC[~yield|B
				yield();
			end
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:interrupt()
		local counter=0;
		local inInterrupting = false;
		while (self:interrupting())
		do
			inInterrupting = true;
			counter = counter + 1;
			if (counter >= 300)
			then
				error("[vC" .. counter);
			end
			-- ݈ȊO̍sƂ܂̂ŏ
			self.player:reset();

			-- I[gK[hȈՎ
			if (recommendGuard(TARGET_MY, 80))
			then
				logger:debug("ActionManager", "InterruptI[gK[hI");
				key_off(ACT_DOWNLEFT);
				key_off(ACT_DOWNRIGHT);
				key_off(ACT_UPLEFT);
				key_off(ACT_UPRIGHT);
				key_off(ACT_UP);
				key_off(ACT_DOWN);
				key_off(ACT_A);
				key_off(ACT_B);
				key_off(ACT_C);
				key_off(ACT_D);
				key_off(ACT_AB);
				key_off(ACT_BC);

				key_on(back);

				-- I[gK[hb
				for i = 0, 15
				do
					if (isGuardMotion(tracer[TARGET_MY]:current().act))
					then
						-- E\h~[u
						wait(20);
						break;
					end
					yield();
				end
				self.player:reset();
				self.interruptPlayer:reset();
			end

			-- ݍs
			if (not self.interruptPlayer.playing)
			then
				self.interruptPlayer:reset();
				local captureInfo = self:select(self.interrupters);
				if (captureInfo == nil)
				then
					logger:trace(self.name, "IsȂ");
					yield(); -- IȂȂ󋵐i߂邽߂yield();
					break;
				end
				self.interruptPlayer:initialize(captureInfo);
			else
				logger:trace("ActionManager", "interruptPlayerĐ phase:" .. self.interruptPlayer.phase .. 
											  " act:" .. self.interruptPlayer.playingCaptureInfo.act);
				self.interruptPlayer:forward();
			end
		end
		if (inInterrupting and not self:interrupting())
		then
			print(" 荞݂ʂII");
		end
		self.interruptPlayer:reset();
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:interrupting()
		local interrupting = false;
		for key, holder in pairs(self.interrupters)
		do
			interrupting = interrupting or holder.actionSituation(TARGET_MY);
		end
		return interrupting;
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:play()
		if (not self.player.playing)
		then
			logger:trace("ActionManager", "player");
			-- sI
			local captureInfo = self:select(self.selectors);
			if (captureInfo == nil)
			then
				logger:trace(self.name, "IsȂ");
				yield(); -- IȂȂ󋵐i߂邽߂yield();
				return;
			end
			-- ŃJ[hI݂B
			tryTargetCardSelect(captureInfo);
			-- Player
			self.player:initialize(captureInfo);
		else		
			logger:trace("ActionManager", "playerĐ phase:" .. self.player.phase .. 
										  " act:" .. self.player.playingCaptureInfo.act);
			self.player:forward();
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionManager:select(selectors)
		local assertAllFalse = false;
		local result, evaluate = nil, nil;
		for key, holder in pairs(selectors)
		do
			assertAllFalse = assertAllFalse or holder.actionSituation(TARGET_MY);
			if (holder.actionSituation(TARGET_MY))
			then
				-- 󋵂͒ς킯炢ˁB
				result, evaluate = holder.selector:select(tracer[TARGET_MY]:current());
				--result, evaluate = holder.selector:select(tracer[TARGET_MY]:tracedCurrent());
				if (result ~= nil)
				then
					-- fobOp
					if (not self.player.playing)
					then
						if (isBlowMotion(result.act))
						then
							self.evaluateAverageTable[holder.selector.name]:addValue(evaluate, 1);
						end
						logger:debug(holder.selector.name, "ōsIB]:" .. evaluate ..
																		 " {[_[:" .. holder.selector.border);
					end
					break;
				end
			end
		end
		--assert(assertAllFalse, "słȂȂI ");
		return result, evaluate;
	end

----------------------------------------------------------------------------------------------------------
-- 
----------------------------------------------------------------------------------------------------------
ActionSelectorHolder=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- 
	----------------------------------------------------------------------------------------------------------
	function ActionSelectorHolder:constructor(selector, actionSituation)
		self.selector = selector;
		self.actionSituation = actionSituation;
	end
	